/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.ByteArrayPool;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.StringOpsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\rH\u0002J\u0011\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u000bH\u0082\bJ\u0011\u0010\u0013\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000bH\u0082\bJ\t\u0010\"\u001a\u00020\u000bH\u0082\bJ\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lkotlinx/serialization/json/internal/JsonToJavaStreamWriter;", "Lkotlinx/serialization/json/internal/InternalJsonWriter;", "stream", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "buffer", "", "charArray", "", "indexInBuffer", "", "writeLong", "", "value", "", "writeChar", "char", "", "write", "text", "", "writeQuoted", "appendStringSlowPath", "currentSize", "string", "ensureTotalCapacity", "oldSize", "additional", "release", "flush", "ensure", "bytesCount", "byte", "rest", "writeUtf8", "count", "writeUtf8CodePoint", "codePoint", "kotlinx-serialization-json"})
public final class JsonToJavaStreamWriter
implements InternalJsonWriter {
    private final OutputStream stream;
    private final byte[] buffer;
    private char[] charArray;
    private int indexInBuffer;

    public JsonToJavaStreamWriter(OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"");
        this.stream = outputStream;
        this.buffer = ByteArrayPool.INSTANCE.take();
        this.charArray = CharArrayPool.INSTANCE.take();
    }

    @Override
    public void writeLong(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void writeChar(char c) {
        this.writeUtf8CodePoint(c);
    }

    @Override
    public void write(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = string.length();
        this.ensureTotalCapacity(0, n);
        String string2 = string;
        char[] cArray = this.charArray;
        int n2 = 0;
        int n3 = 0;
        string2.getChars(n3, n, cArray, n2);
        this.writeUtf8(this.charArray, n);
    }

    @Override
    public void writeQuoted(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.ensureTotalCapacity(0, string.length() + 2);
        char[] cArray = this.charArray;
        cArray[0] = 34;
        int n = string.length();
        String string2 = string;
        int n2 = 1;
        int n3 = 0;
        string2.getChars(n3, n, cArray, n2);
        n2 = 1 + n;
        for (int i = 1; i < n2; ++i) {
            n3 = cArray[i];
            if (n3 >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[n3] == 0) continue;
            this.appendStringSlowPath(i, string);
            return;
        }
        cArray[n + 1] = 34;
        this.writeUtf8(cArray, n + 2);
        this.flush();
    }

    private final void appendStringSlowPath(int n, String string) {
        int n2 = n;
        int n3 = string.length();
        for (int i = n - 1; i < n3; ++i) {
            n2 = this.ensureTotalCapacity(n2, 2);
            char c = string.charAt(i);
            if (c < StringOpsKt.getESCAPE_MARKERS().length) {
                byte by = StringOpsKt.getESCAPE_MARKERS()[c];
                if (by == 0) {
                    this.charArray[n2++] = c;
                    continue;
                }
                if (by == 1) {
                    String string2;
                    Intrinsics.checkNotNull((Object)StringOpsKt.getESCAPE_STRINGS()[c]);
                    n2 = this.ensureTotalCapacity(n2, string2.length());
                    String string3 = string2;
                    char[] cArray = this.charArray;
                    int n4 = 0;
                    int n5 = string2.length();
                    string3.getChars(n4, n5, cArray, n2);
                    n2 += string2.length();
                    continue;
                }
                this.charArray[n2] = 92;
                this.charArray[n2 + 1] = (char)by;
                n2 += 2;
                continue;
            }
            this.charArray[n2++] = c;
        }
        this.ensureTotalCapacity(n2, 1);
        this.charArray[n2++] = 34;
        this.writeUtf8(this.charArray, n2);
        this.flush();
    }

    private final int ensureTotalCapacity(int n, int n2) {
        int n3 = n + n2;
        if (this.charArray.length <= n3) {
            char[] cArray = Arrays.copyOf(this.charArray, RangesKt.coerceAtLeast((int)n3, (int)(n * 2)));
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"");
            this.charArray = cArray;
        }
        return n;
    }

    @Override
    public void release() {
        this.flush();
        CharArrayPool.INSTANCE.release(this.charArray);
        ByteArrayPool.INSTANCE.release(this.buffer);
    }

    private final void flush() {
        this.stream.write(this.buffer, 0, this.indexInBuffer);
        this.indexInBuffer = 0;
    }

    private final void ensure(int n) {
        boolean bl = false;
        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
        boolean bl2 = false;
        if (jsonToJavaStreamWriter.buffer.length - jsonToJavaStreamWriter.indexInBuffer < n) {
            this.flush();
        }
    }

    private final void write(int n) {
        boolean bl = false;
        int n2 = this.indexInBuffer;
        this.indexInBuffer = n2 + 1;
        this.buffer[n2] = (byte)n;
    }

    private final int rest() {
        boolean bl = false;
        return this.buffer.length - this.indexInBuffer;
    }

    private final void writeUtf8(char[] cArray, int n) {
        if (!(n >= 0)) {
            boolean bl = false;
            String string = "count < 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n <= cArray.length)) {
            boolean bl = false;
            String string = "count > string.length: " + n + " > " + cArray.length;
            throw new IllegalArgumentException(string.toString());
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            char c;
            int n4;
            int n5;
            int n6;
            block17: {
                block16: {
                    n6 = cArray[n2];
                    if (n6 < 128) {
                        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
                        int n7 = 1;
                        int n8 = 0;
                        JsonToJavaStreamWriter jsonToJavaStreamWriter2 = jsonToJavaStreamWriter;
                        n5 = 0;
                        if (jsonToJavaStreamWriter2.buffer.length - jsonToJavaStreamWriter2.indexInBuffer < n7) {
                            jsonToJavaStreamWriter.flush();
                        }
                        jsonToJavaStreamWriter = this;
                        n7 = n6;
                        n8 = 0;
                        n4 = jsonToJavaStreamWriter.indexInBuffer;
                        jsonToJavaStreamWriter.indexInBuffer = n4 + 1;
                        jsonToJavaStreamWriter.buffer[n4] = (byte)n7;
                        JsonToJavaStreamWriter jsonToJavaStreamWriter3 = this;
                        n8 = 0;
                        int n9 = ++n2 + (jsonToJavaStreamWriter3.buffer.length - jsonToJavaStreamWriter3.indexInBuffer);
                        int n10 = Math.min(n, n9);
                        while (n2 < n10 && (n6 = cArray[n2]) < 128) {
                            JsonToJavaStreamWriter jsonToJavaStreamWriter4 = this;
                            n8 = n6;
                            n4 = 0;
                            n5 = jsonToJavaStreamWriter4.indexInBuffer;
                            jsonToJavaStreamWriter4.indexInBuffer = n5 + 1;
                            jsonToJavaStreamWriter4.buffer[n5] = (byte)n8;
                            ++n2;
                        }
                        continue;
                    }
                    if (n6 < 2048) {
                        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
                        int n11 = 2;
                        boolean bl = false;
                        JsonToJavaStreamWriter jsonToJavaStreamWriter5 = jsonToJavaStreamWriter;
                        n5 = 0;
                        if (jsonToJavaStreamWriter5.buffer.length - jsonToJavaStreamWriter5.indexInBuffer < n11) {
                            jsonToJavaStreamWriter.flush();
                        }
                        jsonToJavaStreamWriter = this;
                        n11 = n6 >> 6 | 0xC0;
                        bl = false;
                        n4 = jsonToJavaStreamWriter.indexInBuffer;
                        jsonToJavaStreamWriter.indexInBuffer = n4 + 1;
                        jsonToJavaStreamWriter.buffer[n4] = (byte)n11;
                        jsonToJavaStreamWriter = this;
                        n11 = n6 & 0x3F | 0x80;
                        bl = false;
                        n4 = jsonToJavaStreamWriter.indexInBuffer;
                        jsonToJavaStreamWriter.indexInBuffer = n4 + 1;
                        jsonToJavaStreamWriter.buffer[n4] = (byte)n11;
                        ++n2;
                        continue;
                    }
                    if (n6 < 55296 || n6 > 57343) {
                        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
                        int n12 = 3;
                        boolean bl = false;
                        JsonToJavaStreamWriter jsonToJavaStreamWriter6 = jsonToJavaStreamWriter;
                        n5 = 0;
                        if (jsonToJavaStreamWriter6.buffer.length - jsonToJavaStreamWriter6.indexInBuffer < n12) {
                            jsonToJavaStreamWriter.flush();
                        }
                        jsonToJavaStreamWriter = this;
                        n12 = n6 >> 12 | 0xE0;
                        bl = false;
                        n4 = jsonToJavaStreamWriter.indexInBuffer;
                        jsonToJavaStreamWriter.indexInBuffer = n4 + 1;
                        jsonToJavaStreamWriter.buffer[n4] = (byte)n12;
                        jsonToJavaStreamWriter = this;
                        n12 = n6 >> 6 & 0x3F | 0x80;
                        bl = false;
                        n4 = jsonToJavaStreamWriter.indexInBuffer;
                        jsonToJavaStreamWriter.indexInBuffer = n4 + 1;
                        jsonToJavaStreamWriter.buffer[n4] = (byte)n12;
                        jsonToJavaStreamWriter = this;
                        n12 = n6 & 0x3F | 0x80;
                        bl = false;
                        n4 = jsonToJavaStreamWriter.indexInBuffer;
                        jsonToJavaStreamWriter.indexInBuffer = n4 + 1;
                        jsonToJavaStreamWriter.buffer[n4] = (byte)n12;
                        ++n2;
                        continue;
                    }
                    char c2 = c = n2 + 1 < n ? cArray[n2 + 1] : (char)'\u0000';
                    if (n6 > 56319) break block16;
                    if ('\udc00' <= c ? c < '\ue000' : false) break block17;
                }
                JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
                int n13 = 1;
                n4 = 0;
                JsonToJavaStreamWriter jsonToJavaStreamWriter7 = jsonToJavaStreamWriter;
                n3 = 0;
                if (jsonToJavaStreamWriter7.buffer.length - jsonToJavaStreamWriter7.indexInBuffer < n13) {
                    jsonToJavaStreamWriter.flush();
                }
                jsonToJavaStreamWriter = this;
                n13 = 63;
                n4 = 0;
                n5 = jsonToJavaStreamWriter.indexInBuffer;
                jsonToJavaStreamWriter.indexInBuffer = n5 + 1;
                jsonToJavaStreamWriter.buffer[n5] = (byte)n13;
                ++n2;
                continue;
            }
            int n14 = 65536 + ((n6 & 0x3FF) << 10 | c & 0x3FF);
            JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
            n4 = 4;
            n5 = 0;
            JsonToJavaStreamWriter jsonToJavaStreamWriter8 = jsonToJavaStreamWriter;
            boolean bl = false;
            if (jsonToJavaStreamWriter8.buffer.length - jsonToJavaStreamWriter8.indexInBuffer < n4) {
                jsonToJavaStreamWriter.flush();
            }
            jsonToJavaStreamWriter = this;
            n4 = n14 >> 18 | 0xF0;
            n5 = 0;
            n3 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter.buffer[n3] = (byte)n4;
            jsonToJavaStreamWriter = this;
            n4 = n14 >> 12 & 0x3F | 0x80;
            n5 = 0;
            n3 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter.buffer[n3] = (byte)n4;
            jsonToJavaStreamWriter = this;
            n4 = n14 >> 6 & 0x3F | 0x80;
            n5 = 0;
            n3 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter.buffer[n3] = (byte)n4;
            jsonToJavaStreamWriter = this;
            n4 = n14 & 0x3F | 0x80;
            n5 = 0;
            n3 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter.buffer[n3] = (byte)n4;
            n2 += 2;
        }
    }

    private final void writeUtf8CodePoint(int n) {
        if (n < 128) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
            int n2 = 1;
            boolean bl = false;
            JsonToJavaStreamWriter jsonToJavaStreamWriter2 = jsonToJavaStreamWriter;
            boolean bl2 = false;
            if (jsonToJavaStreamWriter2.buffer.length - jsonToJavaStreamWriter2.indexInBuffer < n2) {
                jsonToJavaStreamWriter.flush();
            }
            jsonToJavaStreamWriter = this;
            n2 = n;
            bl = false;
            int n3 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter.buffer[n3] = (byte)n2;
        } else if (n < 2048) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
            int n4 = 2;
            boolean bl = false;
            JsonToJavaStreamWriter jsonToJavaStreamWriter3 = jsonToJavaStreamWriter;
            boolean bl3 = false;
            if (jsonToJavaStreamWriter3.buffer.length - jsonToJavaStreamWriter3.indexInBuffer < n4) {
                jsonToJavaStreamWriter.flush();
            }
            jsonToJavaStreamWriter = this;
            n4 = n >> 6 | 0xC0;
            bl = false;
            int n5 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n5 + 1;
            jsonToJavaStreamWriter.buffer[n5] = (byte)n4;
            jsonToJavaStreamWriter = this;
            n4 = n & 0x3F | 0x80;
            bl = false;
            n5 = jsonToJavaStreamWriter.indexInBuffer;
            jsonToJavaStreamWriter.indexInBuffer = n5 + 1;
            jsonToJavaStreamWriter.buffer[n5] = (byte)n4;
        } else {
            boolean bl = 55296 <= n ? n < 57344 : false;
            if (bl) {
                JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
                int n6 = 1;
                boolean bl4 = false;
                JsonToJavaStreamWriter jsonToJavaStreamWriter4 = jsonToJavaStreamWriter;
                boolean bl5 = false;
                if (jsonToJavaStreamWriter4.buffer.length - jsonToJavaStreamWriter4.indexInBuffer < n6) {
                    jsonToJavaStreamWriter.flush();
                }
                jsonToJavaStreamWriter = this;
                n6 = 63;
                bl4 = false;
                int n7 = jsonToJavaStreamWriter.indexInBuffer;
                jsonToJavaStreamWriter.indexInBuffer = n7 + 1;
                jsonToJavaStreamWriter.buffer[n7] = (byte)n6;
            } else if (n < 65536) {
                JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
                int n8 = 3;
                boolean bl6 = false;
                JsonToJavaStreamWriter jsonToJavaStreamWriter5 = jsonToJavaStreamWriter;
                boolean bl7 = false;
                if (jsonToJavaStreamWriter5.buffer.length - jsonToJavaStreamWriter5.indexInBuffer < n8) {
                    jsonToJavaStreamWriter.flush();
                }
                jsonToJavaStreamWriter = this;
                n8 = n >> 12 | 0xE0;
                bl6 = false;
                int n9 = jsonToJavaStreamWriter.indexInBuffer;
                jsonToJavaStreamWriter.indexInBuffer = n9 + 1;
                jsonToJavaStreamWriter.buffer[n9] = (byte)n8;
                jsonToJavaStreamWriter = this;
                n8 = n >> 6 & 0x3F | 0x80;
                bl6 = false;
                n9 = jsonToJavaStreamWriter.indexInBuffer;
                jsonToJavaStreamWriter.indexInBuffer = n9 + 1;
                jsonToJavaStreamWriter.buffer[n9] = (byte)n8;
                jsonToJavaStreamWriter = this;
                n8 = n & 0x3F | 0x80;
                bl6 = false;
                n9 = jsonToJavaStreamWriter.indexInBuffer;
                jsonToJavaStreamWriter.indexInBuffer = n9 + 1;
                jsonToJavaStreamWriter.buffer[n9] = (byte)n8;
            } else if (n <= 0x10FFFF) {
                JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
                int n10 = 4;
                boolean bl8 = false;
                JsonToJavaStreamWriter jsonToJavaStreamWriter6 = jsonToJavaStreamWriter;
                boolean bl9 = false;
                if (jsonToJavaStreamWriter6.buffer.length - jsonToJavaStreamWriter6.indexInBuffer < n10) {
                    jsonToJavaStreamWriter.flush();
                }
                jsonToJavaStreamWriter = this;
                n10 = n >> 18 | 0xF0;
                bl8 = false;
                int n11 = jsonToJavaStreamWriter.indexInBuffer;
                jsonToJavaStreamWriter.indexInBuffer = n11 + 1;
                jsonToJavaStreamWriter.buffer[n11] = (byte)n10;
                jsonToJavaStreamWriter = this;
                n10 = n >> 12 & 0x3F | 0x80;
                bl8 = false;
                n11 = jsonToJavaStreamWriter.indexInBuffer;
                jsonToJavaStreamWriter.indexInBuffer = n11 + 1;
                jsonToJavaStreamWriter.buffer[n11] = (byte)n10;
                jsonToJavaStreamWriter = this;
                n10 = n >> 6 & 0x3F | 0x80;
                bl8 = false;
                n11 = jsonToJavaStreamWriter.indexInBuffer;
                jsonToJavaStreamWriter.indexInBuffer = n11 + 1;
                jsonToJavaStreamWriter.buffer[n11] = (byte)n10;
                jsonToJavaStreamWriter = this;
                n10 = n & 0x3F | 0x80;
                bl8 = false;
                n11 = jsonToJavaStreamWriter.indexInBuffer;
                jsonToJavaStreamWriter.indexInBuffer = n11 + 1;
                jsonToJavaStreamWriter.buffer[n11] = (byte)n10;
            } else {
                throw new JsonEncodingException("Unexpected code point: " + n);
            }
        }
    }
}

