/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.StringOpsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkotlinx/serialization/json/internal/JsonToStringWriter;", "Lkotlinx/serialization/json/internal/InternalJsonWriter;", "<init>", "()V", "array", "", "size", "", "writeLong", "", "value", "", "writeChar", "char", "", "write", "text", "", "writeQuoted", "appendStringSlowPath", "firstEscapedChar", "currentSize", "string", "release", "toString", "ensureAdditionalCapacity", "expected", "ensureTotalCapacity", "oldSize", "additional", "kotlinx-serialization-json"})
public final class JsonToStringWriter
implements InternalJsonWriter {
    private char[] array = CharArrayPool.INSTANCE.take();
    private int size;

    @Override
    public void writeLong(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void writeChar(char c) {
        this.ensureAdditionalCapacity(1);
        int n = this.size;
        this.size = n + 1;
        this.array[n] = c;
    }

    @Override
    public void write(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = string.length();
        if (n == 0) {
            return;
        }
        this.ensureAdditionalCapacity(n);
        String string2 = string;
        char[] cArray = this.array;
        int n2 = this.size;
        int n3 = 0;
        int n4 = string.length();
        string2.getChars(n3, n4, cArray, n2);
        this.size += n;
    }

    @Override
    public void writeQuoted(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.ensureAdditionalCapacity(string.length() + 2);
        char[] cArray = this.array;
        int n = this.size;
        cArray[n++] = 34;
        int n2 = string.length();
        String string2 = string;
        int n3 = 0;
        string2.getChars(n3, n2, cArray, n);
        n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (c >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[c] == 0) continue;
            this.appendStringSlowPath(i - n, i, string);
            return;
        }
        n += n2;
        cArray[n++] = 34;
        this.size = n;
    }

    private final void appendStringSlowPath(int n, int n2, String string) {
        int n3 = n2;
        int n4 = string.length();
        for (int i = n; i < n4; ++i) {
            n3 = this.ensureTotalCapacity(n3, 2);
            char c = string.charAt(i);
            if (c < StringOpsKt.getESCAPE_MARKERS().length) {
                byte by = StringOpsKt.getESCAPE_MARKERS()[c];
                if (by == 0) {
                    this.array[n3++] = c;
                    continue;
                }
                if (by == 1) {
                    String string2;
                    Intrinsics.checkNotNull((Object)StringOpsKt.getESCAPE_STRINGS()[c]);
                    n3 = this.ensureTotalCapacity(n3, string2.length());
                    String string3 = string2;
                    char[] cArray = this.array;
                    int n5 = 0;
                    int n6 = string2.length();
                    string3.getChars(n5, n6, cArray, n3);
                    this.size = n3 += string2.length();
                    continue;
                }
                this.array[n3] = 92;
                this.array[n3 + 1] = (char)by;
                this.size = n3 += 2;
                continue;
            }
            this.array[n3++] = c;
        }
        n3 = this.ensureTotalCapacity(n3, 1);
        this.array[n3++] = 34;
        this.size = n3;
    }

    @Override
    public void release() {
        CharArrayPool.INSTANCE.release(this.array);
    }

    public String toString() {
        return new String(this.array, 0, this.size);
    }

    private final void ensureAdditionalCapacity(int n) {
        this.ensureTotalCapacity(this.size, n);
    }

    private final int ensureTotalCapacity(int n, int n2) {
        int n3 = n + n2;
        if (this.array.length <= n3) {
            char[] cArray = Arrays.copyOf(this.array, RangesKt.coerceAtLeast((int)n3, (int)(n * 2)));
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"");
            this.array = cArray;
        }
        return n;
    }
}

