/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.address;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.e.a.b;
import org.e.a.f;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaFactory;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.address.MultipleRecipientInfo;
import org.jivesoftware.smackx.address.packet.MultipleAddresses;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public class MultipleRecipientManager {
    public static void send(XMPPConnection xMPPConnection, Stanza stanza, Collection<? extends i> collection, Collection<? extends i> collection2, Collection<? extends i> collection3) {
        MultipleRecipientManager.send(xMPPConnection, stanza, collection, collection2, collection3, null, null, false);
    }

    public static void send(XMPPConnection xMPPConnection, Stanza stanza, Collection<? extends i> collection, Collection<? extends i> collection2, Collection<? extends i> collection3, i i2, i i3, boolean bl) {
        if (collection != null && collection.size() == 1 && (collection2 == null || collection2.isEmpty()) && (collection3 == null || collection3.isEmpty()) && !bl && StringUtils.isNullOrEmpty((CharSequence)i2) && StringUtils.isNullOrEmpty((CharSequence)i3)) {
            i i4 = collection.iterator().next();
            stanza.setTo(i4);
            xMPPConnection.sendStanza(stanza);
            return;
        }
        b b2 = MultipleRecipientManager.getMultipleRecipientServiceAddress(xMPPConnection);
        if (b2 != null) {
            MultipleRecipientManager.sendThroughService(xMPPConnection, stanza, collection, collection2, collection3, i2, i3, bl, b2);
        } else {
            if (bl || i2 != null || i3 != null) {
                throw new SmackException.FeatureNotSupportedException("Extended Stanza Addressing");
            }
            MultipleRecipientManager.sendToIndividualRecipients(xMPPConnection, (StanzaView)stanza, collection, collection2, collection3);
        }
    }

    public static void reply(XMPPConnection xMPPConnection, Message message, Message message2) {
        MultipleAddresses.Address address;
        MultipleRecipientInfo multipleRecipientInfo = MultipleRecipientManager.getMultipleRecipientInfo((Stanza)message);
        if (multipleRecipientInfo == null) {
            throw new IllegalArgumentException("Original message does not contain multiple recipient info");
        }
        if (multipleRecipientInfo.shouldNotReply()) {
            throw new IllegalArgumentException("Original message should not be replied");
        }
        if (multipleRecipientInfo.getReplyRoom() != null) {
            throw new IllegalArgumentException("Reply should be sent through a room");
        }
        if (message.getThread() != null) {
            message2.asBuilder().setThread(message.getThread()).build();
        }
        if ((address = multipleRecipientInfo.getReplyAddress()) != null && address.getJid() != null) {
            message2.setTo(address.getJid());
            xMPPConnection.sendStanza((Stanza)message2);
        } else {
            MultipleAddresses.Address address22;
            ArrayList<i> arrayList = new ArrayList<i>(multipleRecipientInfo.getTOAddresses().size());
            ArrayList<i> arrayList2 = new ArrayList<i>(multipleRecipientInfo.getCCAddresses().size());
            for (MultipleAddresses.Address address22 : multipleRecipientInfo.getTOAddresses()) {
                arrayList.add(address22.getJid());
            }
            f f2 = multipleRecipientInfo.getCCAddresses().iterator();
            while (f2.hasNext()) {
                address22 = f2.next();
                arrayList2.add(address22.getJid());
            }
            if (!arrayList.contains(message.getFrom()) && !arrayList2.contains(message.getFrom())) {
                arrayList.add(message.getFrom());
            }
            if (!arrayList.remove(f2 = xMPPConnection.getUser()) && !arrayList2.remove(f2)) {
                address22 = f2.b();
                arrayList.remove(address22);
                arrayList2.remove(address22);
            }
            MultipleRecipientManager.send(xMPPConnection, (Stanza)message2, arrayList, arrayList2, null, null, null, false);
        }
    }

    public static MultipleRecipientInfo getMultipleRecipientInfo(Stanza stanza) {
        MultipleAddresses multipleAddresses = (MultipleAddresses)stanza.getExtension(MultipleAddresses.class);
        return multipleAddresses == null ? null : new MultipleRecipientInfo(multipleAddresses);
    }

    private static void sendToIndividualRecipients(XMPPConnection xMPPConnection, StanzaView stanzaView, Collection<? extends i> collection, Collection<? extends i> collection2, Collection<? extends i> collection3) {
        MessageBuilder messageBuilder;
        Message message;
        StanzaFactory stanzaFactory = xMPPConnection.getStanzaFactory();
        if (stanzaView instanceof Message) {
            message = (Message)stanzaView;
            messageBuilder = stanzaFactory.buildMessageStanzaFrom(message);
        } else if (stanzaView instanceof Presence) {
            message = (Presence)stanzaView;
            messageBuilder = stanzaFactory.buildPresenceStanzaFrom((Presence)message);
        } else {
            if (stanzaView instanceof IQ) {
                throw new IllegalArgumentException("IQ stanzas have no supported fallback in case no XEP-0033 service is available");
            }
            throw new AssertionError();
        }
        if (collection == null) {
            collection = Collections.emptyList();
        }
        if (collection2 == null) {
            collection2 = Collections.emptyList();
        }
        if (collection3 == null) {
            collection3 = Collections.emptyList();
        }
        int n = collection.size() + collection2.size() + collection3.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        arrayList.addAll(collection);
        arrayList.addAll(collection2);
        arrayList.addAll(collection3);
        ArrayList<Stanza> arrayList2 = new ArrayList<Stanza>(n);
        for (i i2 : arrayList) {
            Stanza stanza = messageBuilder.to(i2).build();
            arrayList2.add(stanza);
        }
        for (Stanza stanza : arrayList2) {
            xMPPConnection.sendStanza(stanza);
        }
    }

    private static void sendThroughService(XMPPConnection xMPPConnection, Stanza stanza, Collection<? extends i> collection, Collection<? extends i> collection2, Collection<? extends i> collection3, i i2, i i3, boolean bl, b b2) {
        MultipleAddresses multipleAddresses = new MultipleAddresses();
        if (collection != null) {
            for (i i4 : collection) {
                multipleAddresses.addAddress(MultipleAddresses.Type.to, i4, null, null, false, null);
            }
        }
        if (collection2 != null) {
            for (i i4 : collection2) {
                multipleAddresses.addAddress(MultipleAddresses.Type.to, i4, null, null, false, null);
            }
        }
        if (collection3 != null) {
            for (i i5 : collection3) {
                multipleAddresses.addAddress(MultipleAddresses.Type.bcc, i5, null, null, false, null);
            }
        }
        if (bl) {
            multipleAddresses.setNoReply();
        } else {
            if (i2 != null) {
                multipleAddresses.addAddress(MultipleAddresses.Type.replyto, i2, null, null, false, null);
            }
            if (i3 != null) {
                multipleAddresses.addAddress(MultipleAddresses.Type.replyroom, i3, null, null, false, null);
            }
        }
        stanza.setTo((i)b2);
        stanza.addExtension((ExtensionElement)multipleAddresses);
        xMPPConnection.sendStanza(stanza);
    }

    private static b getMultipleRecipientServiceAddress(XMPPConnection xMPPConnection) {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        return serviceDiscoveryManager.findService("http://jabber.org/protocol/address", true);
    }
}

