/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmarks;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.e.a.b.d;
import org.e.a.e;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.bookmarks.BookmarkedURL;
import org.jivesoftware.smackx.bookmarks.Bookmarks;
import org.jivesoftware.smackx.iqprivate.PrivateDataManager;

public final class BookmarkManager {
    private static final Map<XMPPConnection, BookmarkManager> bookmarkManagerMap = new WeakHashMap<XMPPConnection, BookmarkManager>();
    private final PrivateDataManager privateDataManager;
    private Bookmarks bookmarks;
    private final Object bookmarkLock = new Object();

    public static synchronized BookmarkManager getBookmarkManager(XMPPConnection xMPPConnection) {
        BookmarkManager bookmarkManager = bookmarkManagerMap.get(xMPPConnection);
        if (bookmarkManager == null) {
            bookmarkManager = new BookmarkManager(xMPPConnection);
            bookmarkManagerMap.put(xMPPConnection, bookmarkManager);
        }
        return bookmarkManager;
    }

    private BookmarkManager(XMPPConnection xMPPConnection) {
        this.privateDataManager = PrivateDataManager.getInstanceFor(xMPPConnection);
    }

    public List<BookmarkedConference> getBookmarkedConferences() {
        this.retrieveBookmarks();
        return Collections.unmodifiableList(this.bookmarks.getBookmarkedConferences());
    }

    public void addBookmarkedConference(String string, e e2, boolean bl, d d2, String string2) {
        this.retrieveBookmarks();
        BookmarkedConference bookmarkedConference = new BookmarkedConference(string, e2, bl, d2, string2);
        List<BookmarkedConference> list = this.bookmarks.getBookmarkedConferences();
        if (list.contains(bookmarkedConference)) {
            BookmarkedConference bookmarkedConference2 = list.get(list.indexOf(bookmarkedConference));
            if (bookmarkedConference2.isShared()) {
                throw new IllegalArgumentException("Cannot modify shared bookmark");
            }
            bookmarkedConference2.setAutoJoin(bl);
            bookmarkedConference2.setName(string);
            bookmarkedConference2.setNickname(d2);
            bookmarkedConference2.setPassword(string2);
        } else {
            this.bookmarks.addBookmarkedConference(bookmarkedConference);
        }
        this.privateDataManager.setPrivateData(this.bookmarks);
    }

    public void removeBookmarkedConference(e e2) {
        this.retrieveBookmarks();
        Iterator<BookmarkedConference> iterator = this.bookmarks.getBookmarkedConferences().iterator();
        while (iterator.hasNext()) {
            BookmarkedConference bookmarkedConference = iterator.next();
            if (!bookmarkedConference.getJid().a((CharSequence)e2)) continue;
            if (bookmarkedConference.isShared()) {
                throw new IllegalArgumentException("Conference is shared and can't be removed");
            }
            iterator.remove();
            this.privateDataManager.setPrivateData(this.bookmarks);
            return;
        }
    }

    public List<BookmarkedURL> getBookmarkedURLs() {
        this.retrieveBookmarks();
        return Collections.unmodifiableList(this.bookmarks.getBookmarkedURLS());
    }

    public void addBookmarkedURL(String string, String string2, boolean bl) {
        this.retrieveBookmarks();
        BookmarkedURL bookmarkedURL = new BookmarkedURL(string, string2, bl);
        List<BookmarkedURL> list = this.bookmarks.getBookmarkedURLS();
        if (list.contains(bookmarkedURL)) {
            BookmarkedURL bookmarkedURL2 = list.get(list.indexOf(bookmarkedURL));
            if (bookmarkedURL2.isShared()) {
                throw new IllegalArgumentException("Cannot modify shared bookmarks");
            }
            bookmarkedURL2.setName(string2);
            bookmarkedURL2.setRss(bl);
        } else {
            this.bookmarks.addBookmarkedURL(bookmarkedURL);
        }
        this.privateDataManager.setPrivateData(this.bookmarks);
    }

    public void removeBookmarkedURL(String string) {
        this.retrieveBookmarks();
        Iterator<BookmarkedURL> iterator = this.bookmarks.getBookmarkedURLS().iterator();
        while (iterator.hasNext()) {
            BookmarkedURL bookmarkedURL = iterator.next();
            if (!bookmarkedURL.getURL().equalsIgnoreCase(string)) continue;
            if (bookmarkedURL.isShared()) {
                throw new IllegalArgumentException("Cannot delete a shared bookmark.");
            }
            iterator.remove();
            this.privateDataManager.setPrivateData(this.bookmarks);
            return;
        }
    }

    public boolean isSupported() {
        return this.privateDataManager.isSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bookmarks retrieveBookmarks() {
        Object object = this.bookmarkLock;
        synchronized (object) {
            if (this.bookmarks == null) {
                this.bookmarks = (Bookmarks)this.privateDataManager.getPrivateData("storage", "storage:bookmarks");
            }
            return this.bookmarks;
        }
    }

    static {
        PrivateDataManager.addPrivateDataProvider("storage", "storage:bookmarks", new Bookmarks.Provider());
    }
}

