/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;

class InitiationListener
extends AbstractIqRequestHandler {
    private final InBandBytestreamManager manager;

    protected InitiationListener(InBandBytestreamManager inBandBytestreamManager) {
        super("open", "http://jabber.org/protocol/ibb", IQ.Type.set, IQRequestHandler.Mode.async);
        this.manager = inBandBytestreamManager;
    }

    public IQ handleIQRequest(IQ iQ) {
        int n;
        Open open = (Open)iQ;
        int n2 = open.getBlockSize();
        if (n2 > (n = this.manager.getMaximumBlockSize())) {
            StanzaError stanzaError = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.resource_constraint).setDescriptiveEnText("Requests block size of " + n2 + " exceeds maximum block size of " + n)).build();
            return IQ.createErrorResponse((IQ)iQ, (StanzaError)stanzaError);
        }
        StreamNegotiator.signal(open.getFrom().toString() + '\t' + open.getSessionID(), open);
        if (this.manager.getIgnoredBytestreamRequests().remove(open.getSessionID())) {
            return null;
        }
        InBandBytestreamRequest inBandBytestreamRequest = new InBandBytestreamRequest(this.manager, open);
        BytestreamListener bytestreamListener = this.manager.getUserListener(open.getFrom());
        if (bytestreamListener != null) {
            bytestreamListener.incomingBytestreamRequest(inBandBytestreamRequest);
        } else if (!this.manager.getAllRequestListeners().isEmpty()) {
            for (BytestreamListener bytestreamListener2 : this.manager.getAllRequestListeners()) {
                bytestreamListener2.incomingBytestreamRequest(inBandBytestreamRequest);
            }
        } else {
            StanzaError stanzaError = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.not_acceptable).setDescriptiveEnText("No file-transfer listeners registered")).build();
            return IQ.createErrorResponse((IQ)iQ, (StanzaError)stanzaError);
        }
        return null;
    }
}

