/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.e.a.f;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.InitiationListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;

public final class Socks5BytestreamManager
extends Manager
implements BytestreamManager {
    private static final String SESSION_ID_PREFIX = "js5_";
    private static final Map<XMPPConnection, Socks5BytestreamManager> managers;
    private final Map<i, BytestreamListener> userListeners = new ConcurrentHashMap<i, BytestreamListener>();
    private final List<BytestreamListener> allRequestListeners = Collections.synchronizedList(new LinkedList());
    private final InitiationListener initiationListener;
    private int targetResponseTimeout = 10000;
    private int proxyConnectionTimeout = 10000;
    private final Set<i> proxyBlacklist = Collections.synchronizedSet(new HashSet());
    private i lastWorkingProxy;
    private boolean proxyPrioritizationEnabled = true;
    private boolean annouceLocalStreamHost = true;
    private final List<String> ignoredBytestreamRequests = Collections.synchronizedList(new LinkedList());

    public static synchronized Socks5BytestreamManager getBytestreamManager(XMPPConnection xMPPConnection) {
        if (xMPPConnection == null) {
            return null;
        }
        Socks5BytestreamManager socks5BytestreamManager = managers.get(xMPPConnection);
        if (socks5BytestreamManager == null) {
            socks5BytestreamManager = new Socks5BytestreamManager(xMPPConnection);
            managers.put(xMPPConnection, socks5BytestreamManager);
        }
        return socks5BytestreamManager;
    }

    private Socks5BytestreamManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.initiationListener = new InitiationListener(this);
        this.activate();
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener bytestreamListener) {
        this.allRequestListeners.add(bytestreamListener);
    }

    @Override
    public void removeIncomingBytestreamListener(BytestreamListener bytestreamListener) {
        this.allRequestListeners.remove(bytestreamListener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener bytestreamListener, i i2) {
        this.userListeners.put(i2, bytestreamListener);
    }

    @Override
    public void removeIncomingBytestreamListener(i i2) {
        this.userListeners.remove(i2);
    }

    public void ignoreBytestreamRequestOnce(String string) {
        this.ignoredBytestreamRequests.add(string);
    }

    public synchronized void disableService() {
        ServiceDiscoveryManager serviceDiscoveryManager;
        XMPPConnection xMPPConnection = this.connection();
        xMPPConnection.unregisterIQRequestHandler((IQRequestHandler)this.initiationListener);
        this.initiationListener.shutdown();
        this.allRequestListeners.clear();
        this.userListeners.clear();
        this.lastWorkingProxy = null;
        this.proxyBlacklist.clear();
        this.ignoredBytestreamRequests.clear();
        managers.remove(xMPPConnection);
        if (managers.size() == 0) {
            Socks5Proxy.getSocks5Proxy().stop();
        }
        if ((serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection)) != null) {
            serviceDiscoveryManager.removeFeature("http://jabber.org/protocol/bytestreams");
        }
    }

    public int getTargetResponseTimeout() {
        if (this.targetResponseTimeout <= 0) {
            this.targetResponseTimeout = 10000;
        }
        return this.targetResponseTimeout;
    }

    public void setTargetResponseTimeout(int n) {
        this.targetResponseTimeout = n;
    }

    public int getProxyConnectionTimeout() {
        if (this.proxyConnectionTimeout <= 0) {
            this.proxyConnectionTimeout = 10000;
        }
        return this.proxyConnectionTimeout;
    }

    public void setProxyConnectionTimeout(int n) {
        this.proxyConnectionTimeout = n;
    }

    public boolean isProxyPrioritizationEnabled() {
        return this.proxyPrioritizationEnabled;
    }

    public void setProxyPrioritizationEnabled(boolean bl) {
        this.proxyPrioritizationEnabled = bl;
    }

    public boolean isAnnouncingLocalStreamHostEnabled() {
        return this.annouceLocalStreamHost;
    }

    public void setAnnounceLocalStreamHost(boolean bl) {
        this.annouceLocalStreamHost = bl;
    }

    @Override
    public Socks5BytestreamSession establishSession(i i2) {
        String string = Socks5BytestreamManager.getNextSessionID();
        return this.establishSession(i2, string);
    }

    @Override
    public Socks5BytestreamSession establishSession(i i2, String string) {
        Object object;
        XMPPConnection xMPPConnection = this.connection();
        XMPPException.XMPPErrorException xMPPErrorException = null;
        if (!this.supportsSocks5(i2)) {
            throw new SmackException.FeatureNotSupportedException("SOCKS5 Bytestream", i2);
        }
        ArrayList<i> arrayList = new ArrayList<i>();
        try {
            arrayList.addAll(this.determineProxies());
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException2) {
            xMPPErrorException = xMPPErrorException2;
        }
        List<Bytestream.StreamHost> list = this.determineStreamHostInfos(arrayList);
        if (list.isEmpty()) {
            if (xMPPErrorException != null) {
                throw xMPPErrorException;
            }
            throw new SmackException.SmackMessageException("no SOCKS5 proxies available");
        }
        String string2 = Socks5Utils.createDigest(string, (i)xMPPConnection.getUser(), i2);
        if (this.proxyPrioritizationEnabled && this.lastWorkingProxy != null) {
            object = null;
            for (Bytestream.StreamHost streamHost : list) {
                if (!streamHost.getJID().a((CharSequence)this.lastWorkingProxy)) continue;
                object = streamHost;
                break;
            }
            if (object != null) {
                list.remove(object);
                list.add(0, (Bytestream.StreamHost)object);
            }
        }
        object = Socks5Proxy.getSocks5Proxy();
        try {
            Bytestream.StreamHost streamHost;
            ((Socks5Proxy)object).addTransfer(string2);
            Bytestream bytestream = Socks5BytestreamManager.createBytestreamInitiation(string, i2, list);
            streamHost = xMPPConnection.createStanzaCollectorAndSend((IQ)bytestream).nextResultOrThrow((long)this.getTargetResponseTimeout());
            Bytestream.StreamHostUsed streamHostUsed = ((Bytestream)((Object)streamHost)).getUsedHost();
            Bytestream.StreamHost streamHost2 = bytestream.getStreamHost(streamHostUsed.getJID());
            if (streamHost2 == null) {
                throw new SmackException.SmackMessageException("Remote user responded with unknown host");
            }
            Socks5ClientForInitiator socks5ClientForInitiator = new Socks5ClientForInitiator(streamHost2, string2, xMPPConnection, string, i2);
            Socket socket = ((Socks5Client)socks5ClientForInitiator).getSocket(this.getProxyConnectionTimeout());
            this.lastWorkingProxy = streamHost2.getJID();
            Socks5BytestreamSession socks5BytestreamSession = new Socks5BytestreamSession(socket, streamHost2.getJID().a((CharSequence)xMPPConnection.getUser()));
            return socks5BytestreamSession;
        }
        catch (TimeoutException timeoutException) {
            throw new IOException("Timeout while connecting to SOCKS5 proxy", timeoutException);
        }
        finally {
            ((Socks5Proxy)object).removeTransfer(string2);
        }
    }

    private boolean supportsSocks5(i i2) {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(i2, "http://jabber.org/protocol/bytestreams");
    }

    public List<i> determineProxies() {
        XMPPConnection xMPPConnection = this.connection();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        ArrayList<i> arrayList = new ArrayList<i>();
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems((i)xMPPConnection.getXMPPServiceDomain());
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            DiscoverInfo discoverInfo;
            if (this.proxyBlacklist.contains(item.getEntityID())) continue;
            try {
                discoverInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException throwable) {
                this.proxyBlacklist.add(item.getEntityID());
                continue;
            }
            if (discoverInfo.hasIdentity("proxy", "bytestreams")) {
                arrayList.add(item.getEntityID());
                continue;
            }
            this.proxyBlacklist.add(item.getEntityID());
        }
        return arrayList;
    }

    private List<Bytestream.StreamHost> determineStreamHostInfos(List<i> list) {
        XMPPConnection xMPPConnection = this.connection();
        ArrayList<Bytestream.StreamHost> arrayList = new ArrayList<Bytestream.StreamHost>();
        if (this.annouceLocalStreamHost) {
            List<Bytestream.StreamHost> list2 = this.getLocalStreamHost();
            arrayList.addAll(list2);
        }
        for (i i2 : list) {
            Bytestream bytestream = Socks5BytestreamManager.createStreamHostRequest(i2);
            try {
                Bytestream bytestream2 = (Bytestream)xMPPConnection.createStanzaCollectorAndSend((IQ)bytestream).nextResultOrThrow();
                arrayList.addAll(bytestream2.getStreamHosts());
            }
            catch (Exception exception) {
                this.proxyBlacklist.add(i2);
            }
        }
        return arrayList;
    }

    private static Bytestream createStreamHostRequest(i i2) {
        Bytestream bytestream = new Bytestream();
        bytestream.setType(IQ.Type.get);
        bytestream.setTo(i2);
        return bytestream;
    }

    public List<Bytestream.StreamHost> getLocalStreamHost() {
        Socks5Proxy.getSocks5Proxy();
        ArrayList<Bytestream.StreamHost> arrayList = new ArrayList<Bytestream.StreamHost>();
        XMPPConnection xMPPConnection = this.connection();
        f f2 = xMPPConnection.getUser();
        for (Socks5Proxy socks5Proxy : Socks5Proxy.getRunningProxies()) {
            List<InetAddress> list = socks5Proxy.getLocalAddresses();
            if (list.isEmpty()) continue;
            int n = socks5Proxy.getPort();
            for (InetAddress inetAddress : list) {
                if (inetAddress.isLoopbackAddress()) continue;
                arrayList.add(new Bytestream.StreamHost((i)f2, inetAddress, n));
            }
        }
        return arrayList;
    }

    private static Bytestream createBytestreamInitiation(String string, i i2, List<Bytestream.StreamHost> list) {
        Bytestream bytestream = new Bytestream(string);
        for (Bytestream.StreamHost streamHost : list) {
            bytestream.addStreamHost(streamHost);
        }
        bytestream.setType(IQ.Type.set);
        bytestream.setTo(i2);
        return bytestream;
    }

    protected void replyRejectPacket(IQ iQ) {
        StanzaError stanzaError = StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.not_acceptable).build();
        ErrorIQ errorIQ = IQ.createErrorResponse((IQ)iQ, (StanzaError)stanzaError);
        this.connection().sendStanza((Stanza)errorIQ);
    }

    private void activate() {
        this.connection().registerIQRequestHandler((IQRequestHandler)this.initiationListener);
        this.enableService();
    }

    private void enableService() {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        serviceDiscoveryManager.addFeature("http://jabber.org/protocol/bytestreams");
    }

    private static String getNextSessionID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SESSION_ID_PREFIX);
        stringBuilder.append(StringUtils.secureOnlineAttackSafeRandomString());
        return stringBuilder.toString();
    }

    protected XMPPConnection getConnection() {
        return this.connection();
    }

    protected BytestreamListener getUserListener(i i2) {
        return this.userListeners.get(i2);
    }

    protected List<BytestreamListener> getAllRequestListeners() {
        return this.allRequestListeners;
    }

    protected List<String> getIgnoredBytestreamRequests() {
        return this.ignoredBytestreamRequests;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                Socks5BytestreamManager.getBytestreamManager(xMPPConnection);
            }
        });
        managers = new WeakHashMap<XMPPConnection, Socks5BytestreamManager>();
    }
}

