/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.e.a.b;
import org.e.a.h;
import org.e.a.i;
import org.e.c.a.c;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.AbstractPresenceEventListener;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.caps.CapsVersionAndHash;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.caps.packet.CapsExtension;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.DiscoInfoLookupShortcutMechanism;
import org.jivesoftware.smackx.disco.EntityCapabilitiesChangedListener;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoView;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class EntityCapsManager
extends Manager {
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    public static final String ELEMENT = "c";
    private static final Map<String, MessageDigest> SUPPORTED_HASHES = new HashMap<String, MessageDigest>();
    private static final String DEFAULT_HASH = "SHA-1";
    private static String DEFAULT_ENTITY_NODE = "https://igniterealtime.org/projects/smack";
    protected static EntityCapsPersistentCache persistentCache;
    private static boolean autoEnableEntityCaps;
    private static final Map<XMPPConnection, EntityCapsManager> instances;
    private static final StanzaFilter PRESENCES_WITH_CAPS;
    static final c<String, DiscoverInfo> CAPS_CACHE;
    static final c<i, NodeVerHash> JID_TO_NODEVER_CACHE;
    private final Queue<CapsVersionAndHash> lastLocalCapsVersions = new ConcurrentLinkedQueue<CapsVersionAndHash>();
    private final ServiceDiscoveryManager sdm;
    private boolean entityCapsEnabled;
    private CapsVersionAndHash currentCapsVersion;
    private String entityNode = DEFAULT_ENTITY_NODE;

    public static void setDefaultEntityNode(String string) {
        DEFAULT_ENTITY_NODE = string;
    }

    static void addDiscoverInfoByNode(String string, DiscoverInfo discoverInfo) {
        CAPS_CACHE.put((Object)string, (Object)discoverInfo);
        if (persistentCache != null) {
            persistentCache.addDiscoverInfoByNodePersistent(string, discoverInfo);
        }
    }

    public static String getNodeVersionByJid(i i2) {
        NodeVerHash nodeVerHash = (NodeVerHash)JID_TO_NODEVER_CACHE.a((Object)i2);
        if (nodeVerHash != null) {
            return nodeVerHash.nodeVer;
        }
        return null;
    }

    public static NodeVerHash getNodeVerHashByJid(i i2) {
        return (NodeVerHash)JID_TO_NODEVER_CACHE.a((Object)i2);
    }

    public static DiscoverInfo getDiscoverInfoByUser(i i2) {
        NodeVerHash nodeVerHash = (NodeVerHash)JID_TO_NODEVER_CACHE.a((Object)i2);
        if (nodeVerHash == null) {
            return null;
        }
        return EntityCapsManager.getDiscoveryInfoByNodeVer(nodeVerHash.nodeVer);
    }

    public static DiscoverInfo getDiscoveryInfoByNodeVer(String string) {
        DiscoverInfo discoverInfo = (DiscoverInfo)CAPS_CACHE.a((Object)string);
        if (discoverInfo == null && persistentCache != null && (discoverInfo = persistentCache.lookup(string)) != null) {
            CAPS_CACHE.put((Object)string, (Object)discoverInfo);
        }
        if (discoverInfo != null) {
            discoverInfo = new DiscoverInfo(discoverInfo);
        }
        return discoverInfo;
    }

    public static void setPersistentCache(EntityCapsPersistentCache entityCapsPersistentCache) {
        persistentCache = entityCapsPersistentCache;
    }

    public static void setMaxsCacheSizes(int n, int n2) {
        JID_TO_NODEVER_CACHE.a(n);
        CAPS_CACHE.a(n2);
    }

    public static void clearMemoryCache() {
        JID_TO_NODEVER_CACHE.clear();
        CAPS_CACHE.clear();
    }

    private static void addCapsExtensionInfo(i i2, CapsExtension capsExtension) {
        String string = capsExtension.getHash();
        String string2 = string.toUpperCase(Locale.US);
        if (!SUPPORTED_HASHES.containsKey(string2)) {
            return;
        }
        String string3 = string.toLowerCase(Locale.US);
        String string4 = capsExtension.getNode();
        String string5 = capsExtension.getVer();
        JID_TO_NODEVER_CACHE.put((Object)i2, (Object)new NodeVerHash(string4, string5, string3));
    }

    private void addCapsExtension(PresenceBuilder presenceBuilder) {
        CapsVersionAndHash capsVersionAndHash = this.getCapsVersionAndHash();
        if (capsVersionAndHash == null) {
            return;
        }
        CapsExtension capsExtension = new CapsExtension(this.entityNode, capsVersionAndHash.version, capsVersionAndHash.hash);
        presenceBuilder.overrideExtension((ExtensionElement)capsExtension);
    }

    private EntityCapsManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.sdm = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        instances.put(xMPPConnection, this);
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void connected(XMPPConnection xMPPConnection) {
                this.processCapsStreamFeatureIfAvailable(xMPPConnection);
            }

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                this.processCapsStreamFeatureIfAvailable(xMPPConnection);
            }

            private void processCapsStreamFeatureIfAvailable(XMPPConnection xMPPConnection) {
                CapsExtension capsExtension = (CapsExtension)xMPPConnection.getFeature(CapsExtension.class);
                if (capsExtension == null) {
                    return;
                }
                b b2 = xMPPConnection.getXMPPServiceDomain();
                EntityCapsManager.addCapsExtensionInfo((i)b2, capsExtension);
            }
        });
        if (autoEnableEntityCaps) {
            this.enableEntityCaps();
        }
        xMPPConnection.addStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                if (!EntityCapsManager.this.entityCapsEnabled()) {
                    return;
                }
                CapsExtension capsExtension = CapsExtension.from(stanza);
                i i2 = stanza.getFrom();
                EntityCapsManager.addCapsExtensionInfo(i2, capsExtension);
            }
        }, PRESENCES_WITH_CAPS);
        Roster.getInstanceFor((XMPPConnection)xMPPConnection).addPresenceEventListener((PresenceEventListener)new AbstractPresenceEventListener(){

            public void presenceUnavailable(h h2, Presence presence) {
                JID_TO_NODEVER_CACHE.remove((Object)h2);
            }
        });
        this.sdm.addEntityCapabilitiesChangedListener(new EntityCapabilitiesChangedListener(){

            @Override
            public void onEntityCapabilitiesChanged(DiscoverInfo discoverInfo) {
                if (!EntityCapsManager.this.entityCapsEnabled()) {
                    return;
                }
                EntityCapsManager.this.updateLocalEntityCaps(discoverInfo);
            }
        });
    }

    public static synchronized EntityCapsManager getInstanceFor(XMPPConnection xMPPConnection) {
        if (SUPPORTED_HASHES.size() <= 0) {
            throw new IllegalStateException("No supported hashes for EntityCapsManager");
        }
        EntityCapsManager entityCapsManager = instances.get(xMPPConnection);
        if (entityCapsManager == null) {
            entityCapsManager = new EntityCapsManager(xMPPConnection);
        }
        return entityCapsManager;
    }

    public synchronized void enableEntityCaps() {
        this.connection().addPresenceInterceptor(this::addCapsExtension, presence -> PresenceTypeFilter.AVAILABLE.accept((Stanza)presence));
        this.sdm.addFeature(NAMESPACE);
        this.entityCapsEnabled = true;
    }

    public synchronized void disableEntityCaps() {
        this.entityCapsEnabled = false;
        this.sdm.removeFeature(NAMESPACE);
        this.connection().removePresenceInterceptor(this::addCapsExtension);
    }

    public boolean entityCapsEnabled() {
        return this.entityCapsEnabled;
    }

    public static void removeUserCapsNode(i i2) {
        JID_TO_NODEVER_CACHE.remove((Object)i2);
    }

    public CapsVersionAndHash getCapsVersionAndHash() {
        return this.currentCapsVersion;
    }

    public String getLocalNodeVer() {
        CapsVersionAndHash capsVersionAndHash = this.getCapsVersionAndHash();
        if (capsVersionAndHash == null) {
            return null;
        }
        return this.entityNode + '#' + capsVersionAndHash.version;
    }

    public boolean areEntityCapsSupported(i i2) {
        return this.sdm.supportsFeature(i2, NAMESPACE);
    }

    public boolean areEntityCapsSupportedByServer() {
        return this.areEntityCapsSupported((i)this.connection().getXMPPServiceDomain());
    }

    private void updateLocalEntityCaps(DiscoverInfo discoverInfo) {
        Object object;
        XMPPConnection xMPPConnection = this.connection();
        DiscoverInfoBuilder discoverInfoBuilder = discoverInfo.asBuilder("synthesized-disco-info-result");
        this.currentCapsVersion = EntityCapsManager.generateVerificationString(discoverInfoBuilder);
        String string = this.getLocalNodeVer();
        discoverInfoBuilder.setNode(string);
        DiscoverInfo discoverInfo2 = discoverInfoBuilder.build();
        EntityCapsManager.addDiscoverInfoByNode(string, discoverInfo2);
        if (this.lastLocalCapsVersions.size() > 10) {
            object = this.lastLocalCapsVersions.poll();
            this.sdm.removeNodeInformationProvider(this.entityNode + '#' + ((CapsVersionAndHash)object).version);
        }
        this.lastLocalCapsVersions.add(this.currentCapsVersion);
        if (xMPPConnection != null) {
            JID_TO_NODEVER_CACHE.put((Object)xMPPConnection.getUser(), (Object)new NodeVerHash(this.entityNode, this.currentCapsVersion));
        }
        object = new LinkedList<DiscoverInfo.Identity>(ServiceDiscoveryManager.getInstanceFor(xMPPConnection).getIdentities());
        this.sdm.setNodeInformationProvider(string, new AbstractNodeInformationProvider((List)object){
            List<String> features;
            List<DataForm> packetExtensions;
            final /* synthetic */ List val$identities;
            {
                this.val$identities = list;
                this.features = EntityCapsManager.this.sdm.getFeatures();
                this.packetExtensions = EntityCapsManager.this.sdm.getExtendedInfo();
            }

            @Override
            public List<String> getNodeFeatures() {
                return this.features;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                return this.val$identities;
            }

            public List<DataForm> getNodePacketExtensions() {
                return this.packetExtensions;
            }
        });
    }

    public static boolean verifyDiscoverInfoVersion(String string, String string2, DiscoverInfo discoverInfo) {
        if (discoverInfo.containsDuplicateIdentities()) {
            return false;
        }
        if (discoverInfo.containsDuplicateFeatures()) {
            return false;
        }
        if (!EntityCapsManager.verifyPacketExtensions(discoverInfo)) {
            return false;
        }
        String string3 = EntityCapsManager.generateVerificationString((DiscoverInfoView)discoverInfo, (String)string2).version;
        return string.equals(string3);
    }

    private static boolean verifyPacketExtensions(DiscoverInfo discoverInfo) {
        HashSet<String> hashSet = new HashSet<String>();
        List list = discoverInfo.getExtensions(DataForm.class);
        for (DataForm dataForm : list) {
            String string;
            boolean bl;
            TextSingleFormField textSingleFormField = dataForm.getHiddenFormTypeField();
            if (textSingleFormField == null || (bl = hashSet.add(string = textSingleFormField.getFirstValue()))) continue;
            return false;
        }
        return true;
    }

    protected static CapsVersionAndHash generateVerificationString(DiscoverInfoView discoverInfoView) {
        return EntityCapsManager.generateVerificationString(discoverInfoView, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CapsVersionAndHash generateVerificationString(DiscoverInfoView discoverInfoView, String string) {
        Object object;
        Object object22;
        MessageDigest messageDigest;
        if (string == null) {
            string = DEFAULT_HASH;
        }
        if ((messageDigest = SUPPORTED_HASHES.get(string.toUpperCase(Locale.US))) == null) {
            return null;
        }
        string = string.toLowerCase(Locale.US);
        StringBuilder stringBuilder = new StringBuilder();
        TreeSet<DiscoverInfo.Identity> treeSet = new TreeSet<DiscoverInfo.Identity>();
        treeSet.addAll(discoverInfoView.getIdentities());
        for (DiscoverInfo.Identity object42 : treeSet) {
            stringBuilder.append(object42.getCategory());
            stringBuilder.append('/');
            stringBuilder.append(object42.getType());
            stringBuilder.append('/');
            stringBuilder.append(object42.getLanguage() == null ? "" : object42.getLanguage());
            stringBuilder.append('/');
            stringBuilder.append(object42.getName() == null ? "" : object42.getName());
            stringBuilder.append('<');
        }
        TreeSet treeSet2 = new TreeSet();
        for (DiscoverInfo.Feature feature : discoverInfoView.getFeatures()) {
            treeSet2.add(feature.getVar());
        }
        Iterator iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuilder.append(string2);
            stringBuilder.append('<');
        }
        List list = discoverInfoView.getExtensions(DataForm.class);
        for (Object object22 : list) {
            if (!((DataForm)object22).hasHiddenFormTypeField()) continue;
            object = new TreeSet<FormField>(new Comparator<FormField>(){

                @Override
                public int compare(FormField formField, FormField formField2) {
                    return formField.getFieldName().compareTo(formField2.getFieldName());
                }
            });
            for (FormField formField : ((DataForm)object22).getFields()) {
                if (formField.getFieldName().equals("FORM_TYPE")) continue;
                object.add(formField);
            }
            EntityCapsManager.formFieldValuesToCaps(Collections.singletonList(((DataForm)object22).getFormType()), stringBuilder);
            Iterator<FormField> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                FormField formField;
                formField = iterator2.next();
                stringBuilder.append(formField.getFieldName());
                stringBuilder.append('<');
                EntityCapsManager.formFieldValuesToCaps(formField.getRawValueCharSequences(), stringBuilder);
            }
        }
        byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        object = messageDigest;
        synchronized (object) {
            object22 = messageDigest.digest(byArray);
        }
        object = Base64.encodeToString((byte[])object22);
        return new CapsVersionAndHash((String)object, string);
    }

    private static void formFieldValuesToCaps(List<? extends CharSequence> list, StringBuilder stringBuilder) {
        TreeSet<? extends CharSequence> treeSet = new TreeSet<CharSequence>();
        treeSet.addAll(list);
        for (CharSequence charSequence : treeSet) {
            stringBuilder.append(charSequence);
            stringBuilder.append('<');
        }
    }

    static {
        autoEnableEntityCaps = true;
        instances = new WeakHashMap<XMPPConnection, EntityCapsManager>();
        PRESENCES_WITH_CAPS = new AndFilter(new StanzaFilter[]{new StanzaTypeFilter(Presence.class), new StanzaExtensionFilter(ELEMENT, NAMESPACE)});
        CAPS_CACHE = new c(1000);
        JID_TO_NODEVER_CACHE = new c(10000);
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                EntityCapsManager.getInstanceFor(xMPPConnection);
            }
        });
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(DEFAULT_HASH);
            SUPPORTED_HASHES.put(DEFAULT_HASH, messageDigest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        ServiceDiscoveryManager.addDiscoInfoLookupShortcutMechanism(new DiscoInfoLookupShortcutMechanism("XEP-0115: Entity Capabilities", 100){

            @Override
            public DiscoverInfo getDiscoverInfoByUser(ServiceDiscoveryManager serviceDiscoveryManager, i i2) {
                DiscoverInfo discoverInfo = EntityCapsManager.getDiscoverInfoByUser(i2);
                if (discoverInfo != null) {
                    return discoverInfo;
                }
                NodeVerHash nodeVerHash = EntityCapsManager.getNodeVerHashByJid(i2);
                if (nodeVerHash == null) {
                    return null;
                }
                try {
                    discoverInfo = serviceDiscoveryManager.discoverInfo(i2, nodeVerHash.getNodeVer());
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                    return null;
                }
                if (EntityCapsManager.verifyDiscoverInfoVersion(nodeVerHash.getVer(), nodeVerHash.getHash(), discoverInfo)) {
                    EntityCapsManager.addDiscoverInfoByNode(nodeVerHash.getNodeVer(), discoverInfo);
                }
                return discoverInfo;
            }
        });
    }

    public static class NodeVerHash {
        private String node;
        private String hash;
        private String ver;
        private String nodeVer;

        NodeVerHash(String string, CapsVersionAndHash capsVersionAndHash) {
            this(string, capsVersionAndHash.version, capsVersionAndHash.hash);
        }

        NodeVerHash(String string, String string2, String string3) {
            this.node = string;
            this.ver = string2;
            this.hash = string3;
            this.nodeVer = string + "#" + string2;
        }

        public String getNodeVer() {
            return this.nodeVer;
        }

        public String getNode() {
            return this.node;
        }

        public String getHash() {
            return this.hash;
        }

        public String getVer() {
            return this.ver;
        }
    }
}

