/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.formtypes;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlUtil;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class FormFieldRegistry {
    private static final Logger LOGGER = Logger.getLogger(FormFieldRegistry.class.getName());
    private static final Map<String, Map<String, FormField.Type>> REGISTRY = new HashMap<String, Map<String, FormField.Type>>();
    private static final Map<String, FormField.Type> CLARK_NOTATION_FIELD_REGISTRY = new ConcurrentHashMap<String, FormField.Type>();
    private static final Map<String, FormField.Type> LOOKASIDE_FIELD_REGISTRY = new ConcurrentHashMap<String, FormField.Type>();

    public static void register(DataForm dataForm) {
        if (dataForm.getType() != DataForm.Type.form) {
            throw new IllegalArgumentException();
        }
        String string = null;
        TextSingleFormField textSingleFormField = dataForm.getHiddenFormTypeField();
        if (textSingleFormField != null) {
            string = textSingleFormField.getValue();
        }
        for (FormField formField : dataForm.getFields()) {
            FormField.Type type;
            if (formField == textSingleFormField || (type = formField.getType()) == FormField.Type.fixed) continue;
            String string2 = formField.getFieldName();
            FormFieldRegistry.register(string, string2, type);
        }
    }

    public static void register(String string, FormField.Type type, String ... stringArray) {
        for (String string2 : stringArray) {
            FormFieldRegistry.register(string, string2, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String string, String string2, FormField.Type type) {
        FormField.Type type2;
        StringUtils.requireNotNullNorEmpty((CharSequence)string2, (String)"fieldName must be provided");
        Objects.requireNonNull((Object)((Object)type));
        if (string == null) {
            if (XmlUtil.isClarkNotation((String)string2)) {
                CLARK_NOTATION_FIELD_REGISTRY.put(string2, type);
            }
            return;
        }
        Map<String, Map<String, FormField.Type>> map = REGISTRY;
        synchronized (map) {
            Map<String, FormField.Type> map2 = REGISTRY.get(string);
            if (map2 == null) {
                map2 = new HashMap<String, FormField.Type>();
                REGISTRY.put(string, map2);
            } else {
                type2 = map2.get(string2);
                if (type2 != null && type2 != type) {
                    throw new IllegalArgumentException();
                }
            }
            type2 = map2.put(string2, type);
        }
        if (type2 != null && type != type2) {
            LOGGER.warning("Form field registry inconsitency detected: Registered field '" + string2 + "' of type " + (Object)((Object)type) + " but previous type was " + (Object)((Object)type2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormField.Type lookup(String string, String string2) {
        if (string == null) {
            if (XmlUtil.isClarkNotation((String)string2)) {
                return CLARK_NOTATION_FIELD_REGISTRY.get(string2);
            }
            return LOOKASIDE_FIELD_REGISTRY.get(string2);
        }
        Map<String, Map<String, FormField.Type>> map = REGISTRY;
        synchronized (map) {
            FormField.Type type;
            Map<String, FormField.Type> map2 = REGISTRY.get(string);
            if (map2 != null && (type = map2.get(string2)) != null) {
                return type;
            }
        }
        return null;
    }

    public static synchronized FormField.Type lookup(String string) {
        return FormFieldRegistry.lookup(null, string);
    }

    public static void addLookasideFieldRegistryEntry(String string, FormField.Type type) {
        LOOKASIDE_FIELD_REGISTRY.put(string, type);
    }
}

