/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jiveproperties.packet;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public class JivePropertiesExtension
implements ExtensionElement {
    public static final String NAMESPACE = "http://www.jivesoftware.com/xmlns/xmpp/properties";
    public static final String ELEMENT = "properties";
    public static final QName QNAME = new QName("http://www.jivesoftware.com/xmlns/xmpp/properties", "properties");
    private static final Logger LOGGER = Logger.getLogger(JivePropertiesExtension.class.getName());
    private final Map<String, Object> properties;

    public JivePropertiesExtension() {
        this.properties = new HashMap<String, Object>();
    }

    public JivePropertiesExtension(Map<String, Object> map) {
        this.properties = map;
    }

    public synchronized Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public synchronized void setProperty(String string, Object object) {
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("Value must be serializable");
        }
        this.properties.put(string, object);
    }

    public synchronized void deleteProperty(String string) {
        if (this.properties == null) {
            return;
        }
        this.properties.remove(string);
    }

    public synchronized Collection<String> getPropertyNames() {
        if (this.properties == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(this.properties.keySet()));
    }

    public synchronized Map<String, Object> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.properties));
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public CharSequence toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((ExtensionElement)this);
        xmlStringBuilder.rightAngleBracket();
        for (String string : this.getPropertyNames()) {
            String string2;
            String string3;
            Object object = this.getProperty(string);
            xmlStringBuilder.openElement("property");
            xmlStringBuilder.element("name", string);
            xmlStringBuilder.halfOpenElement("value");
            if (object instanceof Integer) {
                string3 = "integer";
                string2 = Integer.toString((Integer)object);
            } else if (object instanceof Long) {
                string3 = "long";
                string2 = Long.toString((Long)object);
            } else if (object instanceof Float) {
                string3 = "float";
                string2 = Float.toString(((Float)object).floatValue());
            } else if (object instanceof Double) {
                string3 = "double";
                string2 = Double.toString((Double)object);
            } else if (object instanceof Boolean) {
                string3 = "boolean";
                string2 = Boolean.toString((Boolean)object);
            } else if (object instanceof String) {
                string3 = "string";
                string2 = (String)object;
            } else {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                     ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                    objectOutputStream.writeObject(object);
                    string3 = "java-object";
                    string2 = Base64.encodeToString((byte[])byteArrayOutputStream.toByteArray());
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Error encoding java object", exception);
                    string3 = "java-object";
                    string2 = "Serializing error: " + exception.getMessage();
                }
            }
            xmlStringBuilder.attribute("type", string3);
            xmlStringBuilder.rightAngleBracket();
            xmlStringBuilder.escape(string2);
            xmlStringBuilder.closeElement("value");
            xmlStringBuilder.closeElement("property");
        }
        xmlStringBuilder.closeElement((NamedElement)this);
        return xmlStringBuilder;
    }

    public static JivePropertiesExtension from(Message message) {
        return (JivePropertiesExtension)message.getExtension(JivePropertiesExtension.class);
    }
}

