/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood.provider;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.element.MoodConcretisation;
import org.jivesoftware.smackx.mood.element.MoodElement;
import org.jivesoftware.smackx.mood.provider.MoodConcretisationProvider;

public class MoodProvider
extends ExtensionElementProvider<MoodElement> {
    private static final Logger LOGGER = Logger.getLogger(MoodProvider.class.getName());
    public static final MoodProvider INSTANCE = new MoodProvider();

    public MoodElement parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        String string = null;
        Mood mood = null;
        MoodConcretisation moodConcretisation = null;
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            switch (event) {
                case START_ELEMENT: {
                    Object object;
                    String string2 = xmlPullParser.getName();
                    String string3 = xmlPullParser.getNamespace();
                    if ("text".equals(string2)) {
                        string = xmlPullParser.nextText();
                        break;
                    }
                    if (!"http://jabber.org/protocol/mood".equals(string3)) {
                        LOGGER.log(Level.FINE, "Foreign namespace " + string3 + " detected. Try to find suitable MoodConcretisationProvider.");
                        object = (MoodConcretisationProvider)ProviderManager.getExtensionProvider((String)string2, (String)string3);
                        if (object != null) {
                            moodConcretisation = (MoodConcretisation)object.parse(xmlPullParser);
                            break;
                        }
                        LOGGER.log(Level.FINE, "No provider for <" + string2 + " xmlns:'" + string3 + "'/> found. Ignore.");
                        break;
                    }
                    try {
                        mood = Mood.valueOf(string2);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new XmlPullParserException("Unknown mood value: " + string2 + " encountered.");
                    }
                }
                case END_ELEMENT: {
                    if (!"mood".equals(xmlPullParser.getName())) break;
                    Object object = mood == null && moodConcretisation == null ? null : new MoodElement.MoodSubjectElement(mood, moodConcretisation);
                    return new MoodElement((MoodElement.MoodSubjectElement)object, string);
                }
            }
        }
    }
}

