/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pep;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.e.a.a;
import org.e.a.e;
import org.e.a.i;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.jidtype.FromJidTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.pep.PepListener;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubFeature;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.filter.EventItemsExtensionFilter;

public final class PepManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(PepManager.class.getName());
    private static final Map<XMPPConnection, PepManager> INSTANCES = new WeakHashMap<XMPPConnection, PepManager>();
    private static final StanzaFilter PEP_EVENTS_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL_OR_HEADLINE, FromJidTypeFilter.ENTITY_BARE_JID, EventItemsExtensionFilter.INSTANCE});
    private final Set<PepListener> pepListeners = new CopyOnWriteArraySet<PepListener>();
    private final AsyncButOrdered<e> asyncButOrdered = new AsyncButOrdered();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final PubSubManager pepPubSubManager;
    private final MultiMap<String, PepEventListenerCoupling<? extends ExtensionElement>> pepEventListeners = new MultiMap();
    private final Map<PepEventListener<?>, PepEventListenerCoupling<?>> listenerToCouplingMap = new HashMap();
    private static final PubSubFeature[] REQUIRED_FEATURES = new PubSubFeature[]{PubSubFeature.auto_create, PubSubFeature.auto_subscribe, PubSubFeature.filtered_notifications};

    public static synchronized PepManager getInstanceFor(XMPPConnection xMPPConnection) {
        PepManager pepManager = INSTANCES.get(xMPPConnection);
        if (pepManager == null) {
            pepManager = new PepManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, pepManager);
        }
        return pepManager;
    }

    private PepManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        this.pepPubSubManager = PubSubManager.getInstanceFor(xMPPConnection, null);
        StanzaListener stanzaListener = new StanzaListener(){

            public void processStanza(Stanza stanza) {
                final Message message = (Message)stanza;
                final EventElement eventElement = EventElement.from(stanza);
                assert (eventElement != null);
                final e e2 = message.getFrom().o();
                assert (e2 != null);
                PepManager.this.asyncButOrdered.performAsyncButOrdered((Object)e2, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object;
                        Object object222;
                        ItemsExtension itemsExtension = (ItemsExtension)eventElement.getEvent();
                        String string = itemsExtension.getNode();
                        for (Object object222 : PepManager.this.pepListeners) {
                            object222.eventReceived(e2, eventElement, message);
                        }
                        object222 = PepManager.this.pepEventListeners;
                        synchronized (object222) {
                            object = PepManager.this.pepEventListeners.getAll((Object)string);
                            if (object.isEmpty()) {
                                return;
                            }
                            object = CollectionUtil.newListWith((Collection)object);
                        }
                        object222 = object.iterator();
                        while (object222.hasNext()) {
                            PepEventListenerCoupling pepEventListenerCoupling = (PepEventListenerCoupling)object222.next();
                            List<? extends NamedElement> list = itemsExtension.getItems();
                            for (NamedElement namedElement : list) {
                                Item item = (Item)namedElement;
                                String string2 = item.getId();
                                PayloadItem payloadItem = (PayloadItem)item;
                                Object e22 = payloadItem.getPayload();
                                pepEventListenerCoupling.invoke(e2, e22, string2, message);
                            }
                        }
                    }
                });
            }
        };
        xMPPConnection.addSyncStanzaListener(stanzaListener, PEP_EVENTS_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends ExtensionElement> boolean addPepEventListener(String string, Class<E> clazz, PepEventListener<E> pepEventListener) {
        PepEventListenerCoupling pepEventListenerCoupling = new PepEventListenerCoupling(string, clazz, pepEventListener);
        MultiMap<String, PepEventListenerCoupling<? extends ExtensionElement>> multiMap = this.pepEventListeners;
        synchronized (multiMap) {
            if (this.listenerToCouplingMap.containsKey(pepEventListener)) {
                return false;
            }
            this.listenerToCouplingMap.put(pepEventListener, pepEventListenerCoupling);
            boolean bl = this.pepEventListeners.put((Object)string, pepEventListenerCoupling);
            if (!bl) {
                this.serviceDiscoveryManager.addFeature(string + "+notify");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePepEventListener(PepEventListener<?> pepEventListener) {
        MultiMap<String, PepEventListenerCoupling<? extends ExtensionElement>> multiMap = this.pepEventListeners;
        synchronized (multiMap) {
            PepEventListenerCoupling<?> pepEventListenerCoupling = this.listenerToCouplingMap.remove(pepEventListener);
            if (pepEventListenerCoupling == null) {
                return false;
            }
            String string = ((PepEventListenerCoupling)pepEventListenerCoupling).node;
            boolean bl = this.pepEventListeners.removeOne((Object)string, pepEventListenerCoupling);
            assert (bl);
            if (!this.pepEventListeners.containsKey((Object)((PepEventListenerCoupling)pepEventListenerCoupling).node)) {
                this.serviceDiscoveryManager.removeFeature(string + "+notify");
            }
        }
        return true;
    }

    public PubSubManager getPepPubSubManager() {
        return this.pepPubSubManager;
    }

    @Deprecated
    public boolean addPepListener(PepListener pepListener) {
        return this.pepListeners.add(pepListener);
    }

    @Deprecated
    public boolean removePepListener(PepListener pepListener) {
        return this.pepListeners.remove(pepListener);
    }

    public LeafNode publish(String string, Item item) {
        return this.pepPubSubManager.tryToPublishAndPossibleAutoCreate(string, item);
    }

    public boolean isSupported() {
        XMPPConnection xMPPConnection = this.connection();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        a a2 = xMPPConnection.getUser().n();
        return serviceDiscoveryManager.supportsFeatures((i)a2, REQUIRED_FEATURES);
    }

    private static final class PepEventListenerCoupling<E extends ExtensionElement> {
        private final String node;
        private final Class<E> extensionElementType;
        private final PepEventListener<E> pepEventListener;

        private PepEventListenerCoupling(String string, Class<E> clazz, PepEventListener<E> pepEventListener) {
            this.node = string;
            this.extensionElementType = clazz;
            this.pepEventListener = pepEventListener;
        }

        private void invoke(e e2, ExtensionElement extensionElement, String string, Message message) {
            if (!this.extensionElementType.isInstance(extensionElement)) {
                LOGGER.warning("Ignoring " + extensionElement + " from " + message + " as it is not of type " + this.extensionElementType);
                return;
            }
            ExtensionElement extensionElement2 = (ExtensionElement)this.extensionElementType.cast(extensionElement);
            this.pepEventListener.onPepEvent(e2, extensionElement2, string, message);
        }
    }
}

