/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.e.a.i;
import org.jivesoftware.smack.AbstractConnectionClosedListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.ScheduledAction;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.ExceptionCallback;
import org.jivesoftware.smack.util.SuccessCallback;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.ping.PingFailedListener;
import org.jivesoftware.smackx.ping.packet.Ping;

public final class PingManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(PingManager.class.getName());
    private static final Map<XMPPConnection, PingManager> INSTANCES = new WeakHashMap<XMPPConnection, PingManager>();
    private static int defaultPingInterval;
    private final Set<PingFailedListener> pingFailedListeners = new CopyOnWriteArraySet<PingFailedListener>();
    private int pingInterval = defaultPingInterval;
    private ScheduledAction nextAutomaticPing;

    public static synchronized PingManager getInstanceFor(XMPPConnection xMPPConnection) {
        PingManager pingManager = INSTANCES.get(xMPPConnection);
        if (pingManager == null) {
            pingManager = new PingManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, pingManager);
        }
        return pingManager;
    }

    public static void setDefaultPingInterval(int n) {
        defaultPingInterval = n;
    }

    private PingManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        serviceDiscoveryManager.addFeature("urn:xmpp:ping");
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("ping", "urn:xmpp:ping", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iQ) {
                Ping ping = (Ping)iQ;
                return ping.getPong();
            }
        });
        xMPPConnection.addConnectionListener((ConnectionListener)new AbstractConnectionClosedListener(){

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                PingManager.this.maybeSchedulePingServerTask();
            }

            public void connectionTerminated() {
                PingManager.this.maybeStopPingServerTask();
            }
        });
        this.maybeSchedulePingServerTask();
    }

    private boolean isValidErrorPong(i i2, XMPPException.XMPPErrorException xMPPErrorException) {
        if (i2.a((CharSequence)this.connection().getXMPPServiceDomain())) {
            return true;
        }
        StanzaError stanzaError = xMPPErrorException.getStanzaError();
        StanzaError.Type type = stanzaError.getType();
        StanzaError.Condition condition = stanzaError.getCondition();
        return type == StanzaError.Type.CANCEL && condition == StanzaError.Condition.feature_not_implemented;
    }

    public SmackFuture<Boolean, Exception> pingAsync(i i2) {
        return this.pingAsync(i2, this.connection().getReplyTimeout());
    }

    public SmackFuture<Boolean, Exception> pingAsync(final i i2, long l) {
        SmackFuture.InternalProcessStanzaSmackFuture<Boolean, Exception> internalProcessStanzaSmackFuture = new SmackFuture.InternalProcessStanzaSmackFuture<Boolean, Exception>(){

            public void handleStanza(Stanza stanza) {
                this.setResult(true);
            }

            public boolean isNonFatalException(Exception exception) {
                XMPPException.XMPPErrorException xMPPErrorException;
                if (exception instanceof XMPPException.XMPPErrorException && PingManager.this.isValidErrorPong(i2, xMPPErrorException = (XMPPException.XMPPErrorException)((Object)exception))) {
                    this.setResult(true);
                    return true;
                }
                return false;
            }
        };
        XMPPConnection xMPPConnection = this.connection();
        Ping ping = new Ping(xMPPConnection, i2);
        xMPPConnection.sendIqRequestAsync((IQ)ping, l).onSuccess((SuccessCallback)new SuccessCallback<IQ>((SmackFuture.InternalProcessStanzaSmackFuture)internalProcessStanzaSmackFuture){
            final /* synthetic */ SmackFuture.InternalProcessStanzaSmackFuture val$future;
            {
                this.val$future = internalProcessStanzaSmackFuture;
            }

            public void onSuccess(IQ iQ) {
                this.val$future.processStanza((Stanza)iQ);
            }
        }).onError((ExceptionCallback)new ExceptionCallback<Exception>((SmackFuture.InternalProcessStanzaSmackFuture)internalProcessStanzaSmackFuture){
            final /* synthetic */ SmackFuture.InternalProcessStanzaSmackFuture val$future;
            {
                this.val$future = internalProcessStanzaSmackFuture;
            }

            public void processException(Exception exception) {
                this.val$future.processException(exception);
            }
        });
        return internalProcessStanzaSmackFuture;
    }

    public boolean ping(i i2, long l) {
        XMPPConnection xMPPConnection = this.connection();
        if (!xMPPConnection.isAuthenticated()) {
            throw new SmackException.NotConnectedException();
        }
        Ping ping = new Ping(xMPPConnection, i2);
        try {
            xMPPConnection.createStanzaCollectorAndSend((IQ)ping).nextResultOrThrow(l);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            return this.isValidErrorPong(i2, xMPPErrorException);
        }
        return true;
    }

    public boolean ping(i i2) {
        return this.ping(i2, this.connection().getReplyTimeout());
    }

    public boolean isPingSupported(i i2) {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(i2, "urn:xmpp:ping");
    }

    public boolean pingMyServer() {
        return this.pingMyServer(true);
    }

    public boolean pingMyServer(boolean bl) {
        return this.pingMyServer(bl, this.connection().getReplyTimeout());
    }

    public boolean pingMyServer(boolean bl, long l) {
        boolean bl2;
        try {
            bl2 = this.ping((i)this.connection().getXMPPServiceDomain(), l);
        }
        catch (SmackException.NoResponseException noResponseException) {
            bl2 = false;
        }
        if (!bl2 && bl) {
            for (PingFailedListener pingFailedListener : this.pingFailedListeners) {
                pingFailedListener.pingFailed();
            }
        }
        return bl2;
    }

    public void setPingInterval(int n) {
        this.pingInterval = n;
        this.maybeSchedulePingServerTask();
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public void registerPingFailedListener(PingFailedListener pingFailedListener) {
        this.pingFailedListeners.add(pingFailedListener);
    }

    public void unregisterPingFailedListener(PingFailedListener pingFailedListener) {
        this.pingFailedListeners.remove(pingFailedListener);
    }

    private void maybeSchedulePingServerTask() {
        this.maybeSchedulePingServerTask(0);
    }

    private synchronized void maybeSchedulePingServerTask(int n) {
        this.maybeStopPingServerTask();
        if (this.pingInterval > 0) {
            int n2 = this.pingInterval - n;
            LOGGER.fine("Scheduling ServerPingTask in " + n2 + " seconds (pingInterval=" + this.pingInterval + ", delta=" + n + ")");
            this.nextAutomaticPing = PingManager.schedule(this::pingServerIfNecessary, (long)n2, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private void maybeStopPingServerTask() {
        ScheduledAction scheduledAction = this.nextAutomaticPing;
        if (scheduledAction != null) {
            scheduledAction.cancel();
            this.nextAutomaticPing = null;
        }
    }

    public void pingServerIfNecessary() {
        long l;
        int n;
        final XMPPConnection xMPPConnection = this.connection();
        if (xMPPConnection == null) {
            return;
        }
        if (this.pingInterval <= 0) {
            return;
        }
        long l2 = xMPPConnection.getLastStanzaReceived();
        if (l2 > 0L && (n = (int)(((l = System.currentTimeMillis()) - l2) / 1000L)) < this.pingInterval) {
            this.maybeSchedulePingServerTask(n);
            return;
        }
        if (!xMPPConnection.isAuthenticated()) {
            LOGGER.warning(xMPPConnection + " was not authenticated");
            return;
        }
        l = TimeUnit.MINUTES.toMillis(2L);
        long l3 = xMPPConnection.getReplyTimeout();
        long l4 = l3 > l ? l3 : l;
        SmackFuture<Boolean, Exception> smackFuture = this.pingAsync((i)xMPPConnection.getXMPPServiceDomain(), l4);
        smackFuture.onSuccess((SuccessCallback)new SuccessCallback<Boolean>(){

            public void onSuccess(Boolean bl) {
                PingManager.this.maybeSchedulePingServerTask();
            }
        });
        smackFuture.onError((ExceptionCallback)new ExceptionCallback<Exception>(){

            public void processException(Exception exception) {
                long l;
                int n;
                long l2 = xMPPConnection.getLastStanzaReceived();
                if (l2 > 0L && (n = (int)(((l = System.currentTimeMillis()) - l2) / 1000L)) < PingManager.this.pingInterval) {
                    PingManager.this.maybeSchedulePingServerTask(n);
                    return;
                }
                for (PingFailedListener pingFailedListener : PingManager.this.pingFailedListeners) {
                    pingFailedListener.pingFailed();
                }
            }
        });
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                PingManager.getInstanceFor(xMPPConnection);
            }
        });
        defaultPingInterval = 1800;
    }
}

