/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.usertune;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.usertune.element.UserTuneElement;

public final class UserTuneManager
extends Manager {
    public static final String USERTUNE_NODE = "http://jabber.org/protocol/tune";
    private static final Map<XMPPConnection, UserTuneManager> INSTANCES = new WeakHashMap<XMPPConnection, UserTuneManager>();
    private final PepManager pepManager;

    public static synchronized UserTuneManager getInstanceFor(XMPPConnection xMPPConnection) {
        UserTuneManager userTuneManager = INSTANCES.get(xMPPConnection);
        if (userTuneManager == null) {
            userTuneManager = new UserTuneManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, userTuneManager);
        }
        return userTuneManager;
    }

    private UserTuneManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.pepManager = PepManager.getInstanceFor(xMPPConnection);
    }

    public void clearUserTune() {
        this.publishUserTune(UserTuneElement.EMPTY_USER_TUNE);
    }

    public void publishUserTune(UserTuneElement userTuneElement) {
        this.pepManager.publish(USERTUNE_NODE, new PayloadItem<UserTuneElement>(userTuneElement));
    }

    public boolean addUserTuneListener(PepEventListener<UserTuneElement> pepEventListener) {
        return this.pepManager.addPepEventListener(USERTUNE_NODE, UserTuneElement.class, pepEventListener);
    }

    public boolean removeUserTuneListener(PepEventListener<UserTuneElement> pepEventListener) {
        return this.pepManager.removePepEventListener(pepEventListener);
    }
}

