/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.vcardtemp.provider;

import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.vcardtemp.packet.VCard;

public class VCardProvider
extends IQProvider<VCard> {
    private static final String[] ADR = new String[]{"POSTAL", "PARCEL", "DOM", "INTL", "PREF", "POBOX", "EXTADR", "STREET", "LOCALITY", "REGION", "PCODE", "CTRY", "FF"};
    private static final String[] TEL = new String[]{"VOICE", "FAX", "PAGER", "MSG", "CELL", "VIDEO", "BBS", "MODEM", "ISDN", "PCS", "PREF"};

    /*
     * Enabled aggressive block sorting
     */
    public VCard parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        VCard vCard = new VCard();
        String string = null;
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    switch (string = xmlPullParser.getName()) {
                        case "N": {
                            VCardProvider.parseName(xmlPullParser, vCard);
                            break block0;
                        }
                        case "ORG": {
                            VCardProvider.parseOrg(xmlPullParser, vCard);
                            break block0;
                        }
                        case "TEL": {
                            VCardProvider.parseTel(xmlPullParser, vCard);
                            break block0;
                        }
                        case "ADR": {
                            VCardProvider.parseAddress(xmlPullParser, vCard);
                            break block0;
                        }
                        case "EMAIL": {
                            VCardProvider.parseEmail(xmlPullParser, vCard);
                            break block0;
                        }
                        case "NICKNAME": {
                            vCard.setNickName(xmlPullParser.nextText());
                            break block0;
                        }
                        case "JABBERID": {
                            vCard.setJabberId(xmlPullParser.nextText());
                            break block0;
                        }
                        case "PHOTO": {
                            VCardProvider.parsePhoto(xmlPullParser, vCard);
                            break block0;
                        }
                    }
                    break;
                }
                case TEXT_CHARACTERS: {
                    if (n + 1 != xmlPullParser.getDepth()) break;
                    String string2 = xmlPullParser.getText();
                    vCard.setField(string, string2);
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return vCard;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseAddress(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        boolean bl = true;
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            switch (event) {
                case START_ELEMENT: {
                    String string = xmlPullParser.getName();
                    if ("HOME".equals(string)) {
                        bl = false;
                        break;
                    }
                    for (String string2 : ADR) {
                        if (!string2.equals(string)) continue;
                        if (bl) {
                            vCard.setAddressFieldWork(string, xmlPullParser.nextText());
                            continue;
                        }
                        vCard.setAddressFieldHome(string, xmlPullParser.nextText());
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseTel(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        boolean bl = true;
        String string = null;
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            switch (event) {
                case START_ELEMENT: {
                    String string2 = xmlPullParser.getName();
                    if ("HOME".equals(string2)) {
                        bl = false;
                        break;
                    }
                    if ("NUMBER".equals(string2)) {
                        if (StringUtils.isNullOrEmpty(string)) {
                            string = "VOICE";
                        }
                        if (bl) {
                            vCard.setPhoneWork(string, xmlPullParser.nextText());
                            break;
                        }
                        vCard.setPhoneHome(string, xmlPullParser.nextText());
                        break;
                    }
                    for (String string3 : TEL) {
                        if (!string3.equals(string2)) continue;
                        string = string2;
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseOrg(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string;
                    switch (string = xmlPullParser.getName()) {
                        case "ORGNAME": {
                            vCard.setOrganization(xmlPullParser.nextText());
                            break block0;
                        }
                        case "ORGUNIT": {
                            vCard.setOrganizationUnit(xmlPullParser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseEmail(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        boolean bl = false;
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string;
                    switch (string = xmlPullParser.getName()) {
                        case "WORK": {
                            bl = true;
                            break block0;
                        }
                        case "USERID": {
                            if (bl) {
                                vCard.setEmailWork(xmlPullParser.nextText());
                                break block0;
                            }
                            vCard.setEmailHome(xmlPullParser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseName(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string;
                    switch (string = xmlPullParser.getName()) {
                        case "FAMILY": {
                            vCard.setLastName(xmlPullParser.nextText());
                            break block0;
                        }
                        case "GIVEN": {
                            vCard.setFirstName(xmlPullParser.nextText());
                            break block0;
                        }
                        case "MIDDLE": {
                            vCard.setMiddleName(xmlPullParser.nextText());
                            break block0;
                        }
                        case "PREFIX": {
                            vCard.setPrefix(xmlPullParser.nextText());
                            break block0;
                        }
                        case "SUFFIX": {
                            vCard.setSuffix(xmlPullParser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parsePhoto(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        String string = null;
        String string2 = null;
        block12: while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string3;
                    switch (string3 = xmlPullParser.getName()) {
                        case "BINVAL": {
                            string = xmlPullParser.nextText();
                            break block0;
                        }
                        case "TYPE": {
                            string2 = xmlPullParser.nextText();
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() == n) break block12;
                }
            }
        }
        if (string != null && string2 != null) {
            vCard.setAvatar(string, string2);
            return;
        }
    }
}

