/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.roster.provider.RosterPacketProvider;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.formtypes.FormFieldRegistry;
import org.jivesoftware.smackx.xdata.AbstractMultiFormField;
import org.jivesoftware.smackx.xdata.AbstractSingleStringValueFormField;
import org.jivesoftware.smackx.xdata.BooleanFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.FormFieldWithOptions;
import org.jivesoftware.smackx.xdata.JidMultiFormField;
import org.jivesoftware.smackx.xdata.JidSingleFormField;
import org.jivesoftware.smackx.xdata.ListSingleFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProvider;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProviderManager;
import org.jivesoftware.smackx.xdatalayout.provider.DataLayoutProvider;

public class DataFormProvider
extends ExtensionElementProvider<DataForm> {
    private static final Logger LOGGER = Logger.getLogger(DataFormProvider.class.getName());
    public static final DataFormProvider INSTANCE = new DataFormProvider();
    private static final Set<FieldNameAndFormType> UNKNOWN_FIELDS = new CopyOnWriteArraySet<FieldNameAndFormType>();

    /*
     * Enabled aggressive block sorting
     */
    public DataForm parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        DataForm.Type type = DataForm.Type.fromString(xmlPullParser.getAttributeValue("", "type"));
        DataForm.Builder builder = DataForm.builder(type);
        String string = null;
        DataForm.ReportedData reportedData = null;
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string2 = xmlPullParser.getName();
                    String string3 = xmlPullParser.getNamespace();
                    XmlEnvironment xmlEnvironment2 = XmlEnvironment.from((XmlPullParser)xmlPullParser, (XmlEnvironment)xmlEnvironment);
                    switch (string2) {
                        case "instructions": {
                            builder.addInstruction(xmlPullParser.nextText());
                            break;
                        }
                        case "title": {
                            builder.setTitle(xmlPullParser.nextText());
                            break;
                        }
                        case "field": {
                            FormField formField = DataFormProvider.parseField(xmlPullParser, xmlEnvironment2, string);
                            TextSingleFormField textSingleFormField = formField.asHiddenFormTypeFieldIfPossible();
                            if (textSingleFormField != null) {
                                if (string != null) {
                                    throw new SmackParsingException("Multiple hidden form type fields");
                                }
                                string = textSingleFormField.getValue();
                            }
                            builder.addField(formField);
                            break;
                        }
                        case "item": {
                            DataForm.Item item = DataFormProvider.parseItem(xmlPullParser, xmlEnvironment2, string, reportedData);
                            builder.addItem(item);
                            break;
                        }
                        case "reported": {
                            if (reportedData != null) {
                                throw new SmackParsingException("Data form with multiple <reported/> elements");
                            }
                            reportedData = DataFormProvider.parseReported(xmlPullParser, xmlEnvironment2, string);
                            builder.setReportedData(reportedData);
                            break;
                        }
                        case "query": {
                            if (string3.equals("jabber:iq:roster")) {
                                builder.addExtensionElement((Element)RosterPacketProvider.INSTANCE.parse(xmlPullParser));
                                break;
                            }
                            break block0;
                        }
                        case "page": {
                            if (string3.equals("http://jabber.org/protocol/xdata-layout")) {
                                builder.addExtensionElement((Element)DataLayoutProvider.parse(xmlPullParser));
                                break;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return builder.build();
                }
            }
        }
    }

    private static FormField parseField(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment, String string) {
        return DataFormProvider.parseField(xmlPullParser, xmlEnvironment, string, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static FormField parseField(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment, String string, DataForm.ReportedData reportedData) {
        Object object;
        Object object2;
        Object object3;
        int n = xmlPullParser.getDepth();
        String string2 = xmlPullParser.getAttributeValue("var");
        String string3 = xmlPullParser.getAttributeValue("", "label");
        FormField.Type type = null;
        Object object4 = xmlPullParser.getAttributeValue("type");
        if (object4 != null) {
            type = FormField.Type.fromString((String)object4);
        }
        object4 = new ArrayList();
        ArrayList<FormField.Option> arrayList = new ArrayList<FormField.Option>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        boolean bl = false;
        block19: while (true) {
            object3 = xmlPullParser.nextTag();
            switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$TagEvent[object3.ordinal()]) {
                case 1: {
                    object2 = xmlPullParser.getQName();
                    if (((QName)object2).equals(FormField.Value.QNAME)) {
                        FormField.Value value = DataFormProvider.parseValue(xmlPullParser);
                        object4.add(value);
                        break;
                    }
                    if (((QName)object2).equals(FormField.Option.QNAME)) {
                        FormField.Option option = DataFormProvider.parseOption(xmlPullParser);
                        arrayList.add(option);
                        break;
                    }
                    if (((QName)object2).equals(FormField.Required.QNAME)) {
                        bl = true;
                        break;
                    }
                    FormFieldChildElementProvider<?> formFieldChildElementProvider = FormFieldChildElementProviderManager.getFormFieldChildElementProvider((QName)object2);
                    if (formFieldChildElementProvider == null) {
                        LOGGER.warning("Unknown form field child element " + object2 + " ignored");
                        continue block19;
                    }
                    object = (FormFieldChildElement)formFieldChildElementProvider.parse(xmlPullParser, XmlEnvironment.from((XmlPullParser)xmlPullParser, (XmlEnvironment)xmlEnvironment));
                    arrayList2.add(object);
                    break;
                }
                case 2: {
                    if (xmlPullParser.getDepth() == n) break block19;
                }
            }
        }
        if (type == null && reportedData != null && (object3 = reportedData.getField(string2)) != null) {
            type = ((FormField)object3).getType();
        }
        if (type == null) {
            if (string2.equals("FORM_TYPE")) {
                type = FormField.Type.hidden;
            } else {
                type = FormFieldRegistry.lookup(string, string2);
                if (type == null) {
                    object3 = new FieldNameAndFormType(string2, string);
                    if (!UNKNOWN_FIELDS.contains(object3)) {
                        LOGGER.warning("The Field '" + string2 + "' from FORM_TYPE '" + string + "' is not registered. Field type is unknown, assuming text-single.");
                        UNKNOWN_FIELDS.add((FieldNameAndFormType)object3);
                    }
                    type = FormField.Type.text_single;
                }
            }
        }
        switch (type) {
            case bool: {
                object3 = DataFormProvider.parseBooleanFormField(string2, (List<FormField.Value>)object4);
                break;
            }
            case fixed: {
                object3 = DataFormProvider.parseSingleKindFormField(FormField.fixedBuilder(string2), (List<FormField.Value>)object4);
                break;
            }
            case hidden: {
                object3 = DataFormProvider.parseSingleKindFormField(FormField.hiddenBuilder(string2), (List<FormField.Value>)object4);
                break;
            }
            case jid_multi: {
                object2 = FormField.jidMultiBuilder(string2);
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    object = (FormField.Value)iterator.next();
                    ((JidMultiFormField.Builder)object2).addValue((FormField.Value)object);
                }
                object3 = object2;
                break;
            }
            case jid_single: {
                DataFormProvider.ensureAtMostSingleValue(type, (List<FormField.Value>)object4);
                JidSingleFormField.Builder builder = FormField.jidSingleBuilder(string2);
                if (!object4.isEmpty()) {
                    object = (FormField.Value)object4.get(0);
                    builder.setValue((FormField.Value)object);
                }
                object3 = builder;
                break;
            }
            case list_multi: {
                object = FormField.listMultiBuilder(string2);
                DataFormProvider.addOptionsToBuilder(arrayList, object);
                object3 = DataFormProvider.parseMultiKindFormField(object, (List<FormField.Value>)object4);
                break;
            }
            case list_single: {
                ListSingleFormField.Builder builder = FormField.listSingleBuilder(string2);
                DataFormProvider.addOptionsToBuilder(arrayList, builder);
                object3 = DataFormProvider.parseSingleKindFormField(builder, (List<FormField.Value>)object4);
                break;
            }
            case text_multi: {
                object3 = DataFormProvider.parseMultiKindFormField(FormField.textMultiBuilder(string2), (List<FormField.Value>)object4);
                break;
            }
            case text_private: {
                object3 = DataFormProvider.parseSingleKindFormField(FormField.textPrivateBuilder(string2), (List<FormField.Value>)object4);
                break;
            }
            case text_single: {
                object3 = DataFormProvider.parseSingleKindFormField(FormField.textSingleBuilder(string2), (List<FormField.Value>)object4);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type " + (Object)((Object)type)));
            }
        }
        switch (type) {
            case list_multi: 
            case list_single: {
                break;
            }
            default: {
                if (arrayList.isEmpty()) break;
                throw new SmackParsingException("Form fields of type " + (Object)((Object)type) + " must not have options. This one had " + arrayList.size());
            }
        }
        if (string3 != null) {
            ((FormField.Builder)object3).setLabel(string3);
        }
        ((FormField.Builder)object3).setRequired(bl);
        ((FormField.Builder)object3).addFormFieldChildElements(arrayList2);
        return ((FormField.Builder)object3).build();
    }

    private static FormField.Builder<?, ?> parseBooleanFormField(String string, List<FormField.Value> list) {
        BooleanFormField.Builder builder = FormField.booleanBuilder(string);
        DataFormProvider.ensureAtMostSingleValue(builder.getType(), list);
        if (list.size() == 1) {
            FormField.Value value = list.get(0);
            builder.setValue(value);
        }
        return builder;
    }

    private static AbstractSingleStringValueFormField.Builder<?, ?> parseSingleKindFormField(AbstractSingleStringValueFormField.Builder<?, ?> builder, List<FormField.Value> list) {
        DataFormProvider.ensureAtMostSingleValue(builder.getType(), list);
        if (list.size() == 1) {
            String string = list.get(0).getValue().toString();
            builder.setValue(string);
        }
        return builder;
    }

    private static AbstractMultiFormField.Builder<?, ?> parseMultiKindFormField(AbstractMultiFormField.Builder<?, ?> builder, List<FormField.Value> list) {
        for (FormField.Value value : list) {
            builder.addValue(value.getValue());
        }
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DataForm.Item parseItem(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment, String string, DataForm.ReportedData reportedData) {
        int n = xmlPullParser.getDepth();
        ArrayList<FormField> arrayList = new ArrayList<FormField>();
        while (true) {
            XmlPullParser.TagEvent tagEvent = xmlPullParser.nextTag();
            block0 : switch (tagEvent) {
                case START_ELEMENT: {
                    String string2;
                    switch (string2 = xmlPullParser.getName()) {
                        case "field": {
                            FormField formField = DataFormProvider.parseField(xmlPullParser, XmlEnvironment.from((XmlPullParser)xmlPullParser, (XmlEnvironment)xmlEnvironment), string, reportedData);
                            arrayList.add(formField);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return new DataForm.Item(arrayList);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DataForm.ReportedData parseReported(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment, String string) {
        int n = xmlPullParser.getDepth();
        ArrayList<FormField> arrayList = new ArrayList<FormField>();
        while (true) {
            XmlPullParser.TagEvent tagEvent = xmlPullParser.nextTag();
            block0 : switch (tagEvent) {
                case START_ELEMENT: {
                    String string2;
                    switch (string2 = xmlPullParser.getName()) {
                        case "field": {
                            FormField formField = DataFormProvider.parseField(xmlPullParser, XmlEnvironment.from((XmlPullParser)xmlPullParser, (XmlEnvironment)xmlEnvironment), string);
                            arrayList.add(formField);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return new DataForm.ReportedData(arrayList);
                }
            }
        }
    }

    public static FormField.Value parseValue(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.nextText();
        return new FormField.Value(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static FormField.Option parseOption(XmlPullParser xmlPullParser) {
        int n = xmlPullParser.getDepth();
        FormField.Option option = null;
        String string = xmlPullParser.getAttributeValue("", "label");
        while (true) {
            XmlPullParser.TagEvent tagEvent = xmlPullParser.nextTag();
            block0 : switch (tagEvent) {
                case START_ELEMENT: {
                    String string2;
                    switch (string2 = xmlPullParser.getName()) {
                        case "value": {
                            option = new FormField.Option(string, xmlPullParser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return option;
                }
            }
        }
    }

    private static void ensureAtMostSingleValue(FormField.Type type, List<FormField.Value> list) {
        if (list.size() > 1) {
            throw new SmackParsingException((Object)((Object)type) + " fields can have at most one value, this one had " + list.size());
        }
    }

    private static void addOptionsToBuilder(Collection<FormField.Option> collection, FormFieldWithOptions.Builder<?> builder) {
        for (FormField.Option option : collection) {
            builder.addOption(option);
        }
    }

    private static final class FieldNameAndFormType {
        private final String fieldName;
        private final String formType;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        private FieldNameAndFormType(String string, String string2) {
            this.fieldName = string;
            this.formType = string2;
        }

        public int hashCode() {
            return this.hashCodeCache.getHashCode(builder -> builder.append((Object)this.fieldName).append((Object)this.formType).build());
        }

        public boolean equals(Object object) {
            return EqualsUtil.equals((Object)this, (Object)object, (builder, fieldNameAndFormType) -> builder.append((Object)this.fieldName, (Object)fieldNameAndFormType.fieldName).append((Object)this.formType, (Object)fieldNameAndFormType.formType));
        }
    }
}

