/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameListenerDecorator;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.internal.ObjectUtil;

final class Http2EmptyDataFrameListener
extends Http2FrameListenerDecorator {
    private final int maxConsecutiveEmptyFrames;
    private boolean violationDetected;
    private int emptyDataFrames;

    Http2EmptyDataFrameListener(Http2FrameListener http2FrameListener, int n) {
        super(http2FrameListener);
        this.maxConsecutiveEmptyFrames = ObjectUtil.checkPositive((int)n, (String)"maxConsecutiveEmptyFrames");
    }

    @Override
    public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) {
        if (bl || byteBuf.isReadable()) {
            this.emptyDataFrames = 0;
        } else if (this.emptyDataFrames++ == this.maxConsecutiveEmptyFrames && !this.violationDetected) {
            this.violationDetected = true;
            throw Http2Exception.connectionError(Http2Error.ENHANCE_YOUR_CALM, "Maximum number %d of empty data frames without end_of_stream flag received", this.maxConsecutiveEmptyFrames);
        }
        return super.onDataRead(channelHandlerContext, n, byteBuf, n2, bl);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) {
        this.emptyDataFrames = 0;
        super.onHeadersRead(channelHandlerContext, n, http2Headers, n2, bl);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) {
        this.emptyDataFrames = 0;
        super.onHeadersRead(channelHandlerContext, n, http2Headers, n2, s, bl, n3, bl2);
    }
}

