/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.MaxCapacityQueue;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayDeque;
import java.util.Queue;

@Deprecated
public class Http2MultiplexCodec
extends Http2FrameCodec {
    private final ChannelHandler inboundStreamHandler;
    private final ChannelHandler upgradeStreamHandler;
    private final Queue<AbstractHttp2StreamChannel> readCompletePendingQueue = new MaxCapacityQueue<AbstractHttp2StreamChannel>(new ArrayDeque(8), 100);
    private boolean parentReadInProgress;
    private int idCount;
    volatile ChannelHandlerContext ctx;

    Http2MultiplexCodec(Http2ConnectionEncoder http2ConnectionEncoder, Http2ConnectionDecoder http2ConnectionDecoder, Http2Settings http2Settings, ChannelHandler channelHandler, ChannelHandler channelHandler2, boolean bl, boolean bl2) {
        super(http2ConnectionEncoder, http2ConnectionDecoder, http2Settings, bl, bl2);
        this.inboundStreamHandler = channelHandler;
        this.upgradeStreamHandler = channelHandler2;
    }

    @Override
    public void onHttpClientUpgrade() {
        if (this.upgradeStreamHandler == null) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Client is misconfigured for upgrade requests", new Object[0]);
        }
        super.onHttpClientUpgrade();
    }

    @Override
    public final void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.executor() != channelHandlerContext.channel().eventLoop()) {
            throw new IllegalStateException("EventExecutor must be EventLoop of Channel");
        }
        this.ctx = channelHandlerContext;
    }

    @Override
    public final void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved0(channelHandlerContext);
        this.readCompletePendingQueue.clear();
    }

    @Override
    final void onHttp2Frame(ChannelHandlerContext channelHandlerContext, Http2Frame http2Frame) {
        if (http2Frame instanceof Http2StreamFrame) {
            Http2StreamFrame http2StreamFrame = (Http2StreamFrame)http2Frame;
            AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)http2StreamFrame.stream()).attachment;
            abstractHttp2StreamChannel.fireChildRead(http2StreamFrame);
            return;
        }
        if (http2Frame instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame(channelHandlerContext, (Http2GoAwayFrame)http2Frame);
        }
        channelHandlerContext.fireChannelRead((Object)http2Frame);
    }

    @Override
    final void onHttp2StreamStateChanged(ChannelHandlerContext channelHandlerContext, Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream) {
        switch (defaultHttp2FrameStream.state()) {
            case HALF_CLOSED_LOCAL: {
                if (defaultHttp2FrameStream.id() != 1) break;
            }
            case HALF_CLOSED_REMOTE: 
            case OPEN: {
                Http2MultiplexCodecStreamChannel http2MultiplexCodecStreamChannel;
                if (defaultHttp2FrameStream.attachment != null) break;
                if (defaultHttp2FrameStream.id() == 1 && !this.connection().isServer()) {
                    assert (this.upgradeStreamHandler != null);
                    http2MultiplexCodecStreamChannel = new Http2MultiplexCodecStreamChannel(defaultHttp2FrameStream, this.upgradeStreamHandler);
                    http2MultiplexCodecStreamChannel.closeOutbound();
                } else {
                    http2MultiplexCodecStreamChannel = new Http2MultiplexCodecStreamChannel(defaultHttp2FrameStream, this.inboundStreamHandler);
                }
                ChannelFuture channelFuture = channelHandlerContext.channel().eventLoop().register((Channel)http2MultiplexCodecStreamChannel);
                if (channelFuture.isDone()) {
                    Http2MultiplexHandler.registerDone(channelFuture);
                    break;
                }
                channelFuture.addListener((GenericFutureListener)Http2MultiplexHandler.CHILD_CHANNEL_REGISTRATION_LISTENER);
                break;
            }
            case CLOSED: {
                AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)defaultHttp2FrameStream.attachment;
                if (abstractHttp2StreamChannel == null) break;
                abstractHttp2StreamChannel.streamClosed();
                break;
            }
        }
    }

    final Http2StreamChannel newOutboundStream() {
        return new Http2MultiplexCodecStreamChannel(this.newStream(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void onHttp2FrameStreamException(ChannelHandlerContext channelHandlerContext, Http2FrameStreamException http2FrameStreamException) {
        Http2FrameStream http2FrameStream = http2FrameStreamException.stream();
        AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)http2FrameStream).attachment;
        try {
            abstractHttp2StreamChannel.pipeline().fireExceptionCaught(http2FrameStreamException.getCause());
        }
        finally {
            abstractHttp2StreamChannel.closeWithError(http2FrameStreamException.error());
        }
    }

    private void onHttp2GoAwayFrame(ChannelHandlerContext channelHandlerContext, final Http2GoAwayFrame http2GoAwayFrame) {
        if (http2GoAwayFrame.lastStreamId() == Integer.MAX_VALUE) {
            return;
        }
        try {
            this.forEachActiveStream(new Http2FrameStreamVisitor(){

                @Override
                public boolean visit(Http2FrameStream http2FrameStream) {
                    int n = http2FrameStream.id();
                    AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)http2FrameStream).attachment;
                    if (n > http2GoAwayFrame.lastStreamId() && Http2MultiplexCodec.this.connection().local().isValidStreamId(n)) {
                        abstractHttp2StreamChannel.pipeline().fireUserEventTriggered((Object)http2GoAwayFrame.retainedDuplicate());
                    }
                    return true;
                }
            });
        }
        catch (Http2Exception http2Exception) {
            channelHandlerContext.fireExceptionCaught((Throwable)http2Exception);
            channelHandlerContext.close();
        }
    }

    @Override
    public final void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.processPendingReadCompleteQueue();
        this.channelReadComplete0(channelHandlerContext);
    }

    private void processPendingReadCompleteQueue() {
        this.parentReadInProgress = true;
        try {
            AbstractHttp2StreamChannel abstractHttp2StreamChannel;
            while ((abstractHttp2StreamChannel = this.readCompletePendingQueue.poll()) != null) {
                abstractHttp2StreamChannel.fireChildReadComplete();
            }
        }
        finally {
            this.parentReadInProgress = false;
            this.readCompletePendingQueue.clear();
            this.flush0(this.ctx);
        }
    }

    public final void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.parentReadInProgress = true;
        super.channelRead(channelHandlerContext, object);
    }

    @Override
    public final void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isWritable()) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.WRITABLE_VISITOR);
        }
        super.channelWritabilityChanged(channelHandlerContext);
    }

    @Override
    final void onUserEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object == ChannelInputShutdownReadComplete.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_INPUT_SHUTDOWN_READ_COMPLETE_VISITOR);
        } else if (object == ChannelOutputShutdownEvent.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_OUTPUT_SHUTDOWN_EVENT_VISITOR);
        } else if (object == SslCloseCompletionEvent.SUCCESS) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.SSL_CLOSE_COMPLETION_EVENT_VISITOR);
        }
        super.onUserEventTriggered(channelHandlerContext, object);
    }

    final void flush0(ChannelHandlerContext channelHandlerContext) {
        this.flush(channelHandlerContext);
    }

    private final class Http2MultiplexCodecStreamChannel
    extends AbstractHttp2StreamChannel {
        Http2MultiplexCodecStreamChannel(Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream, ChannelHandler channelHandler) {
            super(defaultHttp2FrameStream, ++Http2MultiplexCodec.this.idCount, channelHandler);
        }

        @Override
        protected boolean isParentReadInProgress() {
            return Http2MultiplexCodec.this.parentReadInProgress;
        }

        @Override
        protected void addChannelToReadCompletePendingQueue() {
            while (!Http2MultiplexCodec.this.readCompletePendingQueue.offer(this)) {
                Http2MultiplexCodec.this.processPendingReadCompleteQueue();
            }
        }

        @Override
        protected ChannelHandlerContext parentContext() {
            return Http2MultiplexCodec.this.ctx;
        }

        @Override
        protected ChannelFuture write0(ChannelHandlerContext channelHandlerContext, Object object) {
            ChannelPromise channelPromise = channelHandlerContext.newPromise();
            Http2MultiplexCodec.this.write(channelHandlerContext, object, channelPromise);
            return channelPromise;
        }

        @Override
        protected void flush0(ChannelHandlerContext channelHandlerContext) {
            Http2MultiplexCodec.this.flush0(channelHandlerContext);
        }
    }
}

