/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ReadOnlyHttp2Headers
implements Http2Headers {
    private static final byte PSEUDO_HEADER_TOKEN = 58;
    private final AsciiString[] pseudoHeaders;
    private final AsciiString[] otherHeaders;

    public static ReadOnlyHttp2Headers trailers(boolean bl, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl, EmptyArrays.EMPTY_ASCII_STRINGS, asciiStringArray);
    }

    public static ReadOnlyHttp2Headers clientHeaders(boolean bl, AsciiString asciiString, AsciiString asciiString2, AsciiString asciiString3, AsciiString asciiString4, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl, new AsciiString[]{Http2Headers.PseudoHeaderName.METHOD.value(), asciiString, Http2Headers.PseudoHeaderName.PATH.value(), asciiString2, Http2Headers.PseudoHeaderName.SCHEME.value(), asciiString3, Http2Headers.PseudoHeaderName.AUTHORITY.value(), asciiString4}, asciiStringArray);
    }

    public static ReadOnlyHttp2Headers serverHeaders(boolean bl, AsciiString asciiString, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl, new AsciiString[]{Http2Headers.PseudoHeaderName.STATUS.value(), asciiString}, asciiStringArray);
    }

    private ReadOnlyHttp2Headers(boolean bl, AsciiString[] asciiStringArray, AsciiString ... asciiStringArray2) {
        assert ((asciiStringArray.length & 1) == 0);
        if ((asciiStringArray2.length & 1) != 0) {
            throw ReadOnlyHttp2Headers.newInvalidArraySizeException();
        }
        if (bl) {
            ReadOnlyHttp2Headers.validateHeaders(asciiStringArray, asciiStringArray2);
        }
        this.pseudoHeaders = asciiStringArray;
        this.otherHeaders = asciiStringArray2;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("pseudoHeaders and otherHeaders must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(AsciiString[] asciiStringArray, AsciiString ... asciiStringArray2) {
        int n;
        for (n = 1; n < asciiStringArray.length; n += 2) {
            ObjectUtil.checkNotNullArrayParam((Object)asciiStringArray[n], (int)n, (String)"pseudoHeaders");
        }
        n = 0;
        int n2 = asciiStringArray2.length - 1;
        for (int i = 0; i < n2; i += 2) {
            AsciiString asciiString = asciiStringArray2[i];
            DefaultHttp2Headers.HTTP2_NAME_VALIDATOR.validateName((Object)asciiString);
            if (n == 0 && !asciiString.isEmpty() && asciiString.byteAt(0) != 58) {
                n = 1;
            } else if (n != 0 && !asciiString.isEmpty() && asciiString.byteAt(0) == 58) {
                throw new IllegalArgumentException("otherHeaders name at index " + i + " is a pseudo header that appears after non-pseudo headers.");
            }
            ObjectUtil.checkNotNullArrayParam((Object)asciiStringArray2[i + 1], (int)(i + 1), (String)"otherHeaders");
        }
    }

    private AsciiString get0(CharSequence charSequence) {
        int n;
        int n2 = AsciiString.hashCode((CharSequence)charSequence);
        int n3 = this.pseudoHeaders.length - 1;
        for (n = 0; n < n3; n += 2) {
            AsciiString asciiString = this.pseudoHeaders[n];
            if (asciiString.hashCode() != n2 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            return this.pseudoHeaders[n + 1];
        }
        n = this.otherHeaders.length - 1;
        for (int i = 0; i < n; i += 2) {
            AsciiString asciiString = this.otherHeaders[i];
            if (asciiString.hashCode() != n2 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            return this.otherHeaders[i + 1];
        }
        return null;
    }

    public CharSequence get(CharSequence charSequence) {
        return this.get0(charSequence);
    }

    public CharSequence get(CharSequence charSequence, CharSequence charSequence2) {
        CharSequence charSequence3 = this.get(charSequence);
        return charSequence3 != null ? charSequence3 : charSequence2;
    }

    public CharSequence getAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public CharSequence getAndRemove(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    public List<CharSequence> getAll(CharSequence charSequence) {
        int n;
        int n2 = AsciiString.hashCode((CharSequence)charSequence);
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n3 = this.pseudoHeaders.length - 1;
        for (n = 0; n < n3; n += 2) {
            AsciiString asciiString = this.pseudoHeaders[n];
            if (asciiString.hashCode() != n2 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            arrayList.add((CharSequence)this.pseudoHeaders[n + 1]);
        }
        n = this.otherHeaders.length - 1;
        for (int i = 0; i < n; i += 2) {
            AsciiString asciiString = this.otherHeaders[i];
            if (asciiString.hashCode() != n2 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            arrayList.add((CharSequence)this.otherHeaders[i + 1]);
        }
        return arrayList;
    }

    public List<CharSequence> getAllAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public Boolean getBoolean(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Boolean.valueOf(CharSequenceValueConverter.INSTANCE.convertToBoolean((CharSequence)asciiString)) : null;
    }

    public boolean getBoolean(CharSequence charSequence, boolean bl) {
        Boolean bl2 = this.getBoolean(charSequence);
        return bl2 != null ? bl2 : bl;
    }

    public Byte getByte(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Byte.valueOf(CharSequenceValueConverter.INSTANCE.convertToByte((CharSequence)asciiString)) : null;
    }

    public byte getByte(CharSequence charSequence, byte by) {
        Byte by2 = this.getByte(charSequence);
        return by2 != null ? by2 : by;
    }

    public Character getChar(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Character.valueOf(CharSequenceValueConverter.INSTANCE.convertToChar((CharSequence)asciiString)) : null;
    }

    public char getChar(CharSequence charSequence, char c) {
        Character c2 = this.getChar(charSequence);
        return c2 != null ? c2.charValue() : c;
    }

    public Short getShort(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Short.valueOf(CharSequenceValueConverter.INSTANCE.convertToShort((CharSequence)asciiString)) : null;
    }

    public short getShort(CharSequence charSequence, short s) {
        Short s2 = this.getShort(charSequence);
        return s2 != null ? s2 : s;
    }

    public Integer getInt(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Integer.valueOf(CharSequenceValueConverter.INSTANCE.convertToInt((CharSequence)asciiString)) : null;
    }

    public int getInt(CharSequence charSequence, int n) {
        Integer n2 = this.getInt(charSequence);
        return n2 != null ? n2 : n;
    }

    public Long getLong(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Long.valueOf(CharSequenceValueConverter.INSTANCE.convertToLong((CharSequence)asciiString)) : null;
    }

    public long getLong(CharSequence charSequence, long l) {
        Long l2 = this.getLong(charSequence);
        return l2 != null ? l2 : l;
    }

    public Float getFloat(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Float.valueOf(CharSequenceValueConverter.INSTANCE.convertToFloat((CharSequence)asciiString)) : null;
    }

    public float getFloat(CharSequence charSequence, float f) {
        Float f2 = this.getFloat(charSequence);
        return f2 != null ? f2.floatValue() : f;
    }

    public Double getDouble(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Double.valueOf(CharSequenceValueConverter.INSTANCE.convertToDouble((CharSequence)asciiString)) : null;
    }

    public double getDouble(CharSequence charSequence, double d) {
        Double d2 = this.getDouble(charSequence);
        return d2 != null ? d2 : d;
    }

    public Long getTimeMillis(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Long.valueOf(CharSequenceValueConverter.INSTANCE.convertToTimeMillis((CharSequence)asciiString)) : null;
    }

    public long getTimeMillis(CharSequence charSequence, long l) {
        Long l2 = this.getTimeMillis(charSequence);
        return l2 != null ? l2 : l;
    }

    public Boolean getBooleanAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public boolean getBooleanAndRemove(CharSequence charSequence, boolean bl) {
        throw new UnsupportedOperationException("read only");
    }

    public Byte getByteAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public byte getByteAndRemove(CharSequence charSequence, byte by) {
        throw new UnsupportedOperationException("read only");
    }

    public Character getCharAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public char getCharAndRemove(CharSequence charSequence, char c) {
        throw new UnsupportedOperationException("read only");
    }

    public Short getShortAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public short getShortAndRemove(CharSequence charSequence, short s) {
        throw new UnsupportedOperationException("read only");
    }

    public Integer getIntAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public int getIntAndRemove(CharSequence charSequence, int n) {
        throw new UnsupportedOperationException("read only");
    }

    public Long getLongAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public long getLongAndRemove(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public Float getFloatAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public float getFloatAndRemove(CharSequence charSequence, float f) {
        throw new UnsupportedOperationException("read only");
    }

    public Double getDoubleAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public double getDoubleAndRemove(CharSequence charSequence, double d) {
        throw new UnsupportedOperationException("read only");
    }

    public Long getTimeMillisAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public long getTimeMillisAndRemove(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public boolean contains(CharSequence charSequence) {
        return this.get(charSequence) != null;
    }

    public boolean contains(CharSequence charSequence, CharSequence charSequence2) {
        return this.contains(charSequence, charSequence2, false);
    }

    public boolean containsObject(CharSequence charSequence, Object object) {
        if (object instanceof CharSequence) {
            return this.contains(charSequence, (CharSequence)object);
        }
        return this.contains(charSequence, object.toString());
    }

    public boolean containsBoolean(CharSequence charSequence, boolean bl) {
        return this.contains(charSequence, String.valueOf(bl));
    }

    public boolean containsByte(CharSequence charSequence, byte by) {
        return this.contains(charSequence, String.valueOf(by));
    }

    public boolean containsChar(CharSequence charSequence, char c) {
        return this.contains(charSequence, String.valueOf(c));
    }

    public boolean containsShort(CharSequence charSequence, short s) {
        return this.contains(charSequence, String.valueOf(s));
    }

    public boolean containsInt(CharSequence charSequence, int n) {
        return this.contains(charSequence, String.valueOf(n));
    }

    public boolean containsLong(CharSequence charSequence, long l) {
        return this.contains(charSequence, String.valueOf(l));
    }

    public boolean containsFloat(CharSequence charSequence, float f) {
        return false;
    }

    public boolean containsDouble(CharSequence charSequence, double d) {
        return this.contains(charSequence, String.valueOf(d));
    }

    public boolean containsTimeMillis(CharSequence charSequence, long l) {
        return this.contains(charSequence, String.valueOf(l));
    }

    public int size() {
        return this.pseudoHeaders.length + this.otherHeaders.length >>> 1;
    }

    public boolean isEmpty() {
        return this.pseudoHeaders.length == 0 && this.otherHeaders.length == 0;
    }

    public Set<CharSequence> names() {
        int n;
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<CharSequence> linkedHashSet = new LinkedHashSet<CharSequence>(this.size());
        int n2 = this.pseudoHeaders.length - 1;
        for (n = 0; n < n2; n += 2) {
            linkedHashSet.add((CharSequence)this.pseudoHeaders[n]);
        }
        n = this.otherHeaders.length - 1;
        for (int i = 0; i < n; i += 2) {
            linkedHashSet.add((CharSequence)this.otherHeaders[i]);
        }
        return linkedHashSet;
    }

    public Http2Headers add(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers add(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers add(CharSequence charSequence, CharSequence ... charSequenceArray) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addObject(CharSequence charSequence, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addObject(CharSequence charSequence, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addObject(CharSequence charSequence, Object ... objectArray) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addBoolean(CharSequence charSequence, boolean bl) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addByte(CharSequence charSequence, byte by) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addChar(CharSequence charSequence, char c) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addShort(CharSequence charSequence, short s) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addInt(CharSequence charSequence, int n) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addLong(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addFloat(CharSequence charSequence, float f) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addDouble(CharSequence charSequence, double d) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers addTimeMillis(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers set(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers set(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers set(CharSequence charSequence, CharSequence ... charSequenceArray) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setObject(CharSequence charSequence, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setObject(CharSequence charSequence, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setObject(CharSequence charSequence, Object ... objectArray) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setBoolean(CharSequence charSequence, boolean bl) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setByte(CharSequence charSequence, byte by) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setChar(CharSequence charSequence, char c) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setShort(CharSequence charSequence, short s) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setInt(CharSequence charSequence, int n) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setLong(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setFloat(CharSequence charSequence, float f) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setDouble(CharSequence charSequence, double d) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setTimeMillis(CharSequence charSequence, long l) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    public boolean remove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    public Http2Headers clear() {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return new ReadOnlyIterator();
    }

    @Override
    public Iterator<CharSequence> valueIterator(CharSequence charSequence) {
        return new ReadOnlyValueIterator(charSequence);
    }

    @Override
    public Http2Headers method(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers scheme(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers authority(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers path(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers status(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public CharSequence method() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.METHOD.value());
    }

    @Override
    public CharSequence scheme() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.SCHEME.value());
    }

    @Override
    public CharSequence authority() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.AUTHORITY.value());
    }

    @Override
    public CharSequence path() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.PATH.value());
    }

    @Override
    public CharSequence status() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.STATUS.value());
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        int n = AsciiString.hashCode((CharSequence)charSequence);
        HashingStrategy hashingStrategy = bl ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER;
        int n2 = hashingStrategy.hashCode((Object)charSequence2);
        return ReadOnlyHttp2Headers.contains(charSequence, n, charSequence2, n2, (HashingStrategy<CharSequence>)hashingStrategy, this.otherHeaders) || ReadOnlyHttp2Headers.contains(charSequence, n, charSequence2, n2, (HashingStrategy<CharSequence>)hashingStrategy, this.pseudoHeaders);
    }

    private static boolean contains(CharSequence charSequence, int n, CharSequence charSequence2, int n2, HashingStrategy<CharSequence> hashingStrategy, AsciiString[] asciiStringArray) {
        int n3 = asciiStringArray.length - 1;
        for (int i = 0; i < n3; i += 2) {
            AsciiString asciiString = asciiStringArray[i];
            AsciiString asciiString2 = asciiStringArray[i + 1];
            if (asciiString.hashCode() != n || asciiString2.hashCode() != n2 || !asciiString.contentEqualsIgnoreCase(charSequence) || !hashingStrategy.equals((Object)asciiString2, (Object)charSequence2)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String string = "";
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = iterator.next();
            stringBuilder.append(string);
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue());
            string = ", ";
        }
        return stringBuilder.append(']').toString();
    }

    private final class ReadOnlyIterator
    implements Iterator<Map.Entry<CharSequence, CharSequence>>,
    Map.Entry<CharSequence, CharSequence> {
        private int i;
        private AsciiString[] current;
        private AsciiString key;
        private AsciiString value;

        private ReadOnlyIterator() {
            this.current = ReadOnlyHttp2Headers.this.pseudoHeaders.length != 0 ? ReadOnlyHttp2Headers.this.pseudoHeaders : ReadOnlyHttp2Headers.this.otherHeaders;
        }

        @Override
        public boolean hasNext() {
            return this.i != this.current.length;
        }

        @Override
        public Map.Entry<CharSequence, CharSequence> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.key = this.current[this.i];
            this.value = this.current[this.i + 1];
            this.i += 2;
            if (this.i == this.current.length && this.current == ReadOnlyHttp2Headers.this.pseudoHeaders) {
                this.current = ReadOnlyHttp2Headers.this.otherHeaders;
                this.i = 0;
            }
            return this;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence charSequence) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read only");
        }

        public String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }
    }

    private final class ReadOnlyValueIterator
    implements Iterator<CharSequence> {
        private int i;
        private final int nameHash;
        private final CharSequence name;
        private AsciiString[] current;
        private AsciiString next;

        ReadOnlyValueIterator(CharSequence charSequence) {
            this.current = ReadOnlyHttp2Headers.this.pseudoHeaders.length != 0 ? ReadOnlyHttp2Headers.this.pseudoHeaders : ReadOnlyHttp2Headers.this.otherHeaders;
            this.nameHash = AsciiString.hashCode((CharSequence)charSequence);
            this.name = charSequence;
            this.calculateNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public CharSequence next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AsciiString asciiString = this.next;
            this.calculateNext();
            return asciiString;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read only");
        }

        private void calculateNext() {
            while (this.i < this.current.length) {
                AsciiString asciiString = this.current[this.i];
                if (asciiString.hashCode() == this.nameHash && asciiString.contentEqualsIgnoreCase(this.name)) {
                    if (this.i + 1 < this.current.length) {
                        this.next = this.current[this.i + 1];
                        this.i += 2;
                    }
                    return;
                }
                this.i += 2;
            }
            if (this.current == ReadOnlyHttp2Headers.this.pseudoHeaders) {
                this.i = 0;
                this.current = ReadOnlyHttp2Headers.this.otherHeaders;
                this.calculateNext();
            } else {
                this.next = null;
            }
        }
    }
}

