/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.ColorType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 %2\u00020\u0001:\u0001%B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u001a\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0005J\u0010\u0010#\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0012\u00a8\u0006&"}, d2={"Lorg/jetbrains/skia/ColorInfo;", "", "colorType", "Lorg/jetbrains/skia/ColorType;", "alphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "colorSpace", "Lorg/jetbrains/skia/ColorSpace;", "<init>", "(Lorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;Lorg/jetbrains/skia/ColorSpace;)V", "getColorType", "()Lorg/jetbrains/skia/ColorType;", "getAlphaType", "()Lorg/jetbrains/skia/ColorAlphaType;", "getColorSpace", "()Lorg/jetbrains/skia/ColorSpace;", "isOpaque", "", "()Z", "bytesPerPixel", "", "getBytesPerPixel", "()I", "shiftPerPixel", "getShiftPerPixel", "isGammaCloseToSRGB", "equals", "other", "hashCode", "toString", "", "withColorType", "_colorType", "withAlphaType", "_alphaType", "withColorSpace", "_colorSpace", "Companion", "skiko"})
public final class ColorInfo {
    public static final Companion Companion = new Companion(null);
    private final ColorType colorType;
    private final ColorAlphaType alphaType;
    private final ColorSpace colorSpace;
    private static final ColorInfo DEFAULT = new ColorInfo(ColorType.UNKNOWN, ColorAlphaType.UNKNOWN, null);

    public ColorInfo(ColorType colorType, ColorAlphaType colorAlphaType, ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
        this.colorType = colorType;
        this.alphaType = colorAlphaType;
        this.colorSpace = colorSpace;
    }

    public final ColorType getColorType() {
        return this.colorType;
    }

    public final ColorAlphaType getAlphaType() {
        return this.alphaType;
    }

    public final ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public final boolean isOpaque() {
        return this.alphaType == ColorAlphaType.OPAQUE || this.colorType.isAlwaysOpaque();
    }

    public final int getBytesPerPixel() {
        return this.colorType.getBytesPerPixel();
    }

    public final int getShiftPerPixel() {
        return this.colorType.getShiftPerPixel();
    }

    public final boolean isGammaCloseToSRGB() {
        return this.colorSpace != null && this.colorSpace.isGammaCloseToSRGB();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ColorInfo)) {
            return false;
        }
        if (this.colorType != ((ColorInfo)object).colorType) {
            return false;
        }
        if (this.alphaType != ((ColorInfo)object).alphaType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorSpace, (Object)((ColorInfo)object).colorSpace);
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * n + this.colorType.hashCode();
        n2 = n2 * n + this.alphaType.hashCode();
        ColorSpace colorSpace = this.colorSpace;
        n2 = n2 * n + (colorSpace != null ? ((Object)colorSpace).hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "ColorInfo(_colorType=" + (Object)((Object)this.colorType) + ", _alphaType=" + (Object)((Object)this.alphaType) + ", _colorSpace=" + this.colorSpace + ')';
    }

    public final ColorInfo withColorType(ColorType colorType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"");
        return this.colorType == colorType ? this : new ColorInfo(colorType, this.alphaType, this.colorSpace);
    }

    public final ColorInfo withAlphaType(ColorAlphaType colorAlphaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorAlphaType), (String)"");
        return this.alphaType == colorAlphaType ? this : new ColorInfo(this.colorType, colorAlphaType, this.colorSpace);
    }

    public final ColorInfo withColorSpace(ColorSpace colorSpace) {
        return this.colorSpace == colorSpace ? this : new ColorInfo(this.colorType, this.alphaType, colorSpace);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/skia/ColorInfo$Companion;", "", "<init>", "()V", "DEFAULT", "Lorg/jetbrains/skia/ColorInfo;", "getDEFAULT", "()Lorg/jetbrains/skia/ColorInfo;", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public final ColorInfo getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

