/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.IPoint;
import org.jetbrains.skia.Rect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0013\u001a\u00020\u0000J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\n\u00a8\u0006$"}, d2={"Lorg/jetbrains/skia/IRect;", "", "left", "", "top", "right", "bottom", "<init>", "(IIII)V", "getLeft", "()I", "getTop", "getRight", "getBottom", "width", "getWidth", "height", "getHeight", "intersect", "other", "offset", "dx", "dy", "vec", "Lorg/jetbrains/skia/IPoint;", "toRect", "Lorg/jetbrains/skia/Rect;", "serializeToIntArray", "", "serializeToIntArray$skiko", "equals", "", "hashCode", "toString", "", "Companion", "skiko"})
public final class IRect {
    public static final Companion Companion = new Companion(null);
    private final int left;
    private final int top;
    private final int right;
    private final int bottom;

    public IRect(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getTop() {
        return this.top;
    }

    public final int getRight() {
        return this.right;
    }

    public final int getBottom() {
        return this.bottom;
    }

    public final int getWidth() {
        return this.right - this.left;
    }

    public final int getHeight() {
        return this.bottom - this.top;
    }

    public final IRect intersect(IRect iRect) {
        Intrinsics.checkNotNullParameter((Object)iRect, (String)"");
        return this.right <= iRect.left || iRect.right <= this.left || this.bottom <= iRect.top || iRect.bottom <= this.top ? null : new IRect(Math.max(this.left, iRect.left), Math.max(this.top, iRect.top), Math.min(this.right, iRect.right), Math.min(this.bottom, iRect.bottom));
    }

    public final IRect offset(int n, int n2) {
        return new IRect(this.left + n, this.top + n2, this.right + n, this.bottom + n2);
    }

    public final IRect offset(IPoint iPoint) {
        Intrinsics.checkNotNullParameter((Object)iPoint, (String)"");
        return this.offset(iPoint.getX(), iPoint.getY());
    }

    public final Rect toRect() {
        return new Rect(this.left, this.top, this.right, this.bottom);
    }

    public final int[] serializeToIntArray$skiko() {
        int[] nArray = new int[]{this.left, this.top, this.right, this.bottom};
        return nArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IRect)) {
            return false;
        }
        if (this.left != ((IRect)object).left) {
            return false;
        }
        if (this.top != ((IRect)object).top) {
            return false;
        }
        if (this.right != ((IRect)object).right) {
            return false;
        }
        return this.bottom == ((IRect)object).bottom;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * n + this.left;
        n2 = n2 * n + this.top;
        n2 = n2 * n + this.right;
        n2 = n2 * n + this.bottom;
        return n2;
    }

    public String toString() {
        return "IRect(_left=" + this.left + ", _top=" + this.top + ", _right=" + this.right + ", _bottom=" + this.bottom + ')';
    }

    @JvmStatic
    public static final IRect makeLTRB(int n, int n2, int n3, int n4) {
        return Companion.makeLTRB(n, n2, n3, n4);
    }

    @JvmStatic
    public static final IRect makeXYWH(int n, int n2, int n3, int n4) {
        return Companion.makeXYWH(n, n2, n3, n4);
    }

    @JvmStatic
    public static final IRect makeWH(int n, int n2) {
        return Companion.makeWH(n, n2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0007J(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/skia/IRect$Companion;", "", "<init>", "()V", "makeLTRB", "Lorg/jetbrains/skia/IRect;", "l", "", "t", "r", "b", "makeXYWH", "w", "h", "makeWH", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final IRect makeLTRB(int n, int n2, int n3, int n4) {
            return new IRect(n, n2, n3, n4);
        }

        @JvmStatic
        public final IRect makeXYWH(int n, int n2, int n3, int n4) {
            return new IRect(n, n2, n + n3, n2 + n4);
        }

        @JvmStatic
        public final IRect makeWH(int n, int n2) {
            return new IRect(0, 0, n, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

