/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.RRect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\r\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u0013\u0010&\u001a\u00020$2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010%\u00a8\u0006,"}, d2={"Lorg/jetbrains/skia/Rect;", "", "left", "", "top", "right", "bottom", "<init>", "(FFFF)V", "getLeft", "()F", "getTop", "getRight", "getBottom", "width", "getWidth", "height", "getHeight", "intersect", "other", "scale", "sx", "sy", "offset", "dx", "dy", "vec", "Lorg/jetbrains/skia/Point;", "toIRect", "Lorg/jetbrains/skia/IRect;", "inflate", "spread", "serializeToFloatArray", "", "serializeToFloatArray$skiko", "isEmpty", "", "()Z", "equals", "hashCode", "", "toString", "", "Companion", "skiko"})
public class Rect {
    public static final Companion Companion = new Companion(null);
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;

    public Rect(float f, float f2, float f3, float f4) {
        this.left = f;
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.right - this.left;
    }

    public final float getHeight() {
        return this.bottom - this.top;
    }

    public final Rect intersect(Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"");
        return this.right <= rect.left || rect.right <= this.left || this.bottom <= rect.top || rect.bottom <= this.top ? null : new Rect(Math.max(this.left, rect.left), Math.max(this.top, rect.top), Math.min(this.right, rect.right), Math.min(this.bottom, rect.bottom));
    }

    public final Rect scale(float f) {
        return this.scale(f, f);
    }

    public final Rect scale(float f, float f2) {
        return new Rect(this.left * f, this.top * f2, this.right * f, this.bottom * f2);
    }

    public final Rect offset(float f, float f2) {
        return new Rect(this.left + f, this.top + f2, this.right + f, this.bottom + f2);
    }

    public final Rect offset(Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        return this.offset(point.getX(), point.getY());
    }

    public final IRect toIRect() {
        return new IRect((int)this.left, (int)this.top, (int)this.right, (int)this.bottom);
    }

    public Rect inflate(float f) {
        return f <= 0.0f ? Companion.makeLTRB(this.left - f, this.top - f, Math.max(this.left - f, this.right + f), Math.max(this.top - f, this.bottom + f)) : (Rect)RRect.Companion.makeLTRB(this.left - f, this.top - f, Math.max(this.left - f, this.right + f), Math.max(this.top - f, this.bottom + f), f);
    }

    public final float[] serializeToFloatArray$skiko() {
        float[] fArray = new float[]{this.left, this.top, this.right, this.bottom};
        return fArray;
    }

    public final boolean isEmpty() {
        return this.right == this.left || this.top == this.bottom;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rect)) {
            return false;
        }
        if (Float.compare(this.left, ((Rect)object).left) != 0) {
            return false;
        }
        if (Float.compare(this.top, ((Rect)object).top) != 0) {
            return false;
        }
        if (Float.compare(this.right, ((Rect)object).right) != 0) {
            return false;
        }
        return Float.compare(this.bottom, ((Rect)object).bottom) == 0;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * n + Float.floatToIntBits(this.left);
        n2 = n2 * n + Float.floatToIntBits(this.top);
        n2 = n2 * n + Float.floatToIntBits(this.right);
        n2 = n2 * n + Float.floatToIntBits(this.bottom);
        return n2;
    }

    public String toString() {
        return "Rect(_left=" + this.left + ", _top=" + this.top + ", _right=" + this.right + ", _bottom=" + this.bottom + ')';
    }

    @JvmStatic
    public static final Rect makeLTRB(float f, float f2, float f3, float f4) {
        return Companion.makeLTRB(f, f2, f3, f4);
    }

    @JvmStatic
    public static final Rect makeWH(float f, float f2) {
        return Companion.makeWH(f, f2);
    }

    @JvmStatic
    public static final Rect makeWH(Point point) {
        return Companion.makeWH(point);
    }

    @JvmStatic
    public static final Rect makeXYWH(float f, float f2, float f3, float f4) {
        return Companion.makeXYWH(f, f2, f3, f4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J(\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0007J0\u0010\u0011\u001a\u00020\u00052!\u0010\u0012\u001a\u001d\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u00060\u0016j\u0002`\u0015\u0012\u0004\u0012\u00020\u00170\u0013\u00a2\u0006\u0002\b\u0018H\u0000\u00a2\u0006\u0002\b\u0019J@\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u000e\u001a\u00020\u001b2!\u0010\u0012\u001a\u001d\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u00060\u0016j\u0002`\u0015\u0012\u0004\u0012\u00020\u00170\u0013\u00a2\u0006\u0002\b\u0018H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001cJ'\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u00060\u0016j\u0002`\u0015\u0012\u0004\u0012\u00020\u001f0\u001eH\u0000\u00a2\u0006\u0002\b \u00a8\u0006!"}, d2={"Lorg/jetbrains/skia/Rect$Companion;", "", "<init>", "()V", "makeLTRB", "Lorg/jetbrains/skia/Rect;", "l", "", "t", "r", "b", "makeWH", "w", "h", "size", "Lorg/jetbrains/skia/Point;", "makeXYWH", "fromInteropPointer", "block", "Lkotlin/Function2;", "Lorg/jetbrains/skia/impl/InteropScope;", "Lorg/jetbrains/skia/impl/InteropPointer;", "Ljava/lang/Object;", "", "Lkotlin/ExtensionFunctionType;", "fromInteropPointer$skiko", "", "", "(ILkotlin/jvm/functions/Function2;)[Lorg/jetbrains/skia/Rect;", "fromInteropPointerNullable", "Lkotlin/Function1;", "", "fromInteropPointerNullable$skiko", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final Rect makeLTRB(float f, float f2, float f3, float f4) {
            return new Rect(f, f2, f3, f4);
        }

        @JvmStatic
        public final Rect makeWH(float f, float f2) {
            return new Rect(0.0f, 0.0f, f, f2);
        }

        @JvmStatic
        public final Rect makeWH(Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"");
            return this.makeWH(point.getX(), point.getY());
        }

        @JvmStatic
        public final Rect makeXYWH(float f, float f2, float f3, float f4) {
            return new Rect(f, f2, f + f3, f2 + f4);
        }

        public final Rect fromInteropPointer$skiko(Function2<? super InteropScope, ? super Object, Unit> function2) {
            Intrinsics.checkNotNullParameter(function2, (String)"");
            float[] fArray = new float[4];
            boolean bl = false;
            boolean bl2 = false;
            InteropScope interopScope = theScope.INSTANCE;
            boolean bl3 = false;
            Object object = interopScope.toInteropForResult(fArray);
            function2.invoke((Object)interopScope, object);
            interopScope.fromInterop(object, fArray);
            float[] fArray2 = fArray;
            return new Rect(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
        }

        public final Rect[] fromInteropPointer$skiko(int n, Function2<? super InteropScope, ? super Object, Unit> function2) {
            Intrinsics.checkNotNullParameter(function2, (String)"");
            Object object = new float[n];
            boolean bl = false;
            boolean bl2 = false;
            Object object2 = theScope.INSTANCE;
            boolean bl3 = false;
            Iterator iterator = ((InteropScope)object2).toInteropForResult((float[])object);
            function2.invoke(object2, (Object)iterator);
            ((InteropScope)object2).fromInterop((Object)iterator, (float[])object);
            float[] fArray = object;
            object = CollectionsKt.chunked((Iterable)ArraysKt.toList((float[])fArray), (int)4);
            bl = false;
            Object object3 = object;
            object2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            bl3 = false;
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                List list2 = (List)t;
                Object object4 = object2;
                boolean bl4 = false;
                float f = ((Number)list2.get(0)).floatValue();
                float f2 = ((Number)list2.get(1)).floatValue();
                float f3 = ((Number)list2.get(2)).floatValue();
                float f4 = ((Number)list2.get(3)).floatValue();
                object4.add(new Rect(f, f3, f2, f4));
            }
            object = (List)object2;
            bl = false;
            object3 = object;
            return object3.toArray(new Rect[0]);
        }

        public final Rect fromInteropPointerNullable$skiko(Function1<? super Object, Boolean> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = true;
            Rect rect = this.fromInteropPointer$skiko((Function2<? super InteropScope, ? super Object, Unit>)((Function2)(arg_0, arg_1) -> Companion.fromInteropPointerNullable$lambda$1(booleanRef, function1, arg_0, arg_1)));
            return booleanRef.element ? rect : null;
        }

        private static final Unit fromInteropPointerNullable$lambda$1(Ref.BooleanRef booleanRef, Function1 function1, InteropScope interopScope, Object object) {
            Intrinsics.checkNotNullParameter((Object)booleanRef, (String)"");
            Intrinsics.checkNotNullParameter((Object)function1, (String)"");
            Intrinsics.checkNotNullParameter((Object)interopScope, (String)"");
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            booleanRef.element = (Boolean)function1.invoke(object);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

