/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.skiko.Actuals_jvmKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0019\u001a\u00020\u001aJ\f\u0010\u001d\u001a\u00020\u0003*\u00020\rH\u0002J\f\u0010\u001e\u001a\u00020\r*\u00020\u0003H\u0002J\f\u0010\u001f\u001a\u00020\r*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/skiko/FPSCounter;", "", "periodSeconds", "", "showLongFrames", "", "getLongFrameMillis", "Lkotlin/Function0;", "logOnTick", "<init>", "(DZLkotlin/jvm/functions/Function0;Z)V", "times", "", "", "lastLogTime", "lastTime", "value", "", "average", "getAverage", "()I", "min", "getMin", "max", "getMax", "tick", "", "nanosPerMillis", "nanosPerSecond", "nanosToMillis", "millisToNanos", "secondsToNanos", "skiko"})
public final class FPSCounter {
    private final double periodSeconds;
    private final boolean showLongFrames;
    private final Function0<Double> getLongFrameMillis;
    private final boolean logOnTick;
    private final List<Long> times;
    private long lastLogTime;
    private long lastTime;
    private int average;
    private int min;
    private int max;
    private final double nanosPerMillis;
    private final double nanosPerSecond;

    public FPSCounter(double d, boolean bl, Function0<Double> function0, boolean bl2) {
        Intrinsics.checkNotNullParameter(function0, (String)"");
        this.periodSeconds = d;
        this.showLongFrames = bl;
        this.getLongFrameMillis = function0;
        this.logOnTick = bl2;
        this.times = new ArrayList();
        this.lastLogTime = Actuals_jvmKt.currentNanoTime();
        this.lastTime = Actuals_jvmKt.currentNanoTime();
        this.nanosPerMillis = 1000000.0;
        this.nanosPerSecond = 1.0E9;
    }

    public /* synthetic */ FPSCounter(double d, boolean bl, Function0 function0, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 2.0;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function0 = FPSCounter::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(d, bl, (Function0<Double>)function0, bl2);
    }

    public final int getAverage() {
        return this.average;
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public final void tick() {
        long l = Actuals_jvmKt.currentNanoTime();
        long l2 = (long)this.nanosToMillis(l);
        long l3 = l - this.lastTime;
        this.lastTime = l;
        this.times.add(l3);
        if (this.logOnTick && this.showLongFrames && l3 > this.millisToNanos(((Number)this.getLongFrameMillis.invoke()).doubleValue())) {
            System.out.println((Object)(l2 + " Long frame " + this.nanosToMillis(l3) + " ms"));
        }
        if (l - this.lastLogTime > this.secondsToNanos(this.periodSeconds) && !((Collection)this.times).isEmpty()) {
            this.average = MathKt.roundToInt((double)(this.nanosPerSecond / CollectionsKt.averageOfLong((Iterable)this.times)));
            Comparable comparable = CollectionsKt.maxOrNull((Iterable)this.times);
            Intrinsics.checkNotNull((Object)comparable);
            this.min = MathKt.roundToInt((double)(this.nanosPerSecond / ((Number)((Object)comparable)).doubleValue()));
            Comparable comparable2 = CollectionsKt.minOrNull((Iterable)this.times);
            Intrinsics.checkNotNull((Object)comparable2);
            this.max = MathKt.roundToInt((double)(this.nanosPerSecond / ((Number)((Object)comparable2)).doubleValue()));
            this.times.clear();
            this.lastLogTime = l;
            if (this.logOnTick) {
                System.out.println((Object)("" + '[' + l2 + "] FPS " + this.average + " (" + this.min + '-' + this.max + ')'));
            }
        }
    }

    private final double nanosToMillis(long l) {
        return (double)l / this.nanosPerMillis;
    }

    private final long millisToNanos(double d) {
        return (long)(d * this.nanosPerMillis);
    }

    private final long secondsToNanos(double d) {
        return (long)(d * this.nanosPerSecond);
    }

    private static final double _init_$lambda$0() {
        return 25.0;
    }

    public FPSCounter() {
        this(0.0, false, null, false, 15, null);
    }
}

