/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.skiko.LibraryLoadException;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.Setup;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J \u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u0013\u001a\u00020\u0007J\b\u0010\u0014\u001a\u00020\u0007H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/skiko/Library;", "", "<init>", "()V", "copyDir", "Ljava/io/File;", "loadLibraryOrCopy", "", "library", "unpackIfNeeded", "dest", "resourceName", "", "deleteOnExit", "", "loadingLock", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/locks/ReentrantLock;", "kotlin.jvm.PlatformType", "load", "findAndLoad", "skiko"})
public final class Library {
    public static final Library INSTANCE = new Library();
    private static File copyDir;
    private static final AtomicReference<ReentrantLock> loadingLock;

    private Library() {
    }

    private final void loadLibraryOrCopy(File file) {
        try {
            System.load(file.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = unsatisfiedLinkError.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"already loaded in another classloader", (boolean)false, (int)2, null) : false;
            if (bl) {
                File file2 = copyDir = Files.createTempDirectory("skiko", new FileAttribute[0]).toFile();
                Intrinsics.checkNotNull((Object)file2);
                String string2 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                File file3 = FilesKt.resolve((File)file2, (String)string2);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(file.toPath(), file3.toPath(), copyOptionArray);
                file3.deleteOnExit();
                System.load(file3.getAbsolutePath());
            }
            throw unsatisfiedLinkError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File unpackIfNeeded(File file, String string, boolean bl) {
        File file2 = new File(file, string);
        if (!file2.exists()) {
            Path path = FilesKt.resolve((File)file, (String)".lock").toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"");
            Path path2 = path;
            boolean bl2 = false;
            PathsKt.createParentDirectories((Path)path2, (FileAttribute[])new FileAttribute[0]);
            Object object = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
            object = FileChannel.open(path2, object);
            Throwable throwable = null;
            try {
                Object object2;
                Object object3 = (FileChannel)object;
                boolean bl3 = false;
                FileLock fileLock = ((FileChannel)object3).lock();
                AutoCloseable autoCloseable = fileLock;
                Throwable throwable2 = null;
                try {
                    object2 = (FileLock)autoCloseable;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (file2.exists()) {
                        File file3 = file2;
                        File file4 = file3;
                        return file4;
                    }
                    File file5 = File.createTempFile("skiko", "", file);
                    if (bl) {
                        file2.deleteOnExit();
                    }
                    CopyOption[] copyOptionArray = (CopyOption[])Library.class.getResourceAsStream('/' + string);
                    Throwable throwable3 = null;
                    try {
                        InputStream inputStream = (InputStream)copyOptionArray;
                        boolean bl6 = false;
                        CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        long l = Files.copy(inputStream, file5.toPath(), copyOptionArray2);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)copyOptionArray, (Throwable)throwable3);
                    }
                    copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
                    object2 = Files.move(file5.toPath(), file2.toPath(), copyOptionArray);
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                object3 = object2;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        ReentrantLock reentrantLock = loadingLock.get();
        if (reentrantLock == null) {
            return;
        }
        ReentrantLock reentrantLock2 = reentrantLock;
        if (reentrantLock2.isHeldByCurrentThread()) {
            return;
        }
        Lock lock = reentrantLock2;
        lock.lock();
        try {
            boolean bl = false;
            if (loadingLock.get() != reentrantLock2) {
                return;
            }
            INSTANCE.findAndLoad();
            Setup.init$default(Setup.INSTANCE, false, false, false, false, false, 31, null);
            try {
                org.jetbrains.skia.impl.Library.Companion._nAfterLoad();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                loadingLock.compareAndSet(reentrantLock2, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void findAndLoad() {
        Object object;
        Object object2;
        String string;
        String string2 = "skiko-" + OsArch_jvmKt.getHostId();
        String string3 = System.mapLibraryName(string2);
        String string4 = string = OsArch_jvmKt.getHostOs().isWindows() ? "icudtl.dat" : null;
        if (OsArch_jvmKt.getHostOs() == OS.Android) {
            System.loadLibrary("skiko-" + OsArch_jvmKt.getHostId());
            return;
        }
        String string5 = SkikoProperties.INSTANCE.getLibraryPath();
        if (string5 != null) {
            File file = new File(new File(string5), string3);
            this.loadLibraryOrCopy(file);
            if (string != null && copyDir != null) {
                File file2 = copyDir;
                Intrinsics.checkNotNull((Object)file2);
                this.unpackIfNeeded(file2, string, true);
            }
            return;
        }
        File file = new File(System.getProperty("java.home"), OsArch_jvmKt.getHostOs().isWindows() ? "bin" : "lib");
        Intrinsics.checkNotNull((Object)string3);
        File file3 = FilesKt.resolve((File)file, (String)string3);
        if (file3.exists()) {
            boolean bl;
            String string6 = string;
            if (string6 != null) {
                object2 = string6;
                boolean bl2 = false;
                bl = !FilesKt.resolve((File)file, (String)object2).exists();
            } else {
                bl = false;
            }
            if (!bl) {
                this.loadLibraryOrCopy(file3);
                return;
            }
        }
        InputStream inputStream = Library.class.getResourceAsStream('/' + string3 + ".sha256");
        if (inputStream == null) {
            throw new LibraryLoadException("Cannot find " + string3 + ".sha256, proper native dependency missing.");
        }
        InputStream inputStream2 = inputStream;
        Object object3 = inputStream2;
        Serializable serializable = null;
        try {
            object = (InputStream)object3;
            boolean bl = false;
            InputStream inputStream3 = object;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream3, charset);
            int n = 8192;
            object = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object3, (Throwable)serializable);
        }
        object2 = object;
        object3 = new File(new File(SkikoProperties.INSTANCE.getDataPath()), (String)object2);
        ((File)object3).mkdirs();
        serializable = this.unpackIfNeeded((File)object3, string3, false);
        this.loadLibraryOrCopy((File)serializable);
        if (string != null) {
            File file4;
            if (copyDir != null) {
                File file5 = copyDir;
                Intrinsics.checkNotNull((Object)file5);
                file4 = this.unpackIfNeeded(file5, string, true);
            } else {
                file4 = this.unpackIfNeeded((File)object3, string, false);
            }
        }
    }

    static {
        loadingLock = new AtomicReference<ReentrantLock>(new ReentrantLock());
    }
}

