/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.MetalAdapter;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.ContextBasedContextHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\fH\u0002J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0019H\u0082 J!\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0082 J\u0011\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0019H\u0082 R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/skiko/context/MetalContextHandler;", "Lorg/jetbrains/skiko/context/ContextBasedContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "device", "Lorg/jetbrains/skiko/redrawer/MetalDevice;", "adapter", "Lorg/jetbrains/skiko/MetalAdapter;", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;JLorg/jetbrains/skiko/MetalAdapter;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "initCanvas", "", "flush", "rendererInfo", "", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "width", "", "height", "makeContext", "Lorg/jetbrains/skia/DirectContext;", "finishFrame", "makeMetalContext", "", "makeMetalRenderTarget", "skiko"})
public final class MetalContextHandler
extends ContextBasedContextHandler {
    private final long device;
    private final MetalAdapter adapter;

    private MetalContextHandler(SkiaLayer skiaLayer, long l, MetalAdapter metalAdapter) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        Intrinsics.checkNotNullParameter((Object)metalAdapter, (String)"");
        super(skiaLayer, "Metal");
        this.device = l;
        this.adapter = metalAdapter;
    }

    @Override
    protected void initCanvas() {
        this.disposeCanvas();
        float f = this.getLayer().getContentScale();
        int n2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getBackedLayer$skiko().getWidth() * f)), (int)0);
        int n3 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getBackedLayer$skiko().getHeight() * f)), (int)0);
        if (n2 > 0 && n3 > 0) {
            this.setRenderTarget(this.makeRenderTarget(n2, n3));
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget(directContext, backendRenderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null));
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
            Surface surface2 = this.getSurface();
            Intrinsics.checkNotNull((Object)surface2);
            this.setCanvas(surface2.getCanvas());
        } else {
            this.setRenderTarget(null);
            this.setSurface(null);
            this.setCanvas(null);
        }
    }

    @Override
    protected void flush() {
        super.flush();
        Surface surface = this.getSurface();
        if (surface != null) {
            surface.flushAndSubmit();
        }
        this.finishFrame();
        Logger logger = Logger.INSTANCE;
        boolean bl = false;
        if (logger.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
            boolean bl2 = false;
            skikoLoggerInterface.debug("MetalContextHandler finished drawing frame");
        }
    }

    @Override
    public String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.adapter.getName() + "\nTotal VRAM: " + this.adapter.getMemorySize() / (long)1024 / (long)1024 + " MB\n";
    }

    private final BackendRenderTarget makeRenderTarget(int n2, int n3) {
        return new BackendRenderTarget(this.makeMetalRenderTarget(this.device, n2, n3));
    }

    @Override
    protected DirectContext makeContext() {
        return new DirectContext(this.makeMetalContext(this.device));
    }

    private final void finishFrame() {
        this.finishFrame(this.device);
    }

    private final native long makeMetalContext(long var1);

    private final native long makeMetalRenderTarget(long var1, int var3, int var4);

    private final native void finishFrame(long var1);

    public /* synthetic */ MetalContextHandler(SkiaLayer skiaLayer, long l, MetalAdapter metalAdapter, DefaultConstructorMarker defaultConstructorMarker) {
        this(skiaLayer, l, metalAdapter);
    }
}

