/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.FPSCounter;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.Version;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0004J\b\u0010\u0018\u001a\u00020\u0014H\u0004J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001eH\u0084\b\u00f8\u0001\u0000J\b\u0010\u001f\u001a\u00020\u0014H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006 "}, d2={"Lorg/jetbrains/skiko/redrawer/AWTRedrawer;", "Lorg/jetbrains/skiko/redrawer/Redrawer;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "graphicsApi", "Lorg/jetbrains/skiko/GraphicsApi;", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/GraphicsApi;)V", "isFirstFrameRendered", "", "rendererAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$RendererAnalytics;", "deviceAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$DeviceAnalytics;", "value", "isDisposed", "()Z", "dispose", "", "onDeviceChosen", "deviceName", "", "onContextInit", "update", "nanoTime", "", "inDrawScope", "body", "Lkotlin/Function0;", "checkDisposed", "skiko"})
public abstract class AWTRedrawer
implements Redrawer {
    private final SkiaLayer layer;
    private final SkiaLayerAnalytics analytics;
    private final GraphicsApi graphicsApi;
    private boolean isFirstFrameRendered;
    private final SkiaLayerAnalytics.RendererAnalytics rendererAnalytics;
    private SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
    private boolean isDisposed;

    public AWTRedrawer(SkiaLayer skiaLayer, SkiaLayerAnalytics skiaLayerAnalytics, GraphicsApi graphicsApi) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
        this.layer = skiaLayer;
        this.analytics = skiaLayerAnalytics;
        this.graphicsApi = graphicsApi;
        this.rendererAnalytics = this.analytics.renderer(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi);
        this.rendererAnalytics.init();
    }

    protected final boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void dispose() {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.isDisposed = true;
    }

    protected final void onDeviceChosen(String string) {
        block1: {
            this.checkDisposed();
            if (!(this.deviceAnalytics == null)) {
                boolean bl = false;
                String string2 = "deviceAnalytics is not null";
                throw new IllegalArgumentException(string2.toString());
            }
            this.rendererAnalytics.deviceChosen();
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics = this.analytics.device(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi, string);
            if (deviceAnalytics == null) break block1;
            deviceAnalytics.init();
        }
    }

    protected final void onContextInit() {
        block1: {
            this.checkDisposed();
            if (this.deviceAnalytics == null) {
                boolean bl = false;
                String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                throw new IllegalArgumentException(string.toString());
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
            if (deviceAnalytics == null) break block1;
            deviceAnalytics.contextInit();
        }
    }

    @Override
    public void update(long l) {
        this.checkDisposed();
        this.layer.update$skiko(l);
    }

    protected final void inDrawScope(Function0<Unit> function0) {
        block16: {
            boolean bl;
            block15: {
                Intrinsics.checkNotNullParameter(function0, (String)"");
                boolean bl2 = false;
                if (this.deviceAnalytics == null) {
                    boolean bl3 = false;
                    String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                    throw new IllegalArgumentException(string.toString());
                }
                if (this.isDisposed) break block16;
                bl = !this.isFirstFrameRendered;
                this.isFirstFrameRendered = true;
                if (bl) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.beforeFrameRender();
                }
                SkiaLayer skiaLayer = this.layer;
                boolean bl4 = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    boolean bl5 = false;
                    String string = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException(string.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(skiaLayer))) {
                    boolean bl6 = false;
                    String string = "SkiaLayer is disposed";
                    throw new IllegalStateException(string.toString());
                }
                try {
                    FPSCounter fPSCounter = SkiaLayer.access$getFpsCounter$p(skiaLayer);
                    if (fPSCounter != null) {
                        fPSCounter.tick();
                    }
                    function0.invoke();
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException renderException) {
                    if (SkiaLayer.access$isDisposed$p(skiaLayer)) break block15;
                    Logger logger = Logger.INSTANCE;
                    boolean bl7 = false;
                    if (logger.getLoggerImpl().isWarnEnabled()) {
                        Throwable throwable = renderException;
                        SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                        boolean bl8 = false;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface.warn(throwable, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(skiaLayer), false, 1, null);
                    Redrawer redrawer = skiaLayer.getRedrawer$skiko();
                    if (redrawer != null) {
                        redrawer.renderImmediately();
                    }
                }
            }
            if (bl && !this.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
            if (deviceAnalytics != null) {
                deviceAnalytics.afterFrameRender();
            }
        }
    }

    protected final void checkDisposed() {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = this.getClass().getSimpleName() + " is disposed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public void syncBounds() {
        Redrawer.DefaultImpls.syncBounds(this);
    }

    @Override
    public void setVisible(boolean bl) {
        Redrawer.DefaultImpls.setVisible(this, bl);
    }
}

