/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.MetalAdapter;
import org.jetbrains.skiko.MetalApiKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.AcceleratedSwingPainter;
import org.jetbrains.skiko.swing.SoftwareSwingPainter;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingPainter;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000fH\u0014J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\rH\u0002J\u0011\u0010\"\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000fH\u0082 J\u0011\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000fH\u0082 J)\u0010%\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0082 J\u0011\u0010'\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000fH\u0082 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/skiko/swing/MetalSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "adapter", "Lorg/jetbrains/skiko/MetalAdapter;", "context", "Lorg/jetbrains/skia/DirectContext;", "texturePtr", "", "painter", "Lorg/jetbrains/skiko/swing/SwingPainter;", "dispose", "", "onRender", "g", "Ljava/awt/Graphics2D;", "width", "", "height", "nanoTime", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "rendererInfo", "", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "makeMetalContext", "makeMetalRenderTargetOffScreen", "texture", "makeMetalTexture", "oldTexture", "disposeMetalTexture", "Companion", "skiko"})
public final class MetalSwingRedrawer
extends SwingRedrawerBase {
    public static final Companion Companion = new Companion(null);
    private final SkikoRenderDelegate renderDelegate;
    private final MetalAdapter adapter;
    private final DirectContext context;
    private long texturePtr;
    private final SwingPainter painter;

    public MetalSwingRedrawer(SwingLayerProperties swingLayerProperties2, SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics) {
        MetalAdapter metalAdapter;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        Intrinsics.checkNotNullParameter((Object)skikoRenderDelegate, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        super(swingLayerProperties2, skiaLayerAnalytics, GraphicsApi.METAL);
        this.renderDelegate = skikoRenderDelegate;
        MetalAdapter metalAdapter2 = metalAdapter = MetalApiKt.chooseMetalAdapter(swingLayerProperties2.getAdapterPriority());
        MetalSwingRedrawer metalSwingRedrawer = this;
        boolean bl = false;
        this.onDeviceChosen(metalAdapter2.getName());
        metalSwingRedrawer.adapter = metalAdapter;
        this.context = this.makeMetalContext();
        this.onContextInit(this.context);
        this.painter = MetalSwingRedrawer.Companion.createSwingPainter(swingLayerProperties2);
    }

    @Override
    public void dispose() {
        this.disposeMetalTexture(this.texturePtr);
        this.context.close();
        MetalApiKt.dispose(this.adapter);
        this.painter.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRender(Graphics2D graphics2D, int n2, int n3, long l) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        if (n2 < 1 || n3 < 1) {
            return;
        }
        boolean bl = false;
        long l2 = MetalApiKt.access$openAutoreleasepool();
        try {
            boolean bl2 = false;
            ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)arg_0 -> MetalSwingRedrawer.onRender$lambda$2$lambda$1(this, n2, n3, l, graphics2D, arg_0)));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            MetalApiKt.access$closeAutoreleasepool(l2);
        }
    }

    private final void flush(Surface surface, Graphics2D graphics2D) {
        surface.flushAndSubmit(true);
        this.painter.paint(graphics2D, surface, this.texturePtr);
    }

    @Override
    protected String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.adapter.getName() + "\nTotal VRAM: " + this.adapter.getMemorySize() / (long)1024 / (long)1024 + " MB\n";
    }

    private final BackendRenderTarget makeRenderTarget() {
        return new BackendRenderTarget(this.makeMetalRenderTargetOffScreen(this.texturePtr));
    }

    private final DirectContext makeMetalContext() {
        return new DirectContext(this.makeMetalContext(this.adapter.getPtr()));
    }

    private final native long makeMetalContext(long var1);

    private final native long makeMetalRenderTargetOffScreen(long var1);

    private final native long makeMetalTexture(long var1, long var3, int var5, int var6);

    private final native long disposeMetalTexture(long var1);

    private static final Unit onRender$lambda$2$lambda$1(MetalSwingRedrawer metalSwingRedrawer, int n2, int n3, long l, Graphics2D graphics2D, CloseScope closeScope) {
        Surface surface;
        Intrinsics.checkNotNullParameter((Object)metalSwingRedrawer, (String)"");
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        Intrinsics.checkNotNullParameter((Object)closeScope, (String)"");
        metalSwingRedrawer.texturePtr = metalSwingRedrawer.makeMetalTexture(metalSwingRedrawer.adapter.getPtr(), metalSwingRedrawer.texturePtr, n2, n3);
        BackendRenderTarget backendRenderTarget = (BackendRenderTarget)closeScope.autoClose((AutoCloseable)metalSwingRedrawer.makeRenderTarget());
        Managed managed = Surface.Companion.makeFromBackendRenderTarget(metalSwingRedrawer.context, backendRenderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
        if (managed == null || (surface = (Surface)closeScope.autoClose((AutoCloseable)managed)) == null) {
            throw new RenderException("Cannot create surface", null, 2, null);
        }
        Surface surface2 = surface;
        managed = surface2.getCanvas();
        ((Canvas)managed).clear(0);
        metalSwingRedrawer.renderDelegate.onRender((Canvas)managed, n2, n3, l);
        metalSwingRedrawer.flush(surface2, graphics2D);
        return Unit.INSTANCE;
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/skiko/swing/MetalSwingRedrawer$Companion;", "", "<init>", "()V", "createSwingPainter", "Lorg/jetbrains/skiko/swing/SwingPainter;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        private final SwingPainter createSwingPainter(SwingLayerProperties swingLayerProperties2) {
            SwingPainter swingPainter;
            try {
                swingPainter = new AcceleratedSwingPainter();
            }
            catch (RenderException renderException) {
                swingPainter = new SoftwareSwingPainter(swingLayerProperties2);
            }
            return swingPainter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

