/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ByteProcessor;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.NettyRuntime;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ReferenceCountUpdater;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Arrays;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.StampedLock;

final class AdaptivePoolingAllocator
implements AdaptiveByteBufAllocator.AdaptiveAllocatorApi {
    private static final int MIN_CHUNK_SIZE = 131072;
    private static final int EXPANSION_ATTEMPTS = 3;
    private static final int INITIAL_MAGAZINES = 4;
    private static final int RETIRE_CAPACITY = 4096;
    private static final int MAX_STRIPES = NettyRuntime.availableProcessors() * 2;
    private static final int BUFS_PER_CHUNK = 10;
    private static final int MAX_CHUNK_SIZE = 0xA00000;
    private static final int CENTRAL_QUEUE_CAPACITY = Math.max(2, SystemPropertyUtil.getInt((String)"io.netty.allocator.centralQueueCapacity", (int)NettyRuntime.availableProcessors()));
    private static final int MAGAZINE_BUFFER_QUEUE_CAPACITY = SystemPropertyUtil.getInt((String)"io.netty.allocator.magazineBufferQueueCapacity", (int)1024);
    private static final Object NO_MAGAZINE = Boolean.TRUE;
    private final ChunkAllocator chunkAllocator;
    private final Queue<Chunk> centralQueue;
    private final StampedLock magazineExpandLock;
    private volatile Magazine[] magazines;
    private final FastThreadLocal<Object> threadLocalMagazine;
    private final Set<Magazine> liveCachedMagazines;
    private volatile boolean freed;

    AdaptivePoolingAllocator(ChunkAllocator chunkAllocator, MagazineCaching magazineCaching) {
        ObjectUtil.checkNotNull((Object)chunkAllocator, (String)"chunkAllocator");
        ObjectUtil.checkNotNull((Object)((Object)magazineCaching), (String)"magazineCaching");
        this.chunkAllocator = chunkAllocator;
        this.centralQueue = (Queue)ObjectUtil.checkNotNull(AdaptivePoolingAllocator.createSharedChunkQueue(), (String)"centralQueue");
        this.magazineExpandLock = new StampedLock();
        if (magazineCaching != MagazineCaching.None) {
            assert (magazineCaching == MagazineCaching.EventLoopThreads || magazineCaching == MagazineCaching.FastThreadLocalThreads);
            final boolean bl = magazineCaching == MagazineCaching.FastThreadLocalThreads;
            final CopyOnWriteArraySet<Magazine> copyOnWriteArraySet = new CopyOnWriteArraySet<Magazine>();
            this.threadLocalMagazine = new FastThreadLocal<Object>(){

                protected Object initialValue() {
                    if (bl || ThreadExecutorMap.currentExecutor() != null) {
                        if (!FastThreadLocalThread.willCleanupFastThreadLocals((Thread)Thread.currentThread())) {
                            return NO_MAGAZINE;
                        }
                        Magazine magazine = new Magazine(AdaptivePoolingAllocator.this, false);
                        copyOnWriteArraySet.add(magazine);
                        return magazine;
                    }
                    return NO_MAGAZINE;
                }

                protected void onRemoval(Object object) {
                    if (object != NO_MAGAZINE) {
                        copyOnWriteArraySet.remove(object);
                    }
                }
            };
            this.liveCachedMagazines = copyOnWriteArraySet;
        } else {
            this.threadLocalMagazine = null;
            this.liveCachedMagazines = null;
        }
        Magazine[] magazineArray = new Magazine[4];
        for (int i = 0; i < magazineArray.length; ++i) {
            magazineArray[i] = new Magazine(this);
        }
        this.magazines = magazineArray;
    }

    private static Queue<Chunk> createSharedChunkQueue() {
        return PlatformDependent.newFixedMpmcQueue((int)CENTRAL_QUEUE_CAPACITY);
    }

    @Override
    public ByteBuf allocate(int n, int n2) {
        return this.allocate(n, n2, Thread.currentThread(), null);
    }

    private AdaptiveByteBuf allocate(int n, int n2, Thread thread, AdaptiveByteBuf adaptiveByteBuf) {
        if (n <= 0xA00000) {
            Magazine[] magazineArray;
            Object object;
            int n3 = AllocationStatistics.sizeBucket(n);
            FastThreadLocal<Object> fastThreadLocal = this.threadLocalMagazine;
            if (fastThreadLocal != null && thread instanceof FastThreadLocalThread && (object = fastThreadLocal.get()) != NO_MAGAZINE) {
                Magazine magazine = (Magazine)object;
                if (adaptiveByteBuf == null) {
                    adaptiveByteBuf = magazine.newBuffer();
                }
                boolean bl = magazine.tryAllocate(n, n3, n2, adaptiveByteBuf);
                assert (bl) : "Allocation of threadLocalMagazine must always succeed";
                return adaptiveByteBuf;
            }
            long l = thread.getId();
            int n4 = 0;
            do {
                magazineArray = this.magazines;
                int n5 = magazineArray.length - 1;
                int n6 = (int)(l & (long)n5);
                int n7 = Integer.numberOfTrailingZeros(~n5);
                for (int i = 0; i < n7; ++i) {
                    Magazine magazine = magazineArray[n6 + i & n5];
                    if (adaptiveByteBuf == null) {
                        adaptiveByteBuf = magazine.newBuffer();
                    }
                    if (!magazine.tryAllocate(n, n3, n2, adaptiveByteBuf)) continue;
                    return adaptiveByteBuf;
                }
            } while (++n4 <= 3 && this.tryExpandMagazines(magazineArray.length));
        }
        return this.allocateFallback(n, n2, thread, adaptiveByteBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdaptiveByteBuf allocateFallback(int n, int n2, Thread thread, AdaptiveByteBuf adaptiveByteBuf) {
        Magazine magazine;
        Object object;
        if (adaptiveByteBuf != null) {
            object = adaptiveByteBuf.chunk;
            if (object == null || object == Magazine.MAGAZINE_FREED || (magazine = object.currentMagazine()) == null) {
                magazine = this.getFallbackMagazine(thread);
            }
        } else {
            magazine = this.getFallbackMagazine(thread);
            adaptiveByteBuf = magazine.newBuffer();
        }
        object = this.chunkAllocator.allocate(n, n2);
        Chunk chunk = new Chunk((AbstractByteBuf)object, magazine, false);
        try {
            chunk.readInitInto(adaptiveByteBuf, n, n2);
        }
        finally {
            chunk.release();
        }
        return adaptiveByteBuf;
    }

    private Magazine getFallbackMagazine(Thread thread) {
        Object object;
        FastThreadLocal<Object> fastThreadLocal = this.threadLocalMagazine;
        if (fastThreadLocal != null && thread instanceof FastThreadLocalThread && (object = fastThreadLocal.get()) != NO_MAGAZINE) {
            return (Magazine)object;
        }
        Magazine[] magazineArray = this.magazines;
        return magazineArray[(int)thread.getId() & magazineArray.length - 1];
    }

    void allocate(int n, int n2, AdaptiveByteBuf adaptiveByteBuf) {
        AdaptiveByteBuf adaptiveByteBuf2 = this.allocate(n, n2, Thread.currentThread(), adaptiveByteBuf);
        assert (adaptiveByteBuf2 == adaptiveByteBuf) : "Re-allocation created separate buffer instance";
    }

    @Override
    public long usedMemory() {
        long l = 0L;
        for (Chunk chunk : this.centralQueue) {
            l += (long)chunk.capacity();
        }
        for (Magazine magazine : this.magazines) {
            l += magazine.usedMemory.get();
        }
        if (this.liveCachedMagazines != null) {
            for (Magazine magazine : this.liveCachedMagazines) {
                l += magazine.usedMemory.get();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryExpandMagazines(int n) {
        if (n >= MAX_STRIPES) {
            return true;
        }
        long l = this.magazineExpandLock.tryWriteLock();
        if (l != 0L) {
            Magazine[] magazineArray;
            try {
                magazineArray = this.magazines;
                if (magazineArray.length >= MAX_STRIPES || magazineArray.length > n || this.freed) {
                    boolean bl = true;
                    return bl;
                }
                int n2 = magazineArray[0].sharedPrefChunkSize;
                Magazine[] magazineArray2 = new Magazine[magazineArray.length * 2];
                int n3 = magazineArray2.length;
                for (int i = 0; i < n3; ++i) {
                    Magazine magazine = new Magazine(this);
                    magazine.localPrefChunkSize = n2;
                    magazine.sharedPrefChunkSize = n2;
                    magazineArray2[i] = magazine;
                }
                this.magazines = magazineArray2;
            }
            finally {
                this.magazineExpandLock.unlockWrite(l);
            }
            for (Magazine magazine : magazineArray) {
                magazine.free();
            }
        }
        return true;
    }

    private boolean offerToQueue(Chunk chunk) {
        if (this.freed) {
            return false;
        }
        assert (chunk.allocatedBytes == 0);
        assert (chunk.magazine == null);
        boolean bl = this.centralQueue.offer(chunk);
        if (this.freed && bl) {
            this.freeCentralQueue();
        }
        return bl;
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        finally {
            this.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void free() {
        this.freed = true;
        long l = this.magazineExpandLock.writeLock();
        try {
            Magazine[] magazineArray;
            for (Magazine magazine : magazineArray = this.magazines) {
                magazine.free();
            }
        }
        finally {
            this.magazineExpandLock.unlockWrite(l);
        }
        this.freeCentralQueue();
    }

    private void freeCentralQueue() {
        Chunk chunk;
        while ((chunk = this.centralQueue.poll()) != null) {
            chunk.release();
        }
    }

    static int sizeBucket(int n) {
        return AllocationStatistics.sizeBucket(n);
    }

    static {
        if (CENTRAL_QUEUE_CAPACITY < 2) {
            throw new IllegalArgumentException("CENTRAL_QUEUE_CAPACITY: " + CENTRAL_QUEUE_CAPACITY + " (expected: >= " + 2 + ')');
        }
        if (MAGAZINE_BUFFER_QUEUE_CAPACITY < 2) {
            throw new IllegalArgumentException("MAGAZINE_BUFFER_QUEUE_CAPACITY: " + MAGAZINE_BUFFER_QUEUE_CAPACITY + " (expected: >= " + 2 + ')');
        }
    }

    static interface ChunkAllocator {
        public AbstractByteBuf allocate(int var1, int var2);
    }

    static final class AdaptiveByteBuf
    extends AbstractReferenceCountedByteBuf {
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;
        private int adjustment;
        private AbstractByteBuf rootParent;
        Chunk chunk;
        private int length;
        private ByteBuffer tmpNioBuf;
        private boolean hasArray;
        private boolean hasMemoryAddress;

        AdaptiveByteBuf(ObjectPool.Handle<AdaptiveByteBuf> handle) {
            super(0);
            this.handle = (ObjectPool.Handle)ObjectUtil.checkNotNull(handle, (String)"recyclerHandle");
        }

        void init(AbstractByteBuf abstractByteBuf, Chunk chunk, int n, int n2, int n3, int n4, int n5) {
            this.adjustment = n3;
            this.chunk = chunk;
            this.length = n4;
            this.maxCapacity(n5);
            this.setIndex0(n, n2);
            this.hasArray = abstractByteBuf.hasArray();
            this.hasMemoryAddress = abstractByteBuf.hasMemoryAddress();
            this.rootParent = abstractByteBuf;
            this.tmpNioBuf = abstractByteBuf.internalNioBuffer(n3, n4).slice();
        }

        private AbstractByteBuf rootParent() {
            AbstractByteBuf abstractByteBuf = this.rootParent;
            if (abstractByteBuf != null) {
                return abstractByteBuf;
            }
            throw new IllegalReferenceCountException();
        }

        @Override
        public int capacity() {
            return this.length;
        }

        @Override
        public ByteBuf capacity(int n) {
            if (n == this.capacity()) {
                this.ensureAccessible();
                return this;
            }
            this.checkNewCapacity(n);
            if (n < this.capacity()) {
                this.length = n;
                this.setIndex0(Math.min(this.readerIndex(), n), Math.min(this.writerIndex(), n));
                return this;
            }
            ByteBuffer byteBuffer = this.tmpNioBuf;
            byteBuffer.clear();
            this.tmpNioBuf = null;
            Chunk chunk = this.chunk;
            AdaptivePoolingAllocator adaptivePoolingAllocator = chunk.allocator;
            int n2 = this.readerIndex;
            int n3 = this.writerIndex;
            adaptivePoolingAllocator.allocate(n, this.maxCapacity(), this);
            this.tmpNioBuf.put(byteBuffer);
            this.tmpNioBuf.clear();
            chunk.release();
            this.readerIndex = n2;
            this.writerIndex = n3;
            return this;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.rootParent().alloc();
        }

        @Override
        public ByteOrder order() {
            return this.rootParent().order();
        }

        @Override
        public ByteBuf unwrap() {
            return null;
        }

        @Override
        public boolean isDirect() {
            return this.rootParent().isDirect();
        }

        @Override
        public int arrayOffset() {
            return this.idx(this.rootParent().arrayOffset());
        }

        @Override
        public boolean hasMemoryAddress() {
            return this.hasMemoryAddress;
        }

        @Override
        public long memoryAddress() {
            this.ensureAccessible();
            return this.rootParent().memoryAddress() + (long)this.adjustment;
        }

        @Override
        public ByteBuffer nioBuffer(int n, int n2) {
            this.checkIndex(n, n2);
            return this.rootParent().nioBuffer(this.idx(n), n2);
        }

        @Override
        public ByteBuffer internalNioBuffer(int n, int n2) {
            this.checkIndex(n, n2);
            return (ByteBuffer)this.internalNioBuffer().position(n).limit(n + n2);
        }

        private ByteBuffer internalNioBuffer() {
            return (ByteBuffer)this.tmpNioBuf.clear();
        }

        @Override
        public ByteBuffer[] nioBuffers(int n, int n2) {
            this.checkIndex(n, n2);
            return this.rootParent().nioBuffers(this.idx(n), n2);
        }

        @Override
        public boolean hasArray() {
            return this.hasArray;
        }

        @Override
        public byte[] array() {
            this.ensureAccessible();
            return this.rootParent().array();
        }

        @Override
        public ByteBuf copy(int n, int n2) {
            this.checkIndex(n, n2);
            return this.rootParent().copy(this.idx(n), n2);
        }

        @Override
        public int nioBufferCount() {
            return this.rootParent().nioBufferCount();
        }

        @Override
        protected byte _getByte(int n) {
            return this.rootParent()._getByte(this.idx(n));
        }

        @Override
        protected short _getShort(int n) {
            return this.rootParent()._getShort(this.idx(n));
        }

        @Override
        protected short _getShortLE(int n) {
            return this.rootParent()._getShortLE(this.idx(n));
        }

        @Override
        protected int _getUnsignedMedium(int n) {
            return this.rootParent()._getUnsignedMedium(this.idx(n));
        }

        @Override
        protected int _getUnsignedMediumLE(int n) {
            return this.rootParent()._getUnsignedMediumLE(this.idx(n));
        }

        @Override
        protected int _getInt(int n) {
            return this.rootParent()._getInt(this.idx(n));
        }

        @Override
        protected int _getIntLE(int n) {
            return this.rootParent()._getIntLE(this.idx(n));
        }

        @Override
        protected long _getLong(int n) {
            return this.rootParent()._getLong(this.idx(n));
        }

        @Override
        protected long _getLongLE(int n) {
            return this.rootParent()._getLongLE(this.idx(n));
        }

        @Override
        public ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
            this.checkIndex(n, n3);
            this.rootParent().getBytes(this.idx(n), byteBuf, n2, n3);
            return this;
        }

        @Override
        public ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
            this.checkIndex(n, n3);
            this.rootParent().getBytes(this.idx(n), byArray, n2, n3);
            return this;
        }

        @Override
        public ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
            this.checkIndex(n, byteBuffer.remaining());
            this.rootParent().getBytes(this.idx(n), byteBuffer);
            return this;
        }

        @Override
        protected void _setByte(int n, int n2) {
            this.rootParent()._setByte(this.idx(n), n2);
        }

        @Override
        protected void _setShort(int n, int n2) {
            this.rootParent()._setShort(this.idx(n), n2);
        }

        @Override
        protected void _setShortLE(int n, int n2) {
            this.rootParent()._setShortLE(this.idx(n), n2);
        }

        @Override
        protected void _setMedium(int n, int n2) {
            this.rootParent()._setMedium(this.idx(n), n2);
        }

        @Override
        protected void _setMediumLE(int n, int n2) {
            this.rootParent()._setMediumLE(this.idx(n), n2);
        }

        @Override
        protected void _setInt(int n, int n2) {
            this.rootParent()._setInt(this.idx(n), n2);
        }

        @Override
        protected void _setIntLE(int n, int n2) {
            this.rootParent()._setIntLE(this.idx(n), n2);
        }

        @Override
        protected void _setLong(int n, long l) {
            this.rootParent()._setLong(this.idx(n), l);
        }

        @Override
        protected void _setLongLE(int n, long l) {
            this.rootParent().setLongLE(this.idx(n), l);
        }

        @Override
        public ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
            this.checkIndex(n, n3);
            this.rootParent().setBytes(this.idx(n), byArray, n2, n3);
            return this;
        }

        @Override
        public ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
            this.checkIndex(n, n3);
            this.rootParent().setBytes(this.idx(n), byteBuf, n2, n3);
            return this;
        }

        @Override
        public ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
            this.checkIndex(n, byteBuffer.remaining());
            this.rootParent().setBytes(this.idx(n), byteBuffer);
            return this;
        }

        @Override
        public ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
            this.checkIndex(n, n2);
            if (n2 != 0) {
                ByteBufUtil.readBytes(this.alloc(), this.internalNioBuffer().duplicate(), n, n2, outputStream);
            }
            return this;
        }

        @Override
        public int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
            return gatheringByteChannel.write(this.internalNioBuffer(n, n2).duplicate());
        }

        @Override
        public int getBytes(int n, FileChannel fileChannel, long l, int n2) {
            return fileChannel.write(this.internalNioBuffer(n, n2).duplicate(), l);
        }

        @Override
        public int setBytes(int n, InputStream inputStream, int n2) {
            this.checkIndex(n, n2);
            AbstractByteBuf abstractByteBuf = this.rootParent();
            if (abstractByteBuf.hasArray()) {
                return abstractByteBuf.setBytes(this.idx(n), inputStream, n2);
            }
            byte[] byArray = ByteBufUtil.threadLocalTempArray(n2);
            int n3 = inputStream.read(byArray, 0, n2);
            if (n3 <= 0) {
                return n3;
            }
            this.setBytes(n, byArray, 0, n3);
            return n3;
        }

        @Override
        public int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
            try {
                return scatteringByteChannel.read(this.internalNioBuffer(n, n2).duplicate());
            }
            catch (ClosedChannelException closedChannelException) {
                return -1;
            }
        }

        @Override
        public int setBytes(int n, FileChannel fileChannel, long l, int n2) {
            try {
                return fileChannel.read(this.internalNioBuffer(n, n2).duplicate(), l);
            }
            catch (ClosedChannelException closedChannelException) {
                return -1;
            }
        }

        @Override
        public int forEachByte(int n, int n2, ByteProcessor byteProcessor) {
            this.checkIndex(n, n2);
            int n3 = this.rootParent().forEachByte(this.idx(n), n2, byteProcessor);
            return this.forEachResult(n3);
        }

        @Override
        public int forEachByteDesc(int n, int n2, ByteProcessor byteProcessor) {
            this.checkIndex(n, n2);
            int n3 = this.rootParent().forEachByteDesc(this.idx(n), n2, byteProcessor);
            return this.forEachResult(n3);
        }

        private int forEachResult(int n) {
            if (n < this.adjustment) {
                return -1;
            }
            return n - this.adjustment;
        }

        @Override
        public boolean isContiguous() {
            return this.rootParent().isContiguous();
        }

        private int idx(int n) {
            return n + this.adjustment;
        }

        @Override
        protected void deallocate() {
            if (this.chunk != null) {
                this.chunk.release();
            }
            this.tmpNioBuf = null;
            this.chunk = null;
            this.rootParent = null;
            if (this.handle instanceof Recycler.EnhancedHandle) {
                Recycler.EnhancedHandle enhancedHandle = (Recycler.EnhancedHandle)this.handle;
                enhancedHandle.unguardedRecycle((Object)this);
            } else {
                this.handle.recycle((Object)this);
            }
        }
    }

    private static final class Chunk
    implements ReferenceCounted {
        private final AbstractByteBuf delegate;
        private Magazine magazine;
        private final AdaptivePoolingAllocator allocator;
        private final int capacity;
        private final boolean pooled;
        private int allocatedBytes;
        private static final long REFCNT_FIELD_OFFSET = ReferenceCountUpdater.getUnsafeOffset(Chunk.class, (String)"refCnt");
        private static final AtomicIntegerFieldUpdater<Chunk> AIF_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Chunk.class, "refCnt");
        private static final ReferenceCountUpdater<Chunk> updater = new ReferenceCountUpdater<Chunk>(){

            protected AtomicIntegerFieldUpdater<Chunk> updater() {
                return AIF_UPDATER;
            }

            protected long unsafeOffset() {
                return REFCNT_FIELD_OFFSET;
            }
        };
        private volatile int refCnt;

        Chunk() {
            this.delegate = null;
            this.magazine = null;
            this.allocator = null;
            this.capacity = 0;
            this.pooled = false;
        }

        Chunk(AbstractByteBuf abstractByteBuf, Magazine magazine, boolean bl) {
            this.delegate = abstractByteBuf;
            this.pooled = bl;
            this.capacity = abstractByteBuf.capacity();
            updater.setInitialValue((ReferenceCounted)this);
            this.allocator = magazine.parent;
            this.attachToMagazine(magazine);
        }

        Magazine currentMagazine() {
            return this.magazine;
        }

        void detachFromMagazine() {
            if (this.magazine != null) {
                this.magazine.usedMemory.getAndAdd(-this.capacity);
                this.magazine = null;
            }
        }

        void attachToMagazine(Magazine magazine) {
            assert (this.magazine == null);
            this.magazine = magazine;
            magazine.usedMemory.getAndAdd(this.capacity);
        }

        public Chunk touch(Object object) {
            return this;
        }

        public int refCnt() {
            return updater.refCnt((ReferenceCounted)this);
        }

        public Chunk retain() {
            return (Chunk)updater.retain((ReferenceCounted)this);
        }

        public Chunk retain(int n) {
            return (Chunk)updater.retain((ReferenceCounted)this, n);
        }

        public Chunk touch() {
            return this;
        }

        public boolean release() {
            if (updater.release((ReferenceCounted)this)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        public boolean release(int n) {
            if (updater.release((ReferenceCounted)this, n)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        private void deallocate() {
            Magazine magazine = this.magazine;
            AdaptivePoolingAllocator adaptivePoolingAllocator = magazine.parent;
            int n = magazine.preferredChunkSize();
            int n2 = this.delegate.capacity();
            if (!this.pooled || Chunk.shouldReleaseSuboptimalChunkSuze(n2, n)) {
                this.detachFromMagazine();
                this.delegate.release();
            } else {
                updater.resetRefCnt((ReferenceCounted)this);
                this.delegate.setIndex(0, 0);
                this.allocatedBytes = 0;
                if (!magazine.trySetNextInLine(this)) {
                    this.detachFromMagazine();
                    if (!adaptivePoolingAllocator.offerToQueue(this)) {
                        boolean bl = updater.release((ReferenceCounted)this);
                        this.delegate.release();
                        assert (bl);
                    }
                }
            }
        }

        private static boolean shouldReleaseSuboptimalChunkSuze(int n, int n2) {
            int n3 = n / 131072;
            int n4 = n2 / 131072;
            int n5 = Math.abs(n3 - n4);
            return n5 != 0 && PlatformDependent.threadLocalRandom().nextDouble() * 200.0 > (double)n5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readInitInto(AdaptiveByteBuf adaptiveByteBuf, int n, int n2) {
            int n3 = this.allocatedBytes;
            this.allocatedBytes = n3 + n;
            Chunk chunk = this;
            chunk.retain();
            try {
                adaptiveByteBuf.init(this.delegate, chunk, 0, 0, n3, n, n2);
                chunk = null;
            }
            finally {
                if (chunk != null) {
                    this.allocatedBytes = n3;
                    chunk.release();
                }
            }
        }

        public int remainingCapacity() {
            return this.capacity - this.allocatedBytes;
        }

        public int capacity() {
            return this.capacity;
        }
    }

    private static final class Magazine
    extends AllocationStatistics {
        private static final AtomicReferenceFieldUpdater<Magazine, Chunk> NEXT_IN_LINE = AtomicReferenceFieldUpdater.newUpdater(Magazine.class, Chunk.class, "nextInLine");
        private static final Chunk MAGAZINE_FREED = new Chunk();
        private static final ObjectPool<AdaptiveByteBuf> EVENT_LOOP_LOCAL_BUFFER_POOL = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<AdaptiveByteBuf>(){

            public AdaptiveByteBuf newObject(ObjectPool.Handle<AdaptiveByteBuf> handle) {
                return new AdaptiveByteBuf(handle);
            }
        });
        private Chunk current;
        private volatile Chunk nextInLine;
        private final AtomicLong usedMemory;
        private final StampedLock allocationLock;
        private final Queue<AdaptiveByteBuf> bufferQueue;
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;

        Magazine(AdaptivePoolingAllocator adaptivePoolingAllocator) {
            this(adaptivePoolingAllocator, true);
        }

        Magazine(AdaptivePoolingAllocator adaptivePoolingAllocator, boolean bl) {
            super(adaptivePoolingAllocator, bl);
            if (bl) {
                this.allocationLock = new StampedLock();
                this.bufferQueue = PlatformDependent.newFixedMpmcQueue((int)MAGAZINE_BUFFER_QUEUE_CAPACITY);
                this.handle = new ObjectPool.Handle<AdaptiveByteBuf>(){

                    public void recycle(AdaptiveByteBuf adaptiveByteBuf) {
                        Magazine.this.bufferQueue.offer(adaptiveByteBuf);
                    }
                };
            } else {
                this.allocationLock = null;
                this.bufferQueue = null;
                this.handle = null;
            }
            this.usedMemory = new AtomicLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryAllocate(int n, int n2, int n3, AdaptiveByteBuf adaptiveByteBuf) {
            if (this.allocationLock == null) {
                return this.allocate(n, n2, n3, adaptiveByteBuf);
            }
            long l = this.allocationLock.tryWriteLock();
            if (l != 0L) {
                try {
                    boolean bl = this.allocate(n, n2, n3, adaptiveByteBuf);
                    return bl;
                }
                finally {
                    this.allocationLock.unlockWrite(l);
                }
            }
            return this.allocateWithoutLock(n, n3, adaptiveByteBuf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allocateWithoutLock(int n, int n2, AdaptiveByteBuf adaptiveByteBuf) {
            Chunk chunk = NEXT_IN_LINE.getAndSet(this, null);
            if (chunk == MAGAZINE_FREED) {
                this.restoreMagazineFreed();
                return false;
            }
            if (chunk == null) {
                chunk = (Chunk)this.parent.centralQueue.poll();
                if (chunk == null) {
                    return false;
                }
                chunk.attachToMagazine(this);
            }
            if (chunk.remainingCapacity() >= n) {
                chunk.readInitInto(adaptiveByteBuf, n, n2);
            }
            try {
                if (chunk.remainingCapacity() >= 4096) {
                    this.transferToNextInLineOrRelease(chunk);
                    chunk = null;
                }
            }
            finally {
                if (chunk != null) {
                    chunk.release();
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allocate(int n, int n2, int n3, AdaptiveByteBuf adaptiveByteBuf) {
            this.recordAllocationSize(n2);
            Chunk chunk = this.current;
            if (chunk != null) {
                if (chunk.remainingCapacity() > n) {
                    chunk.readInitInto(adaptiveByteBuf, n, n3);
                    return true;
                }
                this.current = null;
                if (chunk.remainingCapacity() == n) {
                    try {
                        chunk.readInitInto(adaptiveByteBuf, n, n3);
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        chunk.release();
                    }
                }
                if (chunk.remainingCapacity() < 4096) {
                    chunk.release();
                } else {
                    this.transferToNextInLineOrRelease(chunk);
                }
            }
            assert (this.current == null);
            chunk = NEXT_IN_LINE.getAndSet(this, null);
            if (chunk != null) {
                if (chunk == MAGAZINE_FREED) {
                    this.restoreMagazineFreed();
                    return false;
                }
                if (chunk.remainingCapacity() > n) {
                    chunk.readInitInto(adaptiveByteBuf, n, n3);
                    this.current = chunk;
                    return true;
                }
                if (chunk.remainingCapacity() == n) {
                    try {
                        chunk.readInitInto(adaptiveByteBuf, n, n3);
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        chunk.release();
                    }
                }
                chunk.release();
            }
            if ((chunk = (Chunk)this.parent.centralQueue.poll()) == null) {
                chunk = this.newChunkAllocation(n);
            } else {
                chunk.attachToMagazine(this);
                if (chunk.remainingCapacity() < n) {
                    if (chunk.remainingCapacity() < 4096) {
                        chunk.release();
                    } else {
                        this.transferToNextInLineOrRelease(chunk);
                    }
                    chunk = this.newChunkAllocation(n);
                }
            }
            this.current = chunk;
            try {
                assert (this.current.remainingCapacity() >= n);
                if (chunk.remainingCapacity() > n) {
                    chunk.readInitInto(adaptiveByteBuf, n, n3);
                    chunk = null;
                } else {
                    chunk.readInitInto(adaptiveByteBuf, n, n3);
                }
            }
            finally {
                if (chunk != null) {
                    chunk.release();
                    this.current = null;
                }
            }
            return true;
        }

        private void restoreMagazineFreed() {
            Chunk chunk = NEXT_IN_LINE.getAndSet(this, MAGAZINE_FREED);
            if (chunk != null && chunk != MAGAZINE_FREED) {
                chunk.release();
            }
        }

        private void transferToNextInLineOrRelease(Chunk chunk) {
            if (NEXT_IN_LINE.compareAndSet(this, null, chunk)) {
                return;
            }
            Chunk chunk2 = NEXT_IN_LINE.get(this);
            if (chunk2 != null && chunk2 != MAGAZINE_FREED && chunk.remainingCapacity() > chunk2.remainingCapacity() && NEXT_IN_LINE.compareAndSet(this, chunk2, chunk)) {
                chunk2.release();
                return;
            }
            chunk.release();
        }

        private Chunk newChunkAllocation(int n) {
            int n2 = Math.max(n * 10, this.preferredChunkSize());
            int n3 = n2 / 131072;
            if (131072 * n3 < n2) {
                n2 = 131072 * (1 + n3);
            }
            ChunkAllocator chunkAllocator = this.parent.chunkAllocator;
            return new Chunk(chunkAllocator.allocate(n2, n2), this, true);
        }

        boolean trySetNextInLine(Chunk chunk) {
            return NEXT_IN_LINE.compareAndSet(this, null, chunk);
        }

        void free() {
            this.restoreMagazineFreed();
            long l = this.allocationLock.writeLock();
            try {
                if (this.current != null) {
                    this.current.release();
                    this.current = null;
                }
            }
            finally {
                this.allocationLock.unlockWrite(l);
            }
        }

        public AdaptiveByteBuf newBuffer() {
            AdaptiveByteBuf adaptiveByteBuf;
            if (this.handle == null) {
                adaptiveByteBuf = (AdaptiveByteBuf)EVENT_LOOP_LOCAL_BUFFER_POOL.get();
            } else {
                adaptiveByteBuf = this.bufferQueue.poll();
                if (adaptiveByteBuf == null) {
                    adaptiveByteBuf = new AdaptiveByteBuf(this.handle);
                }
            }
            adaptiveByteBuf.resetRefCnt();
            adaptiveByteBuf.discardMarks();
            return adaptiveByteBuf;
        }
    }

    private static class AllocationStatistics {
        private static final int MIN_DATUM_TARGET = 1024;
        private static final int MAX_DATUM_TARGET = 65534;
        private static final int INIT_DATUM_TARGET = 9;
        private static final int HISTO_MIN_BUCKET_SHIFT = 13;
        private static final int HISTO_MAX_BUCKET_SHIFT = 20;
        private static final int HISTO_BUCKET_COUNT = 8;
        private static final int HISTO_MAX_BUCKET_MASK = 7;
        private static final int SIZE_MAX_MASK = 0x9FFFFF;
        protected final AdaptivePoolingAllocator parent;
        private final boolean shareable;
        private final short[][] histos = new short[][]{new short[8], new short[8], new short[8], new short[8]};
        private short[] histo = this.histos[0];
        private final int[] sums = new int[8];
        private int histoIndex;
        private int datumCount;
        private int datumTarget = 9;
        protected volatile int sharedPrefChunkSize = 131072;
        protected volatile int localPrefChunkSize = 131072;

        private AllocationStatistics(AdaptivePoolingAllocator adaptivePoolingAllocator, boolean bl) {
            this.parent = adaptivePoolingAllocator;
            this.shareable = bl;
        }

        protected void recordAllocationSize(int n) {
            int n2 = n;
            this.histo[n2] = (short)(this.histo[n2] + 1);
            if (this.datumCount++ == this.datumTarget) {
                this.rotateHistograms();
            }
        }

        static int sizeBucket(int n) {
            if (n == 0) {
                return 0;
            }
            int n2 = n - 1 >> 13 & 0x9FFFFF;
            return Math.min(32 - Integer.numberOfLeadingZeros(n2), 7);
        }

        private void rotateHistograms() {
            int n;
            int n2;
            int n3;
            short[][] sArray = this.histos;
            for (n3 = 0; n3 < 8; ++n3) {
                this.sums[n3] = (sArray[0][n3] & 0xFFFF) + (sArray[1][n3] & 0xFFFF) + (sArray[2][n3] & 0xFFFF) + (sArray[3][n3] & 0xFFFF);
            }
            n3 = 0;
            int[] nArray = this.sums;
            int n4 = nArray.length;
            for (n2 = 0; n2 < n4; ++n2) {
                n = nArray[n2];
                n3 += n;
            }
            int n5 = (int)((double)n3 * 0.99);
            for (n4 = 0; n4 < this.sums.length && this.sums[n4] <= n5; n5 -= this.sums[n4], ++n4) {
            }
            n2 = 1 << n4 + 13;
            this.localPrefChunkSize = n = Math.max(n2 * 10, 131072);
            if (this.shareable) {
                for (Magazine magazine : this.parent.magazines) {
                    n = Math.max(n, magazine.localPrefChunkSize);
                }
            }
            if (this.sharedPrefChunkSize != n) {
                this.datumTarget = Math.max(this.datumTarget >> 1, 1024);
                this.sharedPrefChunkSize = n;
            } else {
                this.datumTarget = Math.min(this.datumTarget << 1, 65534);
            }
            this.histoIndex = this.histoIndex + 1 & 3;
            this.histo = this.histos[this.histoIndex];
            this.datumCount = 0;
            Arrays.fill(this.histo, (short)0);
        }

        protected int preferredChunkSize() {
            return this.sharedPrefChunkSize;
        }
    }

    static enum MagazineCaching {
        EventLoopThreads,
        FastThreadLocalThreads,
        None;

    }
}

