/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.pool;

import io.ktor.utils.io.pool.ObjectPool;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0004\b\f\u0010\u0007J\u0015\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\r\u0010\u000bJ\r\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u0005R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lio/ktor/utils/io/pool/SingleInstancePool;", "", "T", "Lio/ktor/utils/io/pool/ObjectPool;", "<init>", "()V", "produceInstance", "()Ljava/lang/Object;", "instance", "", "disposeInstance", "(Ljava/lang/Object;)V", "borrow", "recycle", "dispose", "", "getCapacity", "()I", "capacity", "ktor-io"})
public abstract class SingleInstancePool<T>
implements ObjectPool<T> {
    private volatile /* synthetic */ int borrowed;
    private static final /* synthetic */ AtomicIntegerFieldUpdater borrowed$FU;
    private volatile /* synthetic */ int disposed;
    private static final /* synthetic */ AtomicIntegerFieldUpdater disposed$FU;
    private volatile /* synthetic */ Object instance;

    public SingleInstancePool() {
        this.borrowed = 0;
        this.disposed = 0;
        this.instance = null;
    }

    protected abstract T produceInstance();

    protected abstract void disposeInstance(T var1);

    @Override
    public final int getCapacity() {
        return 1;
    }

    @Override
    public final T borrow() {
        int n2;
        int n3;
        SingleInstancePool<T> singleInstancePool = this;
        boolean bl = false;
        do {
            n2 = n3 = singleInstancePool.borrowed;
            boolean bl2 = false;
            if (n2 == 0) continue;
            throw new IllegalStateException("Instance is already consumed".toString());
        } while (!borrowed$FU.compareAndSet(singleInstancePool, n3, n2 = 1));
        singleInstancePool = this.produceInstance();
        this.instance = singleInstancePool;
        return (T)singleInstancePool;
    }

    @Override
    public final void recycle(T t2) {
        Intrinsics.checkNotNullParameter(t2, (String)"");
        if (this.instance != t2) {
            if (this.instance == null && this.borrowed != 0) {
                throw new IllegalStateException("Already recycled or an irrelevant instance tried to be recycled".toString());
            }
            throw new IllegalStateException("Unable to recycle irrelevant instance".toString());
        }
        this.instance = null;
        if (!disposed$FU.compareAndSet(this, 0, 1)) {
            throw new IllegalStateException("An instance is already disposed".toString());
        }
        this.disposeInstance(t2);
    }

    @Override
    public final void dispose() {
        if (disposed$FU.compareAndSet(this, 0, 1)) {
            Object object = this.instance;
            if (object == null) {
                return;
            }
            Object object2 = object;
            this.instance = null;
            this.disposeInstance(object2);
        }
    }

    static {
        borrowed$FU = AtomicIntegerFieldUpdater.newUpdater(SingleInstancePool.class, "borrowed");
        disposed$FU = AtomicIntegerFieldUpdater.newUpdater(SingleInstancePool.class, "disposed");
    }
}

