/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.CvPoint;
import org.bytedeco.opencv.opencv_core.CvPoint2D32f;
import org.bytedeco.opencv.opencv_core.CvPoint2D64f;
import org.bytedeco.opencv.presets.opencv_core;

@Properties(inherit={opencv_core.class})
public abstract class AbstractCvPoint
extends IntPointer {
    public static final CvPoint ZERO;

    public AbstractCvPoint(Pointer pointer) {
        super(pointer);
    }

    public abstract int x();

    public abstract CvPoint x(int var1);

    public abstract int y();

    public abstract CvPoint y(int var1);

    public CvPoint get(int[] nArray) {
        return this.get(nArray, 0, nArray.length);
    }

    public CvPoint get(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2 / 2; ++i) {
            this.position(i);
            nArray[n + i * 2] = this.x();
            nArray[n + i * 2 + 1] = this.y();
        }
        return (CvPoint)this.position(0L);
    }

    public final CvPoint put(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2 / 2; ++i) {
            this.position(i);
            this.put(nArray[n + i * 2], nArray[n + i * 2 + 1]);
        }
        return (CvPoint)this.position(0L);
    }

    public final CvPoint put(int ... nArray) {
        return this.put(nArray, 0, nArray.length);
    }

    public final CvPoint put(byte by, double[] dArray, int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = (int)Math.round(dArray[n + i] * (double)(1 << by));
        }
        return this.put(nArray, 0, n2);
    }

    public final CvPoint put(byte by, double ... dArray) {
        return this.put(by, dArray, 0, dArray.length);
    }

    public CvPoint put(int n, int n2) {
        return this.x(n).y(n2);
    }

    public CvPoint put(CvPoint cvPoint) {
        return this.x(cvPoint.x()).y(cvPoint.y());
    }

    public CvPoint put(byte by, CvPoint2D32f cvPoint2D32f) {
        this.x(Math.round(cvPoint2D32f.x() * (float)(1 << by)));
        this.y(Math.round(cvPoint2D32f.y() * (float)(1 << by)));
        return (CvPoint)this;
    }

    public CvPoint put(byte by, CvPoint2D64f cvPoint2D64f) {
        this.x((int)Math.round(cvPoint2D64f.x() * (double)(1 << by)));
        this.y((int)Math.round(cvPoint2D64f.y() * (double)(1 << by)));
        return (CvPoint)this;
    }

    public String toString() {
        if (this.isNull()) {
            return super.toString();
        }
        if (this.capacity() == 0L) {
            return "(" + this.x() + ", " + this.y() + ")";
        }
        String string = "";
        long l = this.position();
        for (long i = 0L; i < this.capacity(); ++i) {
            this.position(i);
            string = string + (i == 0L ? "(" : " (") + this.x() + ", " + this.y() + ")";
        }
        this.position(l);
        return string;
    }

    static {
        Loader.load();
        ZERO = (CvPoint)new CvPoint().x(0).y(0).retainReference();
    }
}

