/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Rect2d;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::Rect2d>"})
@Properties(inherit={opencv_core.class})
public class Rect2dVector
extends Pointer {
    public Rect2dVector(Pointer pointer) {
        super(pointer);
    }

    public Rect2dVector(Rect2d rect2d) {
        this(1L);
        this.put(0L, rect2d);
    }

    public Rect2dVector(Rect2d ... rect2dArray) {
        this(rect2dArray.length);
        this.put(rect2dArray);
    }

    public Rect2dVector() {
        this.allocate();
    }

    public Rect2dVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Rect2dVector put(@ByRef Rect2dVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Rect2d front() {
        return this.get(0L);
    }

    public Rect2d back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native Rect2d get(@Cast(value={"size_t"}) long var1);

    public native Rect2dVector put(@Cast(value={"size_t"}) long var1, Rect2d var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Rect2d var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Rect2d[] get() {
        Rect2d[] rect2dArray = new Rect2d[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < rect2dArray.length; ++i) {
            rect2dArray[i] = this.get(i);
        }
        return rect2dArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Rect2d pop_back() {
        long l = this.size();
        Rect2d rect2d = this.get(l - 1L);
        this.resize(l - 1L);
        return rect2d;
    }

    public Rect2dVector push_back(Rect2d rect2d) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, rect2d);
    }

    public Rect2dVector put(Rect2d rect2d) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, rect2d);
    }

    public Rect2dVector put(Rect2d ... rect2dArray) {
        if (this.size() != (long)rect2dArray.length) {
            this.resize(rect2dArray.length);
        }
        for (int i = 0; i < rect2dArray.length; ++i) {
            this.put(i, rect2dArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Rect2d get();
    }
}

