/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_imgproc;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Scalar4f;
import org.bytedeco.opencv.presets.opencv_imgproc;

@Name(value={"std::vector<cv::Vec4f>"})
@Properties(inherit={opencv_imgproc.class})
public class Vec4fVector
extends Pointer {
    public Vec4fVector(Pointer pointer) {
        super(pointer);
    }

    public Vec4fVector(Scalar4f scalar4f) {
        this(1L);
        this.put(0L, scalar4f);
    }

    public Vec4fVector(Scalar4f ... scalar4fArray) {
        this(scalar4fArray.length);
        this.put(scalar4fArray);
    }

    public Vec4fVector() {
        this.allocate();
    }

    public Vec4fVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Vec4fVector put(@ByRef Vec4fVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Scalar4f front() {
        return this.get(0L);
    }

    public Scalar4f back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @Cast(value={"cv::Vec4f*"})
    @ByRef
    public native Scalar4f get(@Cast(value={"size_t"}) long var1);

    public native Vec4fVector put(@Cast(value={"size_t"}) long var1, Scalar4f var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @Cast(value={"cv::Vec4f*"}) @ByRef Scalar4f var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Scalar4f[] get() {
        Scalar4f[] scalar4fArray = new Scalar4f[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < scalar4fArray.length; ++i) {
            scalar4fArray[i] = this.get(i);
        }
        return scalar4fArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Scalar4f pop_back() {
        long l = this.size();
        Scalar4f scalar4f = this.get(l - 1L);
        this.resize(l - 1L);
        return scalar4f;
    }

    public Vec4fVector push_back(Scalar4f scalar4f) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, scalar4f);
    }

    public Vec4fVector put(Scalar4f scalar4f) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, scalar4f);
    }

    public Vec4fVector put(Scalar4f ... scalar4fArray) {
        if (this.size() != (long)scalar4fArray.length) {
            this.resize(scalar4fArray.length);
        }
        for (int i = 0; i < scalar4fArray.length; ++i) {
            this.put(i, scalar4fArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Cast(value={"cv::Vec4f*"})
        @ByRef
        @Const
        public native Scalar4f get();
    }
}

