/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.namespace.QName;
import org.e.a.a;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class RosterPacket
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:roster";
    private final List<Item> rosterItems = new ArrayList<Item>();
    private String rosterVersion;

    public RosterPacket() {
        super(ELEMENT, NAMESPACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterItem(Item item) {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            this.rosterItems.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRosterItemCount() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return this.rosterItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Item> getRosterItems() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return new ArrayList<Item>(this.rosterItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        iQChildElementXmlStringBuilder.optAttribute("ver", this.rosterVersion);
        iQChildElementXmlStringBuilder.rightAngleBracket();
        List<Item> list = this.rosterItems;
        synchronized (list) {
            for (Item item : this.rosterItems) {
                iQChildElementXmlStringBuilder.append(item.toXML());
            }
        }
        return iQChildElementXmlStringBuilder;
    }

    public String getVersion() {
        return this.rosterVersion;
    }

    public void setVersion(String string) {
        this.rosterVersion = string;
    }

    public static enum ItemType {
        none('\u22a5'),
        to('\u2190'),
        from('\u2192'),
        both('\u2194'),
        remove('\u26a1');

        private static final char ME = '\u25cf';
        private final String symbol;

        private ItemType(char c2) {
            StringBuilder stringBuilder = new StringBuilder(2);
            stringBuilder.append('\u25cf').append(c2);
            this.symbol = stringBuilder.toString();
        }

        public static ItemType fromString(String string) {
            if (StringUtils.isNullOrEmpty((CharSequence)string)) {
                return none;
            }
            return ItemType.valueOf(string.toLowerCase(Locale.US));
        }

        public String asSymbol() {
            return this.symbol;
        }
    }

    public static final class Item
    implements ExtensionElement {
        public static final String ELEMENT = "item";
        public static final QName QNAME = new QName("jabber:iq:roster", "item");
        public static final String GROUP = "group";
        private final a jid;
        private boolean subscriptionPending;
        private String name;
        private ItemType itemType = ItemType.none;
        private boolean approved;
        private final Set<String> groupNames;

        public Item(a a2, String string) {
            this(a2, string, false);
        }

        public Item(a a2, String string, boolean bl) {
            this.jid = (a)Objects.requireNonNull((Object)a2);
            this.name = string;
            this.subscriptionPending = bl;
            this.groupNames = new CopyOnWriteArraySet<String>();
        }

        public String getElementName() {
            return QNAME.getLocalPart();
        }

        public String getNamespace() {
            return QNAME.getNamespaceURI();
        }

        @Deprecated
        public String getUser() {
            return this.jid.toString();
        }

        public a getJid() {
            return this.jid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public ItemType getItemType() {
            return this.itemType;
        }

        public void setItemType(ItemType itemType) {
            this.itemType = (ItemType)((Object)Objects.requireNonNull((Object)((Object)itemType), (String)"itemType must not be null"));
        }

        public void setSubscriptionPending(boolean bl) {
            this.subscriptionPending = bl;
        }

        public boolean isSubscriptionPending() {
            return this.subscriptionPending;
        }

        public boolean isApproved() {
            return this.approved;
        }

        public void setApproved(boolean bl) {
            this.approved = bl;
        }

        public Set<String> getGroupNames() {
            return Collections.unmodifiableSet(this.groupNames);
        }

        public void addGroupName(String string) {
            this.groupNames.add(string);
        }

        public void removeGroupName(String string) {
            this.groupNames.remove(string);
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlStringBuilder.attribute("jid", (CharSequence)this.jid);
            xmlStringBuilder.optAttribute("name", this.name);
            xmlStringBuilder.optAttribute("subscription", (Enum)this.itemType);
            if (this.subscriptionPending) {
                xmlStringBuilder.append((CharSequence)" ask='subscribe'");
            }
            xmlStringBuilder.optBooleanAttribute("approved", this.approved);
            xmlStringBuilder.rightAngleBracket();
            for (String string : this.groupNames) {
                xmlStringBuilder.openElement(GROUP).escape(string).closeElement(GROUP);
            }
            xmlStringBuilder.closeElement((NamedElement)this);
            return xmlStringBuilder;
        }

        public int hashCode() {
            return HashCode.builder().append(this.groupNames).append(this.subscriptionPending).append((Object)this.itemType).append((Object)this.name).append((Object)this.jid).append(this.approved).build();
        }

        public boolean equals(Object object) {
            return EqualsUtil.equals((Object)this, (Object)object, (builder, item) -> builder.append(this.groupNames, item.groupNames).append(this.subscriptionPending, item.subscriptionPending).append((Object)this.itemType, (Object)item.itemType).append((Object)this.name, (Object)item.name).append((Object)this.jid, (Object)item.jid).append(this.approved, item.approved));
        }
    }
}

