/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.core.CoreResultSet;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;
import org.sqlite.date.FastDateFormat;

public abstract class JDBC3ResultSet
extends CoreResultSet {
    protected static final Pattern COLUMN_TYPENAME = Pattern.compile("([^\\(]*)");
    protected static final Pattern COLUMN_TYPECAST = Pattern.compile("cast\\(.*?\\s+as\\s+(.*?)\\s*\\)");
    protected static final Pattern COLUMN_PRECISION = Pattern.compile(".*?\\((.*?)\\)");

    protected JDBC3ResultSet(CoreStatement coreStatement) {
        super(coreStatement);
    }

    public int findColumn(String string) {
        this.checkOpen();
        Integer n = this.findColumnIndexInCache(string);
        if (n != null) {
            return n;
        }
        for (int i = 0; i < this.cols.length; ++i) {
            if (!string.equalsIgnoreCase(this.cols[i])) continue;
            return this.addColumnIndexInCache(string, i + 1);
        }
        throw new SQLException("no such column: '" + string + "'");
    }

    public boolean next() {
        if (!this.open || this.emptyResultSet || this.pastLastRow) {
            return false;
        }
        this.lastCol = -1;
        if (this.row == 0) {
            ++this.row;
            return true;
        }
        if (this.maxRows != 0L && (long)this.row == this.maxRows) {
            return false;
        }
        int n = this.stmt.pointer.safeRunInt(DB::step);
        switch (n) {
            case 101: {
                this.pastLastRow = true;
                return false;
            }
            case 100: {
                ++this.row;
                return true;
            }
        }
        this.getDatabase().throwex(n);
        return false;
    }

    public int getType() {
        return 1003;
    }

    public int getFetchSize() {
        return this.limitRows;
    }

    public void setFetchSize(int n) {
        if (0 > n || this.maxRows != 0L && (long)n > this.maxRows) {
            throw new SQLException("fetch size " + n + " out of bounds " + this.maxRows);
        }
        this.limitRows = n;
    }

    public int getFetchDirection() {
        this.checkOpen();
        return 1000;
    }

    public void setFetchDirection(int n) {
        this.checkOpen();
        if (n != 1000) {
            throw new SQLException("only FETCH_FORWARD direction supported");
        }
    }

    public boolean isAfterLast() {
        return this.pastLastRow && !this.emptyResultSet;
    }

    public boolean isBeforeFirst() {
        return !this.emptyResultSet && this.open && this.row == 0;
    }

    public boolean isFirst() {
        return this.row == 1;
    }

    public boolean isLast() {
        throw new SQLFeatureNotSupportedException("not supported by sqlite");
    }

    public int getRow() {
        return this.row;
    }

    public boolean wasNull() {
        return this.safeGetColumnType(this.markCol(this.lastCol)) == 5;
    }

    public BigDecimal getBigDecimal(int n) {
        switch (this.safeGetColumnType(this.checkCol(n))) {
            case 5: {
                return null;
            }
            case 1: {
                return BigDecimal.valueOf(this.safeGetLongCol(n));
            }
        }
        String string = this.safeGetColumnText(n);
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Bad value for type BigDecimal : " + string);
        }
    }

    public BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean getBoolean(int n) {
        return this.getInt(n) != 0;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(this.findColumn(string));
    }

    public InputStream getBinaryStream(int n) {
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public InputStream getBinaryStream(String string) {
        return this.getBinaryStream(this.findColumn(string));
    }

    public byte getByte(int n) {
        return (byte)this.getInt(n);
    }

    public byte getByte(String string) {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) {
        return this.stmt.pointer.safeRun((dB, l) -> dB.column_blob(l, this.markCol(n)));
    }

    public byte[] getBytes(String string) {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) {
        String string = this.getString(n);
        return string == null ? null : new StringReader(string);
    }

    public Reader getCharacterStream(String string) {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Date getDate(int n) {
        switch (this.safeGetColumnType(this.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    return new Date(this.getConnectionConfig().getDateFormat().parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing date", exception);
                }
            }
            case 2: {
                return new Date(this.julianDateToCalendar(this.safeGetDoubleCol(n)).getTimeInMillis());
            }
        }
        return new Date(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
    }

    public Date getDate(int n, Calendar calendar) {
        this.requireCalendarNotNull(calendar);
        switch (this.safeGetColumnType(this.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    FastDateFormat fastDateFormat = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), calendar.getTimeZone());
                    return new Date(fastDateFormat.parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing time stamp", exception);
                }
            }
            case 2: {
                return new Date(this.julianDateToCalendar(this.safeGetDoubleCol(n), calendar).getTimeInMillis());
            }
        }
        calendar.setTimeInMillis(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
        return new Date(calendar.getTime().getTime());
    }

    public Date getDate(String string) {
        return this.getDate(this.findColumn(string), Calendar.getInstance());
    }

    public Date getDate(String string, Calendar calendar) {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) {
        if (this.safeGetColumnType(this.markCol(n)) == 5) {
            return 0.0;
        }
        return this.safeGetDoubleCol(n);
    }

    public double getDouble(String string) {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n) {
        if (this.safeGetColumnType(this.markCol(n)) == 5) {
            return 0.0f;
        }
        return (float)this.safeGetDoubleCol(n);
    }

    public float getFloat(String string) {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) {
        return this.stmt.pointer.safeRunInt((dB, l) -> dB.column_int(l, this.markCol(n)));
    }

    public int getInt(String string) {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) {
        return this.safeGetLongCol(n);
    }

    public long getLong(String string) {
        return this.getLong(this.findColumn(string));
    }

    public short getShort(int n) {
        return (short)this.getInt(n);
    }

    public short getShort(String string) {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n) {
        return this.safeGetColumnText(n);
    }

    public String getString(String string) {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) {
        switch (this.safeGetColumnType(this.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    return new Time(this.getConnectionConfig().getDateFormat().parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing time", exception);
                }
            }
            case 2: {
                return new Time(this.julianDateToCalendar(this.safeGetDoubleCol(n)).getTimeInMillis());
            }
        }
        return new Time(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
    }

    public Time getTime(int n, Calendar calendar) {
        this.requireCalendarNotNull(calendar);
        switch (this.safeGetColumnType(this.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    FastDateFormat fastDateFormat = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), calendar.getTimeZone());
                    return new Time(fastDateFormat.parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing time", exception);
                }
            }
            case 2: {
                return new Time(this.julianDateToCalendar(this.safeGetDoubleCol(n), calendar).getTimeInMillis());
            }
        }
        calendar.setTimeInMillis(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
        return new Time(calendar.getTime().getTime());
    }

    public Time getTime(String string) {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) {
        switch (this.safeGetColumnType(this.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    return new Timestamp(this.getConnectionConfig().getDateFormat().parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing time stamp", exception);
                }
            }
            case 2: {
                return new Timestamp(this.julianDateToCalendar(this.safeGetDoubleCol(n)).getTimeInMillis());
            }
        }
        return new Timestamp(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
    }

    public Timestamp getTimestamp(int n, Calendar calendar) {
        this.requireCalendarNotNull(calendar);
        switch (this.safeGetColumnType(this.markCol(n))) {
            case 5: {
                return null;
            }
            case 3: {
                String string = this.safeGetColumnText(n);
                if ("".equals(string)) {
                    return null;
                }
                try {
                    FastDateFormat fastDateFormat = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), calendar.getTimeZone());
                    return new Timestamp(fastDateFormat.parse(string).getTime());
                }
                catch (Exception exception) {
                    throw new SQLException("Error parsing time stamp", exception);
                }
            }
            case 2: {
                return new Timestamp(this.julianDateToCalendar(this.safeGetDoubleCol(n)).getTimeInMillis());
            }
        }
        calendar.setTimeInMillis(this.safeGetLongCol(n) * this.getConnectionConfig().getDateMultiplier());
        return new Timestamp(calendar.getTime().getTime());
    }

    public Timestamp getTimestamp(String string) {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public Object getObject(int n) {
        switch (this.safeGetColumnType(this.markCol(n))) {
            case 1: {
                long l = this.getLong(n);
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    return new Long(l);
                }
                return new Integer((int)l);
            }
            case 2: {
                return new Double(this.getDouble(n));
            }
            case 4: {
                return this.getBytes(n);
            }
            case 5: {
                return null;
            }
        }
        return this.getString(n);
    }

    public Object getObject(String string) {
        return this.getObject(this.findColumn(string));
    }

    public Statement getStatement() {
        return (Statement)((Object)this.stmt);
    }

    public String getCursorName() {
        return null;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public ResultSetMetaData getMetaData() {
        return (ResultSetMetaData)((Object)this);
    }

    public String getCatalogName(int n) {
        return this.safeGetColumnTableName(n);
    }

    public String getColumnClassName(int n) {
        switch (this.safeGetColumnType(this.markCol(n))) {
            case 1: {
                long l = this.getLong(n);
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    return "java.lang.Long";
                }
                return "java.lang.Integer";
            }
            case 2: {
                return "java.lang.Double";
            }
            case 4: 
            case 5: {
                return "java.lang.Object";
            }
        }
        return "java.lang.String";
    }

    public int getColumnCount() {
        this.checkCol(1);
        return this.colsMeta.length;
    }

    public int getColumnDisplaySize(int n) {
        return Integer.MAX_VALUE;
    }

    public String getColumnLabel(int n) {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) {
        return this.safeGetColumnName(n);
    }

    public int getColumnType(int n) {
        String string = this.getColumnTypeName(n);
        int n2 = this.safeGetColumnType(this.checkCol(n));
        if (n2 == 1 || n2 == 5) {
            if ("BOOLEAN".equals(string)) {
                return 16;
            }
            if ("TINYINT".equals(string)) {
                return -6;
            }
            if ("SMALLINT".equals(string) || "INT2".equals(string)) {
                return 5;
            }
            if ("BIGINT".equals(string) || "INT8".equals(string) || "UNSIGNED BIG INT".equals(string)) {
                return -5;
            }
            if ("DATE".equals(string) || "DATETIME".equals(string)) {
                return 91;
            }
            if ("TIMESTAMP".equals(string)) {
                return 93;
            }
            if (n2 == 1 || "INT".equals(string) || "INTEGER".equals(string) || "MEDIUMINT".equals(string)) {
                long l = this.getLong(n);
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    return -5;
                }
                return 4;
            }
        }
        if (n2 == 2 || n2 == 5) {
            if ("DECIMAL".equals(string)) {
                return 3;
            }
            if ("DOUBLE".equals(string) || "DOUBLE PRECISION".equals(string)) {
                return 8;
            }
            if ("NUMERIC".equals(string)) {
                return 2;
            }
            if ("REAL".equals(string)) {
                return 7;
            }
            if (n2 == 2 || "FLOAT".equals(string)) {
                return 6;
            }
        }
        if (n2 == 3 || n2 == 5) {
            if ("CHARACTER".equals(string) || "NCHAR".equals(string) || "NATIVE CHARACTER".equals(string) || "CHAR".equals(string)) {
                return 1;
            }
            if ("CLOB".equals(string)) {
                return 2005;
            }
            if ("DATE".equals(string) || "DATETIME".equals(string)) {
                return 91;
            }
            if ("TIMESTAMP".equals(string)) {
                return 93;
            }
            if (n2 == 3 || "VARCHAR".equals(string) || "VARYING CHARACTER".equals(string) || "NVARCHAR".equals(string) || "TEXT".equals(string)) {
                return 12;
            }
        }
        if (n2 == 4 || n2 == 5) {
            if ("BINARY".equals(string)) {
                return -2;
            }
            if (n2 == 4 || "BLOB".equals(string)) {
                return 2004;
            }
        }
        return 2;
    }

    public String getColumnTypeName(int n) {
        String string = this.getColumnDeclType(n);
        if (string != null) {
            Matcher matcher = COLUMN_TYPENAME.matcher(string);
            matcher.find();
            return matcher.group(1).toUpperCase(Locale.ENGLISH);
        }
        switch (this.safeGetColumnType(this.checkCol(n))) {
            case 1: {
                return "INTEGER";
            }
            case 2: {
                return "FLOAT";
            }
            case 4: {
                return "BLOB";
            }
            case 3: {
                return "TEXT";
            }
        }
        return "NUMERIC";
    }

    public int getPrecision(int n) {
        String string = this.getColumnDeclType(n);
        if (string != null) {
            Matcher matcher = COLUMN_PRECISION.matcher(string);
            return matcher.find() ? Integer.parseInt(matcher.group(1).split(",")[0].trim()) : 0;
        }
        return 0;
    }

    private String getColumnDeclType(int n) {
        String string = this.stmt.pointer.safeRun((dB, l) -> dB.column_decltype(l, this.checkCol(n)));
        if (string == null) {
            Matcher matcher = COLUMN_TYPECAST.matcher(this.safeGetColumnName(n));
            string = matcher.find() ? matcher.group(1) : null;
        }
        return string;
    }

    public int getScale(int n) {
        String[] stringArray;
        Matcher matcher;
        String string = this.getColumnDeclType(n);
        if (string != null && (matcher = COLUMN_PRECISION.matcher(string)).find() && (stringArray = matcher.group(1).split(",")).length == 2) {
            return Integer.parseInt(stringArray[1].trim());
        }
        return 0;
    }

    public String getSchemaName(int n) {
        return "";
    }

    public String getTableName(int n) {
        String string = this.safeGetColumnTableName(n);
        if (string == null) {
            return "";
        }
        return string;
    }

    public int isNullable(int n) {
        this.checkMeta();
        return this.meta[this.checkCol(n)][0] ? 0 : 1;
    }

    public boolean isAutoIncrement(int n) {
        this.checkMeta();
        return this.meta[this.checkCol(n)][2];
    }

    public boolean isCaseSensitive(int n) {
        return true;
    }

    public boolean isCurrency(int n) {
        return false;
    }

    public boolean isDefinitelyWritable(int n) {
        return true;
    }

    public boolean isReadOnly(int n) {
        return false;
    }

    public boolean isSearchable(int n) {
        return true;
    }

    public boolean isSigned(int n) {
        String string = this.getColumnTypeName(n);
        return "NUMERIC".equals(string) || "INTEGER".equals(string) || "REAL".equals(string);
    }

    public boolean isWritable(int n) {
        return true;
    }

    public int getConcurrency() {
        return 1007;
    }

    public boolean rowDeleted() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowUpdated() {
        return false;
    }

    private Calendar julianDateToCalendar(Double d) {
        return this.julianDateToCalendar(d, Calendar.getInstance());
    }

    private Calendar julianDateToCalendar(Double d, Calendar calendar) {
        int n;
        int n2;
        if (d == null) {
            return null;
        }
        double d2 = d + 0.5;
        int n3 = (int)d2;
        double d3 = d2 - (double)n3;
        if (n3 < 2299161) {
            n2 = n3;
        } else {
            n = (int)(((double)n3 - 1867216.25) / 36524.25);
            n2 = n3 + 1 + n - (int)((double)n / 4.0);
        }
        n = n2 + 1524;
        int n4 = (int)(((double)n - 122.1) / 365.25);
        int n5 = (int)(365.25 * (double)n4);
        int n6 = (int)((double)(n - n5) / 30.6001);
        int n7 = n6 - ((double)n6 < 13.5 ? 1 : 13);
        int n8 = n4 - ((double)n7 > 2.5 ? 4716 : 4715);
        double d4 = (double)(n - n5 - (int)(30.6001 * (double)n6)) + d3;
        int n9 = (int)d4;
        double d5 = d4 - (double)n9;
        int n10 = (int)(24.0 * d5);
        double d6 = 24.0 * d5 - (double)n10;
        int n11 = (int)(60.0 * d6);
        double d7 = 60.0 * d6 - (double)n11;
        int n12 = (int)(60.0 * d7);
        double d8 = 60.0 * d7 - (double)n12;
        int n13 = (int)(1000.0 * d8);
        calendar.set(n8, n7 - 1, n9, n10, n11, n12);
        calendar.set(14, n13);
        if (n8 < 1) {
            calendar.set(0, 0);
            calendar.set(1, -(n8 - 1));
        }
        return calendar;
    }

    private void requireCalendarNotNull(Calendar calendar) {
        if (calendar == null) {
            throw new SQLException("Expected a calendar instance.", new IllegalArgumentException());
        }
    }

    protected int safeGetColumnType(int n) {
        return this.stmt.pointer.safeRunInt((dB, l) -> dB.column_type(l, n));
    }

    private long safeGetLongCol(int n) {
        return this.stmt.pointer.safeRunLong((dB, l) -> dB.column_long(l, this.markCol(n)));
    }

    private double safeGetDoubleCol(int n) {
        return this.stmt.pointer.safeRunDouble((dB, l) -> dB.column_double(l, this.markCol(n)));
    }

    private String safeGetColumnText(int n) {
        return this.stmt.pointer.safeRun((dB, l) -> dB.column_text(l, this.markCol(n)));
    }

    private String safeGetColumnTableName(int n) {
        return this.stmt.pointer.safeRun((dB, l) -> dB.column_table_name(l, this.checkCol(n)));
    }

    private String safeGetColumnName(int n) {
        return this.stmt.pointer.safeRun((dB, l) -> dB.column_name(l, this.checkCol(n)));
    }
}

