/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 O2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002OPB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\tJ\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u0002H\u0016J\u000e\u0010*\u001a\u00020+2\u0006\u0010\b\u001a\u00020\u0000J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0017J\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0002J\u0016\u0010*\u001a\u00020\u000b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000200H\u0016J\u0010\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020\u0002H\u0002J\b\u00103\u001a\u00020+H\u0016J\u000e\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u0002J\u0011\u00105\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u0002H\u0096\u0002J\u0016\u00106\u001a\u00020\u000b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000200H\u0016J\u000e\u00107\u001a\u00020+2\u0006\u00108\u001a\u00020\u0002J\u0013\u00109\u001a\u00020\u000b2\b\u0010:\u001a\u0004\u0018\u00010;H\u0096\u0002J\u0006\u0010<\u001a\u00020\u0002J\u0018\u0010=\u001a\u0004\u0018\u00010\u00022\u0006\u00102\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0002\u0010>J\b\u0010?\u001a\u00020\u0002H\u0016J\b\u0010@\u001a\u00020\u000bH\u0016J\t\u0010A\u001a\u00020\u0014H\u0096\u0002J\u0010\u0010B\u001a\u00020\u00022\u0006\u00102\u001a\u00020\u0002H\u0002J\u0006\u0010C\u001a\u00020\u000bJ\u0010\u0010D\u001a\u00020\u00022\u0006\u0010E\u001a\u00020\u0002H\u0004J\u0015\u0010F\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010GJ\u0016\u0010H\u001a\u00020\u000b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000200H\u0016J\u0010\u0010I\u001a\u00020+2\u0006\u0010J\u001a\u00020\u0002H\u0002J\u0016\u0010K\u001a\u00020\u000b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000200H\u0016J\u000e\u0010L\u001a\u00020+2\u0006\u00104\u001a\u00020\u0002J\b\u0010M\u001a\u00020NH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u0014\u0010$\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001eR\u000e\u0010&\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Ldorkbox/collections/IntSet;", "", "", "()V", "initialCapacity", "loadFactor", "", "(IF)V", "set", "(Ldorkbox/collections/IntSet;)V", "allocateIterators", "", "getAllocateIterators", "()Z", "setAllocateIterators", "(Z)V", "hasZeroValue", "getHasZeroValue", "setHasZeroValue", "iterator1", "Ldorkbox/collections/IntSet$IntSetIterator;", "iterator2", "keyTable", "", "getKeyTable", "()[I", "setKeyTable", "([I)V", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "size_", "threshold", "add", "element", "addAll", "", "array", "offset", "length", "elements", "", "addResize", "key", "clear", "maximumCapacity", "contains", "containsAll", "ensureCapacity", "additionalCapacity", "equals", "other", "", "first", "get", "(I)Ljava/lang/Integer;", "hashCode", "isEmpty", "iterator", "locateKey", "notEmpty", "place", "item", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "resize", "newSize", "retainAll", "shrink", "toString", "", "Companion", "IntSetIterator", "Collections"})
public final class IntSet
implements Set<Integer>,
KMutableSet {
    public static final Companion Companion = new Companion(null);
    private boolean allocateIterators;
    private int size_;
    private int[] keyTable;
    private boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    private transient IntSetIterator iterator1;
    private transient IntSetIterator iterator2;
    public static final String version = "2.8";

    public final boolean getAllocateIterators() {
        return this.allocateIterators;
    }

    public final void setAllocateIterators(boolean bl) {
        this.allocateIterators = bl;
    }

    public final int[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this.keyTable = nArray;
    }

    public final boolean getHasZeroValue() {
        return this.hasZeroValue;
    }

    public final void setHasZeroValue(boolean bl) {
        this.hasZeroValue = bl;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public IntSet() {
        this(51, 0.8f);
    }

    public IntSet(int n, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + f);
        }
        this.loadFactor = f;
        int n2 = ObjectSet.Companion.tableSize(n, f);
        this.threshold = (int)((float)n2 * f);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[n2];
    }

    public /* synthetic */ IntSet(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public IntSet(IntSet intSet) {
        Intrinsics.checkNotNullParameter((Object)intSet, (String)"");
        this((int)((float)intSet.keyTable.length * intSet.loadFactor), intSet.loadFactor);
        System.arraycopy(intSet.keyTable, 0, this.keyTable, 0, intSet.keyTable.length);
        this.size_ = intSet.size_;
        this.hasZeroValue = intSet.hasZeroValue;
    }

    public int getSize() {
        return this.size_;
    }

    protected final int place(int n) {
        return (int)((long)n * -7046029254386353131L >>> this.shift);
    }

    private final int locateKey(int n) {
        int[] nArray = this.keyTable;
        int n2 = this.place(n);
        int n3;
        while ((n3 = nArray[n2]) != 0) {
            if (n3 == n) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -(n2 + 1);
    }

    public final Integer get(int n) {
        int n2 = this.locateKey(n);
        return n2 < 0 ? null : Integer.valueOf(this.keyTable[n2]);
    }

    @Override
    public boolean add(int n) {
        if (n == 0) {
            if (this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = true;
            int n2 = this.size_;
            this.size_ = n2 + 1;
            return true;
        }
        int n3 = this.locateKey(n);
        if (n3 >= 0) {
            return false;
        }
        n3 = -(n3 + 1);
        this.keyTable[n3] = n;
        ++this.size_;
        if (this.size_ >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        boolean bl = false;
        Iterable iterable = collection;
        boolean bl2 = false;
        for (Object t : iterable) {
            int n = ((Number)t).intValue();
            boolean bl3 = false;
            bl = this.add(n) || bl;
        }
        return bl;
    }

    public final void addAll(int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this.addAll(nArray, 0, nArray.length);
    }

    public final void addAll(int[] nArray, int n, int n2) {
        int n3;
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        if (n + n2 > nArray.length) {
            throw new StateException("offset + length must be <= size: " + n + " + " + n2 + " <= " + nArray.length);
        }
        this.ensureCapacity(n2);
        int n4 = n3 + n2;
        for (n3 = n; n3 < n4; ++n3) {
            this.add(nArray[n3]);
        }
    }

    public final void addAll(IntSet intSet) {
        Intrinsics.checkNotNullParameter((Object)intSet, (String)"");
        this.ensureCapacity(intSet.size_);
        if (intSet.hasZeroValue) {
            this.add(0);
        }
        for (int n : intSet.keyTable) {
            if (n == 0) continue;
            this.add(n);
        }
    }

    private final void addResize(int n) {
        int[] nArray = this.keyTable;
        int n2 = this.place(n);
        while (true) {
            if (nArray[n2] == 0) {
                nArray[n2] = n;
                return;
            }
            n2 = n2 + 1 & this.mask;
        }
    }

    public boolean remove(Integer n) {
        int n2;
        if (n == 0) {
            if (!this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = false;
            int n3 = this.size_;
            this.size_ = n3 + -1;
            return true;
        }
        int n4 = this.locateKey(n);
        if (n4 < 0) {
            return false;
        }
        int[] nArray = this.keyTable;
        int n5 = this.mask;
        int n6 = n4 + 1 & n5;
        int n7 = 0;
        while (true) {
            int n8 = n2 = nArray[n6];
            boolean bl = false;
            n7 = n8;
            if (n2 == 0) break;
            n2 = this.place(n7);
            if ((n6 - n2 & n5) > (n4 - n2 & n5)) {
                nArray[n4] = n7;
                n4 = n6;
            }
            n6 = n6 + 1 & n5;
        }
        nArray[n4] = 0;
        n2 = this.size_;
        this.size_ = n2 + -1;
        return true;
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    public final void shrink(int n) {
        if (n < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + n);
        }
        int n2 = ObjectSet.Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length > n2) {
            this.resize(n2);
        }
    }

    public final void clear(int n) {
        int n2 = ObjectSet.Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length <= n2) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.hasZeroValue = false;
        this.resize(n2);
    }

    @Override
    public void clear() {
        if (this.size_ == 0) {
            return;
        }
        this.size_ = 0;
        Arrays.fill(this.keyTable, 0);
        this.hasZeroValue = false;
    }

    @Override
    public boolean containsAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Iterable iterable = collection;
        boolean bl = false;
        for (Object t : iterable) {
            int n = ((Number)t).intValue();
            boolean bl2 = false;
            if (this.contains((Object)n)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int n) {
        return n == 0 ? this.hasZeroValue : this.locateKey(n) >= 0;
    }

    public final int first() {
        if (this.hasZeroValue) {
            return 0;
        }
        int[] nArray = this.keyTable;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 0) continue;
            return nArray[i];
        }
        throw new IllegalStateException("IntSet is empty.");
    }

    public final void ensureCapacity(int n) {
        int n2 = ObjectSet.Companion.tableSize(this.size_ + n, this.loadFactor);
        if (this.keyTable.length < n2) {
            this.resize(n2);
        }
    }

    private final void resize(int n) {
        int n2 = this.keyTable.length;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        int[] nArray = this.keyTable;
        this.keyTable = new int[n];
        if (this.size_ > 0) {
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray[i];
                if (n3 == 0) continue;
                this.addResize(n3);
            }
        }
    }

    @Override
    public int hashCode() {
        int n = this.size_;
        for (int n2 : this.keyTable) {
            if (n2 == 0) continue;
            n += n2;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof IntSet)) {
            return false;
        }
        if (((IntSet)object).size_ != this.size_) {
            return false;
        }
        if (((IntSet)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        int[] nArray = this.keyTable;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 0 || ((IntSet)object).contains((Object)nArray[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n;
        if (this.size_ == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        int[] nArray = this.keyTable;
        int n2 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0");
        } else {
            while (n2-- > 0) {
                n = nArray[n2];
                if (n == 0) continue;
                stringBuilder.append(n);
                break;
            }
        }
        while (n2-- > 0) {
            n = nArray[n2];
            if (n == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n);
        }
        stringBuilder.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public IntSetIterator iterator() {
        if (this.allocateIterators) {
            return new IntSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new IntSetIterator(this);
            this.iterator2 = new IntSetIterator(this);
        }
        IntSetIterator intSetIterator = this.iterator1;
        Intrinsics.checkNotNull((Object)intSetIterator);
        if (!intSetIterator.getValid()) {
            IntSetIterator intSetIterator2 = this.iterator1;
            Intrinsics.checkNotNull((Object)intSetIterator2);
            intSetIterator2.reset();
            IntSetIterator intSetIterator3 = this.iterator1;
            Intrinsics.checkNotNull((Object)intSetIterator3);
            intSetIterator3.setValid(true);
            IntSetIterator intSetIterator4 = this.iterator2;
            Intrinsics.checkNotNull((Object)intSetIterator4);
            intSetIterator4.setValid(false);
            IntSetIterator intSetIterator5 = this.iterator1;
            Intrinsics.checkNotNull((Object)intSetIterator5);
            return intSetIterator5;
        }
        IntSetIterator intSetIterator6 = this.iterator2;
        Intrinsics.checkNotNull((Object)intSetIterator6);
        intSetIterator6.reset();
        IntSetIterator intSetIterator7 = this.iterator2;
        Intrinsics.checkNotNull((Object)intSetIterator7);
        intSetIterator7.setValid(true);
        IntSetIterator intSetIterator8 = this.iterator1;
        Intrinsics.checkNotNull((Object)intSetIterator8);
        intSetIterator8.setValid(false);
        IntSetIterator intSetIterator9 = this.iterator2;
        Intrinsics.checkNotNull((Object)intSetIterator9);
        return intSetIterator9;
    }

    @Override
    public boolean retainAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        boolean bl = false;
        int[] nArray = this.keyTable;
        boolean bl2 = false;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = n2 = nArray[i];
            boolean bl3 = false;
            if (collection.contains(n3)) continue;
            this.remove((Object)n3);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        boolean bl = false;
        Iterable iterable = collection;
        boolean bl2 = false;
        for (Object t : iterable) {
            int n = ((Number)t).intValue();
            boolean bl3 = false;
            bl = this.remove((Object)n) || bl;
        }
        return bl;
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public /* synthetic */ boolean add(Object object) {
        return this.add(((Number)object).intValue());
    }

    @Override
    public final boolean contains(Object object) {
        if (!(object instanceof Integer)) {
            return false;
        }
        return this.contains(((Number)object).intValue());
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldorkbox/collections/IntSet$Companion;", "", "()V", "version", "", "with", "Ldorkbox/collections/IntSet;", "array", "", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public final IntSet with(int ... nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
            IntSet intSet = new IntSet();
            intSet.addAll(nArray);
            return intSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\u000e\u0010\u001b\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u0006\u0010\u001e\u001a\u00020\u001aJ\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 R\u001a\u0010\u0006\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010\u00a8\u0006#"}, d2={"Ldorkbox/collections/IntSet$IntSetIterator;", "", "", "set", "Ldorkbox/collections/IntSet;", "(Ldorkbox/collections/IntSet;)V", "currentIndex", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "nextIndex", "getNextIndex", "setNextIndex", "getSet", "()Ldorkbox/collections/IntSet;", "valid", "getValid", "setValid", "findNextIndex", "", "next", "()Ljava/lang/Integer;", "remove", "reset", "toArray", "", "array", "Companion", "Collections"})
    public static final class IntSetIterator
    implements Iterator<Integer>,
    KMutableIterator {
        public static final Companion Companion = new Companion(null);
        private final IntSet set;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;
        private static final int INDEX_ILLEGAL = -2;
        private static final int INDEX_ZERO = -1;

        public IntSetIterator(IntSet intSet) {
            Intrinsics.checkNotNullParameter((Object)intSet, (String)"");
            this.set = intSet;
            this.valid = true;
            this.reset();
        }

        public final IntSet getSet() {
            return this.set;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public final void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.set.getHasZeroValue()) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        public final void findNextIndex() {
            block1: {
                int[] nArray = this.set.getKeyTable();
                int n = nArray.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (nArray[this.nextIndex] == 0);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            int n = this.currentIndex;
            if (n == -1 && this.set.getHasZeroValue()) {
                this.set.setHasZeroValue(false);
            } else {
                int n2;
                if (n < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                int[] nArray = this.set.getKeyTable();
                int n3 = this.set.getMask();
                int n4 = n + 1 & n3;
                int n5 = 0;
                while (true) {
                    int n6;
                    n2 = n6 = nArray[n4];
                    boolean bl = false;
                    n5 = n2;
                    if (n6 == 0) break;
                    n6 = this.set.place(n5);
                    if ((n4 - n6 & n3) > (n - n6 & n3)) {
                        nArray[n] = n5;
                        n = n4;
                    }
                    n4 = n4 + 1 & n3;
                }
                nArray[n] = 0;
                if (n != this.currentIndex) {
                    this.nextIndex += -1;
                }
                this.currentIndex = -2;
                IntSet intSet = this.set;
                n2 = intSet.size_;
                intSet.size_ = n2 + -1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Integer next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.nextIndex == -1 ? 0 : this.set.getKeyTable()[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return n;
        }

        public final int[] toArray() {
            int[] nArray = new int[this.set.size()];
            int n = 0;
            while (this.hasNext()) {
                nArray[n++] = this.next();
            }
            return nArray;
        }

        public final int[] toArray(int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
            int n = 0;
            while (this.hasNext) {
                nArray[n++] = this.next();
            }
            return nArray;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/collections/IntSet$IntSetIterator$Companion;", "", "()V", "INDEX_ILLEGAL", "", "INDEX_ZERO", "Collections"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }
}

