/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.font;

import androidx.compose.ui.text.internal.InlineClassHelperKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Landroidx/compose/ui/text/font/FontWeight;", "", "weight", "", "<init>", "(I)V", "getWeight", "()I", "compareTo", "other", "equals", "", "", "hashCode", "toString", "", "Companion", "ui-text"})
public final class FontWeight
implements Comparable<FontWeight> {
    public static final Companion Companion = new Companion(null);
    private final int weight;
    public static final int $stable;
    private static final FontWeight W100;
    private static final FontWeight W200;
    private static final FontWeight W300;
    private static final FontWeight W400;
    private static final FontWeight W500;
    private static final FontWeight W600;
    private static final FontWeight W700;
    private static final FontWeight W800;
    private static final FontWeight W900;
    private static final FontWeight Thin;
    private static final FontWeight ExtraLight;
    private static final FontWeight Light;
    private static final FontWeight Normal;
    private static final FontWeight Medium;
    private static final FontWeight SemiBold;
    private static final FontWeight Bold;
    private static final FontWeight ExtraBold;
    private static final FontWeight Black;
    private static final List<FontWeight> values;

    public FontWeight(int n) {
        this.weight = n;
        int n2 = this.weight;
        n2 = 1 <= n2 ? (n2 < 1001 ? 1 : 0) : 0;
        boolean bl = false;
        if (n2 == 0) {
            boolean bl2 = false;
            InlineClassHelperKt.throwIllegalArgumentException("Font weight can be in range [1, 1000]. Current value: " + this.weight);
        }
    }

    public final int getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(FontWeight fontWeight) {
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"");
        return Intrinsics.compare((int)this.weight, (int)fontWeight.weight);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FontWeight)) {
            return false;
        }
        return this.weight == ((FontWeight)object).weight;
    }

    public int hashCode() {
        return this.weight;
    }

    public String toString() {
        return "FontWeight(weight=" + this.weight + ")";
    }

    static {
        W100 = new FontWeight(100);
        W200 = new FontWeight(200);
        W300 = new FontWeight(300);
        W400 = new FontWeight(400);
        W500 = new FontWeight(500);
        W600 = new FontWeight(600);
        W700 = new FontWeight(700);
        W800 = new FontWeight(800);
        W900 = new FontWeight(900);
        Thin = W100;
        ExtraLight = W200;
        Light = W300;
        Normal = W400;
        Medium = W500;
        SemiBold = W600;
        Bold = W700;
        ExtraBold = W800;
        Black = W900;
        Object[] objectArray = new FontWeight[]{W100, W200, W300, W400, W500, W600, W700, W800, W900};
        values = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b7\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\bR\u001c\u0010\u0012\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\bR\u001c\u0010\u0015\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\bR\u001c\u0010\u0018\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u0003\u001a\u0004\b\u001a\u0010\bR\u001c\u0010\u001b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u0003\u001a\u0004\b\u001d\u0010\bR\u001c\u0010\u001e\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u0003\u001a\u0004\b \u0010\bR\u001c\u0010!\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\"\u0010\u0003\u001a\u0004\b#\u0010\bR\u001c\u0010$\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b%\u0010\u0003\u001a\u0004\b&\u0010\bR\u001c\u0010'\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b(\u0010\u0003\u001a\u0004\b)\u0010\bR\u001c\u0010*\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b+\u0010\u0003\u001a\u0004\b,\u0010\bR\u001c\u0010-\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b.\u0010\u0003\u001a\u0004\b/\u0010\bR\u001c\u00100\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b1\u0010\u0003\u001a\u0004\b2\u0010\bR\u001c\u00103\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b4\u0010\u0003\u001a\u0004\b5\u0010\bR\u001c\u00106\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b7\u0010\u0003\u001a\u0004\b8\u0010\bR\u001c\u00109\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b:\u0010\u0003\u001a\u0004\b;\u0010\bR\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050=X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?\u00a8\u0006@"}, d2={"Landroidx/compose/ui/text/font/FontWeight$Companion;", "", "<init>", "()V", "W100", "Landroidx/compose/ui/text/font/FontWeight;", "getW100$annotations", "getW100", "()Landroidx/compose/ui/text/font/FontWeight;", "W200", "getW200$annotations", "getW200", "W300", "getW300$annotations", "getW300", "W400", "getW400$annotations", "getW400", "W500", "getW500$annotations", "getW500", "W600", "getW600$annotations", "getW600", "W700", "getW700$annotations", "getW700", "W800", "getW800$annotations", "getW800", "W900", "getW900$annotations", "getW900", "Thin", "getThin$annotations", "getThin", "ExtraLight", "getExtraLight$annotations", "getExtraLight", "Light", "getLight$annotations", "getLight", "Normal", "getNormal$annotations", "getNormal", "Medium", "getMedium$annotations", "getMedium", "SemiBold", "getSemiBold$annotations", "getSemiBold", "Bold", "getBold$annotations", "getBold", "ExtraBold", "getExtraBold$annotations", "getExtraBold", "Black", "getBlack$annotations", "getBlack", "values", "", "getValues$ui_text", "()Ljava/util/List;", "ui-text"})
    public static final class Companion {
        private Companion() {
        }

        public final FontWeight getW100() {
            return W100;
        }

        public static /* synthetic */ void getW100$annotations() {
        }

        public final FontWeight getW200() {
            return W200;
        }

        public static /* synthetic */ void getW200$annotations() {
        }

        public final FontWeight getW300() {
            return W300;
        }

        public static /* synthetic */ void getW300$annotations() {
        }

        public final FontWeight getW400() {
            return W400;
        }

        public static /* synthetic */ void getW400$annotations() {
        }

        public final FontWeight getW500() {
            return W500;
        }

        public static /* synthetic */ void getW500$annotations() {
        }

        public final FontWeight getW600() {
            return W600;
        }

        public static /* synthetic */ void getW600$annotations() {
        }

        public final FontWeight getW700() {
            return W700;
        }

        public static /* synthetic */ void getW700$annotations() {
        }

        public final FontWeight getW800() {
            return W800;
        }

        public static /* synthetic */ void getW800$annotations() {
        }

        public final FontWeight getW900() {
            return W900;
        }

        public static /* synthetic */ void getW900$annotations() {
        }

        public final FontWeight getThin() {
            return Thin;
        }

        public static /* synthetic */ void getThin$annotations() {
        }

        public final FontWeight getExtraLight() {
            return ExtraLight;
        }

        public static /* synthetic */ void getExtraLight$annotations() {
        }

        public final FontWeight getLight() {
            return Light;
        }

        public static /* synthetic */ void getLight$annotations() {
        }

        public final FontWeight getNormal() {
            return Normal;
        }

        public static /* synthetic */ void getNormal$annotations() {
        }

        public final FontWeight getMedium() {
            return Medium;
        }

        public static /* synthetic */ void getMedium$annotations() {
        }

        public final FontWeight getSemiBold() {
            return SemiBold;
        }

        public static /* synthetic */ void getSemiBold$annotations() {
        }

        public final FontWeight getBold() {
            return Bold;
        }

        public static /* synthetic */ void getBold$annotations() {
        }

        public final FontWeight getExtraBold() {
            return ExtraBold;
        }

        public static /* synthetic */ void getExtraBold$annotations() {
        }

        public final FontWeight getBlack() {
            return Black;
        }

        public static /* synthetic */ void getBlack$annotations() {
        }

        public final List<FontWeight> getValues$ui_text() {
            return values;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

