/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.BackspaceCommand;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteAllCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import androidx.compose.ui.text.input.FinishComposingTextCommand;
import androidx.compose.ui.text.input.MoveCursorCommand;
import androidx.compose.ui.text.input.SetComposingRegionCommand;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.SetSelectionCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0014\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0006\u0010\u0015\u001a\u00020\u0005J \u0010\u0016\u001a\u00020\u00172\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0002J\f\u0010\u0019\u001a\u00020\u0017*\u00020\u0014H\u0002R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Landroidx/compose/ui/text/input/EditProcessor;", "", "<init>", "()V", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "mBufferState", "getMBufferState$ui_text", "()Landroidx/compose/ui/text/input/TextFieldValue;", "Landroidx/compose/ui/text/input/EditingBuffer;", "mBuffer", "getMBuffer$ui_text", "()Landroidx/compose/ui/text/input/EditingBuffer;", "reset", "", "textInputSession", "Landroidx/compose/ui/text/input/TextInputSession;", "apply", "editCommands", "", "Landroidx/compose/ui/text/input/EditCommand;", "toTextFieldValue", "generateBatchErrorMessage", "", "failedCommand", "toStringForLog", "ui-text"})
public final class EditProcessor {
    private TextFieldValue mBufferState = new TextFieldValue(AnnotatedStringKt.emptyAnnotatedString(), TextRange.Companion.getZero-d9O1mEE(), null, null);
    private EditingBuffer mBuffer = new EditingBuffer(this.mBufferState.getAnnotatedString(), this.mBufferState.getSelection-d9O1mEE(), null);
    public static final int $stable = 8;

    public final TextFieldValue getMBufferState$ui_text() {
        return this.mBufferState;
    }

    public final EditingBuffer getMBuffer$ui_text() {
        return this.mBuffer;
    }

    public final void reset(TextFieldValue textFieldValue, TextInputSession textInputSession) {
        block8: {
            TextFieldValue textFieldValue2;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = bl = !Intrinsics.areEqual((Object)textFieldValue.getComposition-MzsxiRA(), (Object)this.mBuffer.getComposition-MzsxiRA$ui_text());
            if (!Intrinsics.areEqual((Object)this.mBufferState.getAnnotatedString().getText(), (Object)textFieldValue.getAnnotatedString().getText())) {
                this.mBuffer = new EditingBuffer(textFieldValue.getAnnotatedString(), textFieldValue.getSelection-d9O1mEE(), null);
                bl2 = true;
            } else if (!TextRange.equals-impl0(this.mBufferState.getSelection-d9O1mEE(), textFieldValue.getSelection-d9O1mEE())) {
                this.mBuffer.setSelection$ui_text(TextRange.getMin-impl(textFieldValue.getSelection-d9O1mEE()), TextRange.getMax-impl(textFieldValue.getSelection-d9O1mEE()));
                bl3 = true;
            }
            if (textFieldValue.getComposition-MzsxiRA() == null) {
                this.mBuffer.commitComposition$ui_text();
            } else if (!TextRange.getCollapsed-impl(textFieldValue.getComposition-MzsxiRA().unbox-impl())) {
                this.mBuffer.setComposition$ui_text(TextRange.getMin-impl(textFieldValue.getComposition-MzsxiRA().unbox-impl()), TextRange.getMax-impl(textFieldValue.getComposition-MzsxiRA().unbox-impl()));
            }
            if (bl2 || !bl3 && bl) {
                this.mBuffer.commitComposition$ui_text();
                textFieldValue2 = TextFieldValue.copy-3r_uNRQ$default(textFieldValue, null, 0L, null, 3, null);
            } else {
                textFieldValue2 = textFieldValue;
            }
            TextFieldValue textFieldValue3 = textFieldValue2;
            TextFieldValue textFieldValue4 = this.mBufferState;
            this.mBufferState = textFieldValue3;
            TextInputSession textInputSession2 = textInputSession;
            if (textInputSession2 == null) break block8;
            textInputSession2.updateState(textFieldValue4, textFieldValue3);
        }
    }

    public final TextFieldValue apply(List<? extends EditCommand> list) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(list, (String)"");
        EditCommand editCommand = null;
        try {
            object2 = list;
            boolean bl = false;
            int n = ((Collection)object2).size();
            for (int k = 0; k < n; ++k) {
                EditCommand editCommand2 = object2.get(k);
                object = editCommand2;
                boolean bl2 = false;
                editCommand = object;
                object.applyTo(this.mBuffer);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(this.generateBatchErrorMessage(list, editCommand), exception);
        }
        long l = this.mBuffer.getSelection-d9O1mEE$ui_text();
        AnnotatedString annotatedString = this.mBuffer.toAnnotatedString$ui_text();
        boolean bl = false;
        object = TextRange.box-impl(l);
        long l2 = ((TextRange)object).unbox-impl();
        boolean bl3 = false;
        Object object3 = !TextRange.getReversed-impl(this.mBufferState.getSelection-d9O1mEE()) ? object : null;
        long l3 = object3 != null ? ((TextRange)object3).unbox-impl() : TextRangeKt.TextRange(TextRange.getMax-impl(l), TextRange.getMin-impl(l));
        DefaultConstructorMarker defaultConstructorMarker = null;
        TextRange textRange = this.mBuffer.getComposition-MzsxiRA$ui_text();
        long l4 = l3;
        AnnotatedString annotatedString2 = annotatedString;
        this.mBufferState = object2 = new TextFieldValue(annotatedString2, l4, textRange, defaultConstructorMarker);
        return object2;
    }

    public final TextFieldValue toTextFieldValue() {
        return this.mBufferState;
    }

    private final String generateBatchErrorMessage(List<? extends EditCommand> list, EditCommand editCommand) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append("Error while applying EditCommand batch to buffer (length=" + this.mBuffer.getLength$ui_text() + ", composition=" + this.mBuffer.getComposition-MzsxiRA$ui_text() + ", selection=" + TextRange.toString-impl(this.mBuffer.getSelection-d9O1mEE$ui_text()) + "):").append('\n');
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)stringBuilder2, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> EditProcessor.generateBatchErrorMessage$lambda$0$0(editCommand, this, arg_0), (int)60, null);
        return stringBuilder.toString();
    }

    private final String toStringForLog(EditCommand editCommand) {
        Object object;
        EditCommand editCommand2 = editCommand;
        if (editCommand2 instanceof CommitTextCommand) {
            object = "CommitTextCommand(text.length=" + ((CommitTextCommand)editCommand).getText().length() + ", newCursorPosition=" + ((CommitTextCommand)editCommand).getNewCursorPosition() + ")";
        } else if (editCommand2 instanceof SetComposingTextCommand) {
            object = "SetComposingTextCommand(text.length=" + ((SetComposingTextCommand)editCommand).getText().length() + ", newCursorPosition=" + ((SetComposingTextCommand)editCommand).getNewCursorPosition() + ")";
        } else if (editCommand2 instanceof SetComposingRegionCommand) {
            object = ((SetComposingRegionCommand)editCommand).toString();
        } else if (editCommand2 instanceof DeleteSurroundingTextCommand) {
            object = ((DeleteSurroundingTextCommand)editCommand).toString();
        } else if (editCommand2 instanceof DeleteSurroundingTextInCodePointsCommand) {
            object = ((DeleteSurroundingTextInCodePointsCommand)editCommand).toString();
        } else if (editCommand2 instanceof SetSelectionCommand) {
            object = ((SetSelectionCommand)editCommand).toString();
        } else if (editCommand2 instanceof FinishComposingTextCommand) {
            object = ((FinishComposingTextCommand)editCommand).toString();
        } else if (editCommand2 instanceof BackspaceCommand) {
            object = ((BackspaceCommand)editCommand).toString();
        } else if (editCommand2 instanceof MoveCursorCommand) {
            object = ((MoveCursorCommand)editCommand).toString();
        } else if (editCommand2 instanceof DeleteAllCommand) {
            object = ((DeleteAllCommand)editCommand).toString();
        } else {
            String string = Reflection.getOrCreateKotlinClass(editCommand.getClass()).getSimpleName();
            if (string == null) {
                string = "{anonymous EditCommand}";
            }
            object = "Unknown EditCommand: " + string;
        }
        return object;
    }

    private static final CharSequence generateBatchErrorMessage$lambda$0$0(EditCommand editCommand, EditProcessor editProcessor, EditCommand editCommand2) {
        Intrinsics.checkNotNullParameter((Object)editCommand2, (String)"");
        String string = editCommand == editCommand2 ? " > " : "   ";
        return string + editProcessor.toStringForLog(editCommand2);
    }
}

