/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.GapBufferKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0005H\u0002J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00122\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dJ\u0006\u0010\u001e\u001a\u00020\u0005J\b\u0010\u001f\u001a\u00020\u0019H\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/compose/ui/text/input/GapBuffer;", "", "initBuffer", "", "initGapStart", "", "initGapEnd", "<init>", "([CII)V", "capacity", "buffer", "gapStart", "gapEnd", "gapLength", "get", "", "index", "makeSureAvailableSpace", "", "requestSize", "delete", "start", "end", "replace", "text", "", "append", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "length", "toString", "ui-text"})
final class GapBuffer {
    private int capacity;
    private char[] buffer;
    private int gapStart;
    private int gapEnd;

    public GapBuffer(char[] cArray, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)cArray, (String)"");
        this.capacity = cArray.length;
        this.buffer = cArray;
        this.gapStart = n;
        this.gapEnd = n2;
    }

    private final int gapLength() {
        return this.gapEnd - this.gapStart;
    }

    public final char get(int n) {
        if (n < this.gapStart) {
            return this.buffer[n];
        }
        return this.buffer[n - this.gapStart + this.gapEnd];
    }

    private final void makeSureAvailableSpace(int n) {
        if (n <= this.gapLength()) {
            return;
        }
        int n2 = n - this.gapLength();
        int n3 = this.capacity * 2;
        while (n3 - this.capacity < n2) {
            n3 *= 2;
        }
        char[] cArray = new char[n3];
        ArraysKt.copyInto((char[])this.buffer, (char[])cArray, (int)0, (int)0, (int)this.gapStart);
        int n4 = this.capacity - this.gapEnd;
        int n5 = n3 - n4;
        ArraysKt.copyInto((char[])this.buffer, (char[])cArray, (int)n5, (int)this.gapEnd, (int)(this.gapEnd + n4));
        this.buffer = cArray;
        this.capacity = n3;
        this.gapEnd = n5;
    }

    private final void delete(int n, int n2) {
        if (n < this.gapStart && n2 <= this.gapStart) {
            int n3 = this.gapStart - n2;
            ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)(this.gapEnd - n3), (int)n2, (int)this.gapStart);
            this.gapStart = n;
            this.gapEnd -= n3;
        } else if (n < this.gapStart && n2 >= this.gapStart) {
            this.gapEnd = n2 + this.gapLength();
            this.gapStart = n;
        } else {
            int n4 = n + this.gapLength();
            int n5 = n2 + this.gapLength();
            int n6 = n4 - this.gapEnd;
            ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)this.gapStart, (int)this.gapEnd, (int)n4);
            this.gapStart += n6;
            this.gapEnd = n5;
        }
    }

    public final void replace(int n, int n2, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.makeSureAvailableSpace(string.length() - (n2 - n));
        this.delete(n, n2);
        GapBufferKt.access$toCharArray(string, this.buffer, this.gapStart);
        this.gapStart += string.length();
    }

    public final void append(StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
        StringBuilder stringBuilder2 = stringBuilder;
        char[] cArray = this.buffer;
        int n = 0;
        int n2 = this.gapStart;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append(cArray, n, n2 - n), (String)"");
        stringBuilder2 = stringBuilder;
        cArray = this.buffer;
        n = this.gapEnd;
        n2 = this.capacity;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append(cArray, n, n2 - n), (String)"");
    }

    public final int length() {
        return this.capacity - this.gapLength();
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append((CharSequence)stringBuilder2);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }
}

