/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.MessageSizeEstimator;
import io.netty.util.internal.ObjectUtil;

abstract class PendingBytesTracker
implements MessageSizeEstimator.Handle {
    private final MessageSizeEstimator.Handle estimatorHandle;

    private PendingBytesTracker(MessageSizeEstimator.Handle handle) {
        this.estimatorHandle = (MessageSizeEstimator.Handle)ObjectUtil.checkNotNull((Object)handle, (String)"estimatorHandle");
    }

    @Override
    public final int size(Object object) {
        return this.estimatorHandle.size(object);
    }

    public abstract void incrementPendingOutboundBytes(long var1);

    public abstract void decrementPendingOutboundBytes(long var1);

    static PendingBytesTracker newTracker(Channel channel) {
        if (channel.pipeline() instanceof DefaultChannelPipeline) {
            return new DefaultChannelPipelinePendingBytesTracker((DefaultChannelPipeline)channel.pipeline());
        }
        ChannelOutboundBuffer channelOutboundBuffer = channel.unsafe().outboundBuffer();
        MessageSizeEstimator.Handle handle = channel.config().getMessageSizeEstimator().newHandle();
        return channelOutboundBuffer == null ? new NoopPendingBytesTracker(handle) : new ChannelOutboundBufferPendingBytesTracker(channelOutboundBuffer, handle);
    }

    private static final class NoopPendingBytesTracker
    extends PendingBytesTracker {
        NoopPendingBytesTracker(MessageSizeEstimator.Handle handle) {
            super(handle);
        }

        @Override
        public void incrementPendingOutboundBytes(long l) {
        }

        @Override
        public void decrementPendingOutboundBytes(long l) {
        }
    }

    private static final class ChannelOutboundBufferPendingBytesTracker
    extends PendingBytesTracker {
        private final ChannelOutboundBuffer buffer;

        ChannelOutboundBufferPendingBytesTracker(ChannelOutboundBuffer channelOutboundBuffer, MessageSizeEstimator.Handle handle) {
            super(handle);
            this.buffer = channelOutboundBuffer;
        }

        @Override
        public void incrementPendingOutboundBytes(long l) {
            this.buffer.incrementPendingOutboundBytes(l);
        }

        @Override
        public void decrementPendingOutboundBytes(long l) {
            this.buffer.decrementPendingOutboundBytes(l);
        }
    }

    private static final class DefaultChannelPipelinePendingBytesTracker
    extends PendingBytesTracker {
        private final DefaultChannelPipeline pipeline;

        DefaultChannelPipelinePendingBytesTracker(DefaultChannelPipeline defaultChannelPipeline) {
            super(defaultChannelPipeline.estimatorHandle());
            this.pipeline = defaultChannelPipeline;
        }

        @Override
        public void incrementPendingOutboundBytes(long l) {
            this.pipeline.incrementPendingOutboundBytes(l);
        }

        @Override
        public void decrementPendingOutboundBytes(long l) {
            this.pipeline.decrementPendingOutboundBytes(l);
        }
    }
}

