/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.embedded.EmbeddedChannelId;
import io.netty.channel.embedded.EmbeddedEventLoop;
import io.netty.channel.embedded.EmbeddedSocketAddress;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.RecyclableArrayList;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class EmbeddedChannel
extends AbstractChannel {
    private static final SocketAddress LOCAL_ADDRESS = new EmbeddedSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new EmbeddedSocketAddress();
    private static final ChannelHandler[] EMPTY_HANDLERS = new ChannelHandler[0];
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA_NO_DISCONNECT = new ChannelMetadata(false);
    private static final ChannelMetadata METADATA_DISCONNECT = new ChannelMetadata(true);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelFutureListener recordExceptionListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture channelFuture) {
            EmbeddedChannel.this.recordException(channelFuture);
        }
    };
    private final ChannelMetadata metadata;
    private final ChannelConfig config;
    private Queue<Object> inboundMessages;
    private Queue<Object> outboundMessages;
    private Throwable lastException;
    private State state;
    private int executingStackCnt;
    private boolean cancelRemainingScheduledTasks;

    public EmbeddedChannel() {
        this(EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelId channelId) {
        this(channelId, EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, channelHandlerArray);
    }

    public EmbeddedChannel(boolean bl, ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, bl, channelHandlerArray);
    }

    public EmbeddedChannel(boolean bl, boolean bl2, ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, bl, bl2, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, ChannelHandler ... channelHandlerArray) {
        this(channelId, false, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl, ChannelHandler ... channelHandlerArray) {
        this(channelId, true, bl, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl, boolean bl2, ChannelHandler ... channelHandlerArray) {
        this(null, channelId, bl, bl2, channelHandlerArray);
    }

    public EmbeddedChannel(Channel channel, ChannelId channelId, boolean bl, boolean bl2, ChannelHandler ... channelHandlerArray) {
        super(channel, channelId);
        this.metadata = EmbeddedChannel.metadata(bl2);
        this.config = new DefaultChannelConfig(this);
        this.setup(bl, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl, ChannelConfig channelConfig, ChannelHandler ... channelHandlerArray) {
        super(null, channelId);
        this.metadata = EmbeddedChannel.metadata(bl);
        this.config = (ChannelConfig)ObjectUtil.checkNotNull((Object)channelConfig, (String)"config");
        this.setup(true, channelHandlerArray);
    }

    private static ChannelMetadata metadata(boolean bl) {
        return bl ? METADATA_DISCONNECT : METADATA_NO_DISCONNECT;
    }

    private void setup(boolean bl, final ChannelHandler ... channelHandlerArray) {
        ObjectUtil.checkNotNull((Object)channelHandlerArray, (String)"handlers");
        ChannelPipeline channelPipeline = this.pipeline();
        channelPipeline.addLast(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel channel) {
                ChannelPipeline channelPipeline = channel.pipeline();
                for (ChannelHandler channelHandler : channelHandlerArray) {
                    if (channelHandler == null) break;
                    channelPipeline.addLast(channelHandler);
                }
            }
        });
        if (bl) {
            ChannelFuture channelFuture = this.loop.register(this);
            assert (channelFuture.isDone());
        }
    }

    public void register() {
        ChannelFuture channelFuture = this.loop.register(this);
        assert (channelFuture.isDone());
        Throwable throwable = channelFuture.cause();
        if (throwable != null) {
            PlatformDependent.throwException((Throwable)throwable);
        }
    }

    @Override
    protected final DefaultChannelPipeline newChannelPipeline() {
        return new EmbeddedChannelPipeline(this);
    }

    @Override
    public ChannelMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public Queue<Object> inboundMessages() {
        if (this.inboundMessages == null) {
            this.inboundMessages = new ArrayDeque<Object>();
        }
        return this.inboundMessages;
    }

    @Deprecated
    public Queue<Object> lastInboundBuffer() {
        return this.inboundMessages();
    }

    public Queue<Object> outboundMessages() {
        if (this.outboundMessages == null) {
            this.outboundMessages = new ArrayDeque<Object>();
        }
        return this.outboundMessages;
    }

    @Deprecated
    public Queue<Object> lastOutboundBuffer() {
        return this.outboundMessages();
    }

    public <T> T readInbound() {
        Object object = EmbeddedChannel.poll(this.inboundMessages);
        if (object != null) {
            ReferenceCountUtil.touch((Object)object, (Object)"Caller of readInbound() will handle the message from this point");
        }
        return (T)object;
    }

    public <T> T readOutbound() {
        Object object = EmbeddedChannel.poll(this.outboundMessages);
        if (object != null) {
            ReferenceCountUtil.touch((Object)object, (Object)"Caller of readOutbound() will handle the message from this point.");
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeInbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.inboundMessages);
        }
        ++this.executingStackCnt;
        try {
            ChannelPipeline channelPipeline = this.pipeline();
            for (Object object : objectArray) {
                channelPipeline.fireChannelRead(object);
            }
            this.flushInbound(false, this.voidPromise());
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return EmbeddedChannel.isNotEmpty(this.inboundMessages);
    }

    public ChannelFuture writeOneInbound(Object object) {
        return this.writeOneInbound(object, this.newPromise());
    }

    public ChannelFuture writeOneInbound(Object object, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            if (this.checkOpen(true)) {
                this.pipeline().fireChannelRead(object);
            }
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return this.checkException(channelPromise);
    }

    public EmbeddedChannel flushInbound() {
        this.flushInbound(true, this.voidPromise());
        return this;
    }

    private ChannelFuture flushInbound(boolean bl, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            if (this.checkOpen(bl)) {
                this.pipeline().fireChannelReadComplete();
                this.runPendingTasks();
            }
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return this.checkException(channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeOutbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.outboundMessages);
        }
        ++this.executingStackCnt;
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance((int)objectArray.length);
        try {
            int n;
            try {
                Object object;
                Object[] objectArray2 = objectArray;
                int n2 = objectArray2.length;
                for (int i = 0; i < n2 && (object = objectArray2[i]) != null; ++i) {
                    recyclableArrayList.add((Object)this.write(object));
                }
                this.flushOutbound0();
                n = recyclableArrayList.size();
                for (n2 = 0; n2 < n; ++n2) {
                    ChannelFuture channelFuture = (ChannelFuture)recyclableArrayList.get(n2);
                    if (channelFuture.isDone()) {
                        this.recordException(channelFuture);
                        continue;
                    }
                    channelFuture.addListener(this.recordExceptionListener);
                }
            }
            finally {
                --this.executingStackCnt;
                this.maybeRunPendingTasks();
            }
            this.checkException();
            n = EmbeddedChannel.isNotEmpty(this.outboundMessages) ? 1 : 0;
            return n != 0;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    public ChannelFuture writeOneOutbound(Object object) {
        return this.writeOneOutbound(object, this.newPromise());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture writeOneOutbound(Object object, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            if (this.checkOpen(true)) {
                ChannelFuture channelFuture = this.write(object, channelPromise);
                return channelFuture;
            }
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return this.checkException(channelPromise);
    }

    public EmbeddedChannel flushOutbound() {
        ++this.executingStackCnt;
        try {
            if (this.checkOpen(true)) {
                this.flushOutbound0();
            }
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        this.checkException(this.voidPromise());
        return this;
    }

    private void flushOutbound0() {
        this.runPendingTasks();
        this.flush();
    }

    public boolean finish() {
        return this.finish(false);
    }

    public boolean finishAndReleaseAll() {
        return this.finish(true);
    }

    private boolean finish(boolean bl) {
        ++this.executingStackCnt;
        try {
            this.close();
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        try {
            this.checkException();
            boolean bl2 = EmbeddedChannel.isNotEmpty(this.inboundMessages) || EmbeddedChannel.isNotEmpty(this.outboundMessages);
            return bl2;
        }
        finally {
            if (bl) {
                EmbeddedChannel.releaseAll(this.inboundMessages);
                EmbeddedChannel.releaseAll(this.outboundMessages);
            }
        }
    }

    public boolean releaseInbound() {
        return EmbeddedChannel.releaseAll(this.inboundMessages);
    }

    public boolean releaseOutbound() {
        return EmbeddedChannel.releaseAll(this.outboundMessages);
    }

    private static boolean releaseAll(Queue<Object> queue) {
        if (EmbeddedChannel.isNotEmpty(queue)) {
            Object object;
            while ((object = queue.poll()) != null) {
                ReferenceCountUtil.release((Object)object);
            }
            return true;
        }
        return false;
    }

    @Override
    public final ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public final ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public final ChannelFuture close(ChannelPromise channelPromise) {
        ChannelFuture channelFuture;
        ++this.executingStackCnt;
        try {
            this.runPendingTasks();
            channelFuture = super.close(channelPromise);
            this.cancelRemainingScheduledTasks = true;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return channelFuture;
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise channelPromise) {
        ChannelFuture channelFuture;
        ++this.executingStackCnt;
        try {
            channelFuture = super.disconnect(channelPromise);
            if (!this.metadata.hasDisconnect()) {
                this.cancelRemainingScheduledTasks = true;
            }
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.bind(socketAddress);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.connect(socketAddress);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.connect(socketAddress, socketAddress2);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture deregister() {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.deregister();
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public Channel flush() {
        ++this.executingStackCnt;
        try {
            Channel channel = super.flush();
            return channel;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.bind(socketAddress, channelPromise);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.connect(socketAddress, channelPromise);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.connect(socketAddress, socketAddress2, channelPromise);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture deregister(ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.deregister(channelPromise);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public Channel read() {
        ++this.executingStackCnt;
        try {
            Channel channel = super.read();
            return channel;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture write(Object object) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.write(object);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.write(object, channelPromise);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.writeAndFlush(object);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.writeAndFlush(object, channelPromise);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    private static boolean isNotEmpty(Queue<Object> queue) {
        return queue != null && !queue.isEmpty();
    }

    private static Object poll(Queue<Object> queue) {
        return queue != null ? queue.poll() : null;
    }

    private void maybeRunPendingTasks() {
        if (this.executingStackCnt == 0) {
            this.runPendingTasks();
            if (this.cancelRemainingScheduledTasks) {
                this.embeddedEventLoop().cancelScheduledTasks();
            }
        }
    }

    public void runPendingTasks() {
        try {
            this.embeddedEventLoop().runTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
        try {
            this.embeddedEventLoop().runScheduledTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
    }

    public boolean hasPendingTasks() {
        return this.embeddedEventLoop().hasPendingNormalTasks() || this.embeddedEventLoop().nextScheduledTask() == 0L;
    }

    public long runScheduledPendingTasks() {
        try {
            return this.embeddedEventLoop().runScheduledTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
            return this.embeddedEventLoop().nextScheduledTask();
        }
    }

    private void recordException(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            this.recordException(channelFuture.cause());
        }
    }

    private void recordException(Throwable throwable) {
        if (this.lastException == null) {
            this.lastException = throwable;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", throwable);
        }
    }

    public void advanceTimeBy(long l, TimeUnit timeUnit) {
        this.embeddedEventLoop().advanceTimeBy(timeUnit.toNanos(l));
    }

    public void freezeTime() {
        this.embeddedEventLoop().freezeTime();
    }

    public void unfreezeTime() {
        this.embeddedEventLoop().unfreezeTime();
    }

    private ChannelFuture checkException(ChannelPromise channelPromise) {
        Throwable throwable = this.lastException;
        if (throwable != null) {
            this.lastException = null;
            if (channelPromise.isVoid()) {
                PlatformDependent.throwException((Throwable)throwable);
            }
            return channelPromise.setFailure(throwable);
        }
        return channelPromise.setSuccess();
    }

    public void checkException() {
        this.checkException(this.voidPromise());
    }

    private boolean checkOpen(boolean bl) {
        if (!this.isOpen()) {
            if (bl) {
                this.recordException(new ClosedChannelException());
            }
            return false;
        }
        return true;
    }

    private EmbeddedEventLoop embeddedEventLoop() {
        if (this.isRegistered()) {
            return (EmbeddedEventLoop)super.eventLoop();
        }
        return this.loop;
    }

    protected final void ensureOpen() {
        if (!this.checkOpen(true)) {
            this.checkException();
        }
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EmbeddedEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.isActive() ? LOCAL_ADDRESS : null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.isActive() ? REMOTE_ADDRESS : null;
    }

    @Override
    protected void doRegister() {
        this.state = State.ACTIVE;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
    }

    @Override
    protected void doDisconnect() {
        if (!this.metadata.hasDisconnect()) {
            this.doClose();
        }
    }

    @Override
    protected void doClose() {
        this.state = State.CLOSED;
    }

    @Override
    protected void doBeginRead() {
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new EmbeddedUnsafe();
    }

    @Override
    public Channel.Unsafe unsafe() {
        return ((EmbeddedUnsafe)super.unsafe()).wrapped;
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            ReferenceCountUtil.retain((Object)object);
            this.handleOutboundMessage(object);
            channelOutboundBuffer.remove();
        }
    }

    protected void handleOutboundMessage(Object object) {
        this.outboundMessages().add(object);
    }

    protected void handleInboundMessage(Object object) {
        this.inboundMessages().add(object);
    }

    private final class EmbeddedChannelPipeline
    extends DefaultChannelPipeline {
        EmbeddedChannelPipeline(EmbeddedChannel embeddedChannel2) {
            super(embeddedChannel2);
        }

        @Override
        protected void onUnhandledInboundException(Throwable throwable) {
            EmbeddedChannel.this.recordException(throwable);
        }

        @Override
        protected void onUnhandledInboundMessage(ChannelHandlerContext channelHandlerContext, Object object) {
            EmbeddedChannel.this.handleInboundMessage(object);
        }
    }

    private final class EmbeddedUnsafe
    extends AbstractChannel.AbstractUnsafe {
        final Channel.Unsafe wrapped = new Channel.Unsafe(){

            @Override
            public RecvByteBufAllocator.Handle recvBufAllocHandle() {
                return EmbeddedUnsafe.this.recvBufAllocHandle();
            }

            @Override
            public SocketAddress localAddress() {
                return EmbeddedUnsafe.this.localAddress();
            }

            @Override
            public SocketAddress remoteAddress() {
                return EmbeddedUnsafe.this.remoteAddress();
            }

            @Override
            public void register(EventLoop eventLoop, ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.register(eventLoop, channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.bind(socketAddress, channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.connect(socketAddress, socketAddress2, channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void disconnect(ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.disconnect(channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void close(ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.close(channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void closeForcibly() {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.closeForcibly();
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void deregister(ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.deregister(channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void beginRead() {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.beginRead();
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void write(Object object, ChannelPromise channelPromise) {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.write(object, channelPromise);
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public void flush() {
                EmbeddedChannel.this.executingStackCnt++;
                try {
                    EmbeddedUnsafe.this.flush();
                }
                finally {
                    EmbeddedChannel.this.executingStackCnt--;
                    EmbeddedChannel.this.maybeRunPendingTasks();
                }
            }

            @Override
            public ChannelPromise voidPromise() {
                return EmbeddedUnsafe.this.voidPromise();
            }

            @Override
            public ChannelOutboundBuffer outboundBuffer() {
                return EmbeddedUnsafe.this.outboundBuffer();
            }
        };

        private EmbeddedUnsafe() {
        }

        @Override
        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            this.safeSetSuccess(channelPromise);
        }
    }

    private static enum State {
        OPEN,
        ACTIVE,
        CLOSED;

    }
}

