/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ipfilter.IpSubnetFilterRule;
import io.netty.handler.ipfilter.IpSubnetFilterRuleComparator;
import io.netty.util.internal.ObjectUtil;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@ChannelHandler.Sharable
public class IpSubnetFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final boolean acceptIfNotFound;
    private final IpSubnetFilterRule[] ipv4Rules;
    private final IpSubnetFilterRule[] ipv6Rules;
    private final IpFilterRuleType ipFilterRuleTypeIPv4;
    private final IpFilterRuleType ipFilterRuleTypeIPv6;

    public IpSubnetFilter(IpSubnetFilterRule ... ipSubnetFilterRuleArray) {
        this(true, Arrays.asList((Object[])ObjectUtil.checkNotNull((Object)ipSubnetFilterRuleArray, (String)"rules")));
    }

    public IpSubnetFilter(boolean bl, IpSubnetFilterRule ... ipSubnetFilterRuleArray) {
        this(bl, Arrays.asList((Object[])ObjectUtil.checkNotNull((Object)ipSubnetFilterRuleArray, (String)"rules")));
    }

    public IpSubnetFilter(List<IpSubnetFilterRule> list) {
        this(true, list);
    }

    public IpSubnetFilter(boolean bl, List<IpSubnetFilterRule> list) {
        ObjectUtil.checkNotNull(list, (String)"rules");
        this.acceptIfNotFound = bl;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ArrayList<IpSubnetFilterRule> arrayList = new ArrayList<IpSubnetFilterRule>();
        ArrayList<IpSubnetFilterRule> arrayList2 = new ArrayList<IpSubnetFilterRule>();
        for (IpSubnetFilterRule ipSubnetFilterRule : list) {
            ObjectUtil.checkNotNull((Object)ipSubnetFilterRule, (String)"rule");
            if (ipSubnetFilterRule.getFilterRule() instanceof IpSubnetFilterRule.Ip4SubnetFilterRule) {
                arrayList.add(ipSubnetFilterRule);
                if (ipSubnetFilterRule.ruleType() == IpFilterRuleType.ACCEPT) {
                    ++n;
                    continue;
                }
                ++n2;
                continue;
            }
            arrayList2.add(ipSubnetFilterRule);
            if (ipSubnetFilterRule.ruleType() == IpFilterRuleType.ACCEPT) {
                ++n3;
                continue;
            }
            ++n4;
        }
        this.ipFilterRuleTypeIPv4 = n == 0 && n2 > 0 ? IpFilterRuleType.REJECT : (n > 0 && n2 == 0 ? IpFilterRuleType.ACCEPT : null);
        this.ipFilterRuleTypeIPv6 = n3 == 0 && n4 > 0 ? IpFilterRuleType.REJECT : (n3 > 0 && n4 == 0 ? IpFilterRuleType.ACCEPT : null);
        this.ipv4Rules = arrayList.isEmpty() ? null : IpSubnetFilter.sortAndFilter(arrayList);
        this.ipv6Rules = arrayList2.isEmpty() ? null : IpSubnetFilter.sortAndFilter(arrayList2);
    }

    @Override
    protected boolean accept(ChannelHandlerContext channelHandlerContext, InetSocketAddress inetSocketAddress) {
        int n;
        if (this.ipv4Rules != null && inetSocketAddress.getAddress() instanceof Inet4Address) {
            int n2 = Arrays.binarySearch(this.ipv4Rules, inetSocketAddress, IpSubnetFilterRuleComparator.INSTANCE);
            if (n2 >= 0) {
                if (this.ipFilterRuleTypeIPv4 == null) {
                    return this.ipv4Rules[n2].ruleType() == IpFilterRuleType.ACCEPT;
                }
                return this.ipFilterRuleTypeIPv4 == IpFilterRuleType.ACCEPT;
            }
        } else if (this.ipv6Rules != null && (n = Arrays.binarySearch(this.ipv6Rules, inetSocketAddress, IpSubnetFilterRuleComparator.INSTANCE)) >= 0) {
            if (this.ipFilterRuleTypeIPv6 == null) {
                return this.ipv6Rules[n].ruleType() == IpFilterRuleType.ACCEPT;
            }
            return this.ipFilterRuleTypeIPv6 == IpFilterRuleType.ACCEPT;
        }
        return this.acceptIfNotFound;
    }

    private static IpSubnetFilterRule[] sortAndFilter(List<IpSubnetFilterRule> list) {
        IpSubnetFilterRule ipSubnetFilterRule;
        Collections.sort(list);
        Iterator<IpSubnetFilterRule> iterator = list.iterator();
        ArrayList<IpSubnetFilterRule> arrayList = new ArrayList<IpSubnetFilterRule>();
        IpSubnetFilterRule ipSubnetFilterRule2 = ipSubnetFilterRule = iterator.hasNext() ? iterator.next() : null;
        if (ipSubnetFilterRule != null) {
            arrayList.add(ipSubnetFilterRule);
        }
        while (iterator.hasNext()) {
            IpSubnetFilterRule ipSubnetFilterRule3 = iterator.next();
            if (ipSubnetFilterRule.matches(new InetSocketAddress(ipSubnetFilterRule3.getIpAddress(), 1))) continue;
            arrayList.add(ipSubnetFilterRule3);
            ipSubnetFilterRule = ipSubnetFilterRule3;
        }
        return arrayList.toArray(new IpSubnetFilterRule[0]);
    }
}

