/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkAlpnSslUtils;
import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.handler.ssl.SslUtils;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

class JdkAlpnSslEngine
extends JdkSslEngine {
    private final JdkApplicationProtocolNegotiator.ProtocolSelectionListener selectionListener;
    private final AlpnSelector alpnSelector;

    JdkAlpnSslEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, boolean bl, BiConsumer<SSLEngine, AlpnSelector> biConsumer, BiConsumer<SSLEngine, List<String>> biConsumer2) {
        super(sSLEngine);
        if (bl) {
            this.selectionListener = null;
            this.alpnSelector = new AlpnSelector(jdkApplicationProtocolNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(jdkApplicationProtocolNegotiator.protocols())));
            biConsumer.accept(sSLEngine, this.alpnSelector);
        } else {
            this.selectionListener = jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols());
            this.alpnSelector = null;
            biConsumer2.accept(sSLEngine, jdkApplicationProtocolNegotiator.protocols());
        }
    }

    JdkAlpnSslEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, boolean bl) {
        this(sSLEngine, jdkApplicationProtocolNegotiator, bl, new BiConsumer<SSLEngine, AlpnSelector>(){

            @Override
            public void accept(SSLEngine sSLEngine, AlpnSelector alpnSelector) {
                JdkAlpnSslUtils.setHandshakeApplicationProtocolSelector(sSLEngine, alpnSelector);
            }
        }, new BiConsumer<SSLEngine, List<String>>(){

            @Override
            public void accept(SSLEngine sSLEngine, List<String> list) {
                JdkAlpnSslUtils.setApplicationProtocols(sSLEngine, list);
            }
        });
    }

    private SSLEngineResult verifyProtocolSelection(SSLEngineResult sSLEngineResult) {
        if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            if (this.alpnSelector == null) {
                try {
                    String string = this.getApplicationProtocol();
                    assert (string != null);
                    if (string.isEmpty()) {
                        this.selectionListener.unsupported();
                    }
                    this.selectionListener.selected(string);
                }
                catch (Throwable throwable) {
                    throw SslUtils.toSSLHandshakeException(throwable);
                }
            } else {
                assert (this.selectionListener == null);
                this.alpnSelector.checkUnsupported();
            }
        }
        return sSLEngineResult;
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return this.verifyProtocolSelection(super.wrap(byteBuffer, byteBuffer2));
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer) {
        return this.verifyProtocolSelection(super.wrap(byteBufferArray, byteBuffer));
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) {
        return this.verifyProtocolSelection(super.wrap(byteBufferArray, n, n2, byteBuffer));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return this.verifyProtocolSelection(super.unwrap(byteBuffer, byteBuffer2));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) {
        return this.verifyProtocolSelection(super.unwrap(byteBuffer, byteBufferArray));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) {
        return this.verifyProtocolSelection(super.unwrap(byteBuffer, byteBufferArray, n, n2));
    }

    @Override
    void setNegotiatedApplicationProtocol(String string) {
    }

    @Override
    public String getNegotiatedApplicationProtocol() {
        String string = this.getApplicationProtocol();
        if (string != null) {
            return string.isEmpty() ? null : string;
        }
        return null;
    }

    @Override
    public String getApplicationProtocol() {
        return JdkAlpnSslUtils.getApplicationProtocol(this.getWrappedEngine());
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        return JdkAlpnSslUtils.getHandshakeApplicationProtocol(this.getWrappedEngine());
    }

    @Override
    public void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> biFunction) {
        JdkAlpnSslUtils.setHandshakeApplicationProtocolSelector(this.getWrappedEngine(), biFunction);
    }

    @Override
    public BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return JdkAlpnSslUtils.getHandshakeApplicationProtocolSelector(this.getWrappedEngine());
    }

    final class AlpnSelector
    implements BiFunction<SSLEngine, List<String>, String> {
        private final JdkApplicationProtocolNegotiator.ProtocolSelector selector;
        private boolean called;

        AlpnSelector(JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector) {
            this.selector = protocolSelector;
        }

        @Override
        public String apply(SSLEngine sSLEngine, List<String> list) {
            assert (!this.called);
            this.called = true;
            try {
                String string = this.selector.select(list);
                return string == null ? "" : string;
            }
            catch (Exception exception) {
                return null;
            }
        }

        void checkUnsupported() {
            if (this.called) {
                return;
            }
            String string = JdkAlpnSslEngine.this.getApplicationProtocol();
            assert (string != null);
            if (string.isEmpty()) {
                this.selector.unsupported();
            }
        }
    }
}

