/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.PointerScope;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.Raw;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Logger;

@Properties(inherit={javacpp.class})
public class Pointer
implements AutoCloseable {
    private static final Logger logger;
    private static final ReferenceQueue<Pointer> referenceQueue;
    static final Thread deallocatorThread;
    static final long maxBytes;
    static final long maxPhysicalBytes;
    static final int maxRetries;
    protected long address = 0L;
    protected long position = 0L;
    protected long limit = 0L;
    protected long capacity = 0L;
    private Deallocator deallocator = null;

    public Pointer() {
    }

    public Pointer(Pointer pointer) {
        if (pointer != null) {
            this.address = pointer.address;
            this.position = pointer.position;
            this.limit = pointer.limit;
            this.capacity = pointer.capacity;
            if (pointer.deallocator != null) {
                this.deallocator = new ProxyDeallocator(this, pointer);
            }
        }
    }

    public Pointer(Buffer buffer) {
        if (buffer != null) {
            this.allocate(buffer);
        }
        if (!this.isNull()) {
            this.address -= (long)(buffer.position() * this.sizeof());
            this.position = buffer.position();
            this.limit = buffer.limit();
            this.capacity = buffer.capacity();
            this.deallocator = new ProxyDeallocator(this, buffer);
        }
    }

    private native void allocate(Buffer var1);

    void init(long l, long l2, long l3, long l4) {
        this.address = l;
        this.position = 0L;
        this.limit = l2;
        this.capacity = l2;
        if (l3 != 0L && l4 != 0L) {
            this.deallocator(new NativeDeallocator(this, l3, l4));
        }
    }

    protected <P extends Pointer> P offsetAddress(long l) {
        this.address += l * (long)this.sizeof();
        this.limit = Math.max(0L, this.limit - l);
        this.capacity = Math.max(0L, this.capacity - l);
        return (P)this;
    }

    protected static <P extends Pointer> P withDeallocator(P p) {
        return p.deallocator(new CustomDeallocator(p));
    }

    public static String formatBytes(long l) {
        if (l < 102400L) {
            return l + "";
        }
        if ((l /= 1024L) < 102400L) {
            return l + "K";
        }
        if ((l /= 1024L) < 102400L) {
            return l + "M";
        }
        if ((l /= 1024L) < 102400L) {
            return l + "G";
        }
        return l / 1024L + "T";
    }

    public static long parseBytes(String string, long l) {
        int n;
        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        long l2 = Long.parseLong(string.substring(0, n));
        switch (string.substring(n).trim().toLowerCase()) {
            case "%": {
                l2 = l2 * l / 100L;
                break;
            }
            case "t": 
            case "tb": {
                l2 *= 1024L;
            }
            case "g": 
            case "gb": {
                l2 *= 1024L;
            }
            case "m": 
            case "mb": {
                l2 *= 1024L;
            }
            case "k": 
            case "kb": {
                l2 *= 1024L;
            }
            case "": {
                break;
            }
            default: {
                throw new NumberFormatException("Cannot parse into bytes: " + string);
            }
        }
        return l2;
    }

    public static void interruptDeallocatorThread() {
        if (deallocatorThread != null) {
            deallocatorThread.interrupt();
        }
    }

    public static void deallocateReferences() {
        DeallocatorReference deallocatorReference;
        while (referenceQueue != null && (deallocatorReference = (DeallocatorReference)referenceQueue.poll()) != null) {
            deallocatorReference.clear();
            deallocatorReference.remove();
        }
    }

    public static long maxBytes() {
        return maxBytes;
    }

    public static long totalBytes() {
        return DeallocatorReference.totalBytes;
    }

    public static long totalCount() {
        return DeallocatorReference.totalCount;
    }

    public static long maxPhysicalBytes() {
        return maxPhysicalBytes;
    }

    @Name(value={"JavaCPP_trimMemory"})
    private static native boolean trimMemory();

    @Name(value={"JavaCPP_physicalBytes"})
    public static native long physicalBytes();

    @Name(value={"JavaCPP_physicalBytes"})
    public static native long physicalBytesInaccurate(long var0);

    @Name(value={"JavaCPP_totalPhysicalBytes"})
    public static native long totalPhysicalBytes();

    @Name(value={"JavaCPP_availablePhysicalBytes"})
    public static native long availablePhysicalBytes();

    @Name(value={"JavaCPP_getDirectBufferAddress"})
    protected static native long getDirectBufferAddress(@Raw(withEnv=true) Buffer var0);

    public static boolean isNull(Pointer pointer) {
        return pointer == null || pointer.address == 0L;
    }

    public boolean isNull() {
        return this.address == 0L;
    }

    public void setNull() {
        this.address = 0L;
    }

    public long address() {
        return this.address;
    }

    public long position() {
        return this.position;
    }

    public <P extends Pointer> P position(long l) {
        this.position = l;
        return (P)this;
    }

    public long limit() {
        return this.limit;
    }

    public <P extends Pointer> P limit(long l) {
        this.limit = l;
        return (P)this;
    }

    public long capacity() {
        return this.capacity;
    }

    public <P extends Pointer> P capacity(long l) {
        this.limit = l;
        this.capacity = l;
        return (P)this;
    }

    protected Deallocator deallocator() {
        return this.deallocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected <P extends Pointer> P deallocator(Deallocator deallocator) {
        Object object;
        if (this.deallocator != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Predeallocating " + this);
            }
            this.deallocator.deallocate();
            this.deallocator = null;
        }
        if (deallocator == null) return (P)this;
        if (deallocator.equals(null)) return (P)this;
        DeallocatorReference deallocatorReference = deallocator instanceof DeallocatorReference ? (DeallocatorReference)deallocator : new DeallocatorReference(this, deallocator);
        this.deallocator = deallocatorReference;
        if (referenceQueue != null) {
            long l;
            block20: {
                int n;
                block19: {
                    object = DeallocatorThread.class;
                    // MONITORENTER : org.bytedeco.javacpp.Pointer$DeallocatorThread.class
                    n = 0;
                    l = 0L;
                    try {
                        if (maxPhysicalBytes <= 0L) break block19;
                        try {
                            l = Pointer.physicalBytesInaccurate(maxPhysicalBytes);
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(unsatisfiedLinkError.getMessage());
                            }
                            l = Pointer.physicalBytes();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break block20;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (!logger.isDebugEnabled()) break block20;
                        logger.debug(unsatisfiedLinkError.getMessage());
                        break block20;
                    }
                }
                while (n++ < maxRetries && (maxBytes > 0L && DeallocatorReference.totalBytes + deallocatorReference.bytes > maxBytes || maxPhysicalBytes > 0L && l > maxPhysicalBytes)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Calling System.gc() and Pointer.trimMemory() in " + this);
                    }
                    System.gc();
                    Thread.sleep(100L);
                    Pointer.trimMemory();
                    l = maxPhysicalBytes > 0L ? Pointer.physicalBytes() : 0L;
                }
            }
            if (maxBytes > 0L && DeallocatorReference.totalBytes + deallocatorReference.bytes > maxBytes) {
                this.deallocate();
                throw new OutOfMemoryError("Failed to allocate memory within limits: totalBytes (" + Pointer.formatBytes(DeallocatorReference.totalBytes) + " + " + Pointer.formatBytes(deallocatorReference.bytes) + ") > maxBytes (" + Pointer.formatBytes(maxBytes) + ")");
            }
            if (maxPhysicalBytes > 0L && l > maxPhysicalBytes) {
                this.deallocate();
                throw new OutOfMemoryError("Physical memory usage is too high: physicalBytes (" + Pointer.formatBytes(l) + ") > maxPhysicalBytes (" + Pointer.formatBytes(maxPhysicalBytes) + ")");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Registering " + this);
            }
            deallocatorReference.add();
            // MONITOREXIT : object
        }
        if ((object = PointerScope.getScopeIterator()) == null) return (P)this;
        while (object.hasNext()) {
            try {
                ((PointerScope)object.next()).attach(this);
                return (P)this;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return (P)this;
    }

    @Override
    public void close() {
        this.releaseReference();
    }

    public void deallocate() {
        this.deallocate(true);
    }

    public void deallocate(boolean bl) {
        DeallocatorReference deallocatorReference = (DeallocatorReference)this.deallocator;
        if (bl && this.deallocator != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Deallocating " + this);
            }
            this.deallocator.deallocate();
            this.deallocator = null;
            this.address = 0L;
        }
        if (deallocatorReference != null) {
            deallocatorReference.deallocator = null;
            deallocatorReference.clear();
            deallocatorReference.remove();
            deallocatorReference.deallocator = this.deallocator;
        }
    }

    public <P extends Pointer> P retainReference() {
        ReferenceCounter referenceCounter = (ReferenceCounter)((Object)this.deallocator);
        if (referenceCounter != null) {
            referenceCounter.retain();
        }
        return (P)this;
    }

    public boolean releaseReference() {
        DeallocatorReference deallocatorReference = (DeallocatorReference)this.deallocator;
        if (deallocatorReference != null && deallocatorReference.release()) {
            this.deallocator = null;
            this.address = 0L;
            deallocatorReference.clear();
            deallocatorReference.remove();
            return true;
        }
        return false;
    }

    public int referenceCount() {
        ReferenceCounter referenceCounter = (ReferenceCounter)((Object)this.deallocator);
        return referenceCounter != null ? referenceCounter.count() : -1;
    }

    public static int offsetof(Class<? extends Pointer> clazz, String string) {
        return Loader.offsetof(clazz, string);
    }

    public int offsetof(String string) {
        int n = -1;
        try {
            Class<?> clazz = this.getClass();
            if (clazz != Pointer.class) {
                n = Loader.offsetof(clazz, string);
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return n;
        }
        return n;
    }

    public static int sizeof(Class<? extends Pointer> clazz) {
        return Loader.sizeof(clazz);
    }

    public int sizeof() {
        Class<?> clazz = this.getClass();
        if (clazz == Pointer.class || clazz == BytePointer.class) {
            return 1;
        }
        return this.offsetof("sizeof");
    }

    private native ByteBuffer asDirectBuffer();

    public ByteBuffer asByteBuffer() {
        if (this.isNull()) {
            return null;
        }
        if (this.limit > 0L && this.limit < this.position) {
            throw new IllegalArgumentException("limit < position: (" + this.limit + " < " + this.position + ")");
        }
        int n = this.sizeof();
        Pointer pointer = new Pointer();
        pointer.address = this.address;
        return super.asDirectBuffer().order(ByteOrder.nativeOrder());
    }

    public Buffer asBuffer() {
        return this.asByteBuffer();
    }

    public static native Pointer malloc(long var0);

    public static native Pointer calloc(long var0, long var2);

    public static native Pointer realloc(Pointer var0, long var1);

    public static native void free(Pointer var0);

    public static native Pointer memchr(Pointer var0, int var1, long var2);

    public static native int memcmp(Pointer var0, Pointer var1, long var2);

    public static native Pointer memcpy(Pointer var0, Pointer var1, long var2);

    public static native Pointer memmove(Pointer var0, Pointer var1, long var2);

    public static native Pointer memset(Pointer var0, int var1, long var2);

    public <P extends Pointer> P getPointer() {
        return this.getPointer(0L);
    }

    public <P extends Pointer> P getPointer(long l) {
        return (P)this.getPointer(this.getClass(), l);
    }

    public <P extends Pointer> P getPointer(Class<P> clazz) {
        return this.getPointer(clazz, 0L);
    }

    public <P extends Pointer> P getPointer(Class<P> clazz, long l) {
        try {
            Pointer pointer = (Pointer)clazz.getDeclaredConstructor(Pointer.class).newInstance(this);
            pointer.position = this.position != 0L ? Math.max(0L, this.position * (long)this.sizeof() / (long)pointer.sizeof()) : 0L;
            pointer.limit = this.limit != 0L ? Math.max(0L, this.limit * (long)this.sizeof() / (long)pointer.sizeof()) : 0L;
            pointer.capacity = this.capacity != 0L ? Math.max(0L, this.capacity * (long)this.sizeof() / (long)pointer.sizeof()) : 0L;
            return pointer.offsetAddress(l);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public <P extends Pointer> P put(Pointer pointer) {
        if (pointer.limit > 0L && pointer.limit < pointer.position) {
            throw new IllegalArgumentException("limit < position: (" + pointer.limit + " < " + pointer.position + ")");
        }
        int n = this.sizeof();
        int n2 = pointer.sizeof();
        long l = (long)n2 * (pointer.limit <= 0L ? 1L : pointer.limit - pointer.position);
        this.position *= (long)n;
        pointer.position *= (long)n2;
        Pointer.memcpy(this, pointer, l);
        this.position /= (long)n;
        pointer.position /= (long)n2;
        return (P)this;
    }

    public <P extends Pointer> P fill(int n) {
        if (this.limit > 0L && this.limit < this.position) {
            throw new IllegalArgumentException("limit < position: (" + this.limit + " < " + this.position + ")");
        }
        int n2 = this.sizeof();
        long l = (long)n2 * (this.limit <= 0L ? 1L : this.limit - this.position);
        this.position *= (long)n2;
        Pointer.memset(this, n, l);
        this.position /= (long)n2;
        return (P)this;
    }

    public <P extends Pointer> P zero() {
        return this.fill(0);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return this.isNull();
        }
        if (object.getClass() != this.getClass() && object.getClass() != Pointer.class && this.getClass() != Pointer.class) {
            return false;
        }
        Pointer pointer = (Pointer)object;
        return this.address == pointer.address && this.position == pointer.position;
    }

    public int hashCode() {
        return (int)this.address;
    }

    public String toString() {
        return this.getClass().getName() + "[address=0x" + Long.toHexString(this.address) + ",position=" + this.position + ",limit=" + this.limit + ",capacity=" + this.capacity + ",deallocator=" + this.deallocator + "]";
    }

    static {
        block16: {
            long l;
            logger = Logger.create(Pointer.class);
            String string = System.getProperty("org.bytedeco.javacpp.nopointergc", "false").toLowerCase();
            if ((string = System.getProperty("org.bytedeco.javacpp.noPointerGC", string).toLowerCase()).equals("true") || string.equals("t") || string.equals("")) {
                referenceQueue = null;
                deallocatorThread = null;
            } else {
                referenceQueue = new ReferenceQueue();
                deallocatorThread = new DeallocatorThread();
            }
            long l2 = l = Runtime.getRuntime().maxMemory();
            string = System.getProperty("org.bytedeco.javacpp.maxbytes");
            string = System.getProperty("org.bytedeco.javacpp.maxBytes", string);
            if (string != null && string.length() > 0) {
                try {
                    l2 = Pointer.parseBytes(string, l);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException(numberFormatException);
                }
            }
            l2 = (maxBytes = l2) > 0L ? maxBytes + 3L * l : 0L;
            string = System.getProperty("org.bytedeco.javacpp.maxphysicalbytes");
            if ((string = System.getProperty("org.bytedeco.javacpp.maxPhysicalBytes", string)) != null && string.length() > 0) {
                try {
                    l2 = Pointer.parseBytes(string, l);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException(numberFormatException);
                }
            }
            maxPhysicalBytes = l2;
            int n = 10;
            string = System.getProperty("org.bytedeco.javacpp.maxretries");
            if ((string = System.getProperty("org.bytedeco.javacpp.maxRetries", string)) != null && string.length() > 0) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException(numberFormatException);
                }
            }
            maxRetries = n;
            try {
                Loader.load();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) break block16;
                logger.debug("Could not load Pointer: " + throwable);
            }
        }
        String string = System.getProperty("org.bytedeco.javacpp.mxbean", "false").toLowerCase();
        if (string.equals("true") || string.equals("t") || string.equals("")) {
            try {
                Class<?> clazz = Class.forName("org.bytedeco.javacpp.tools.PointerBufferPoolMXBean");
                Method method = clazz.getDeclaredMethod("register", new Class[0]);
                method.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                logger.warn("Could not register PointerBufferPoolMXBean: " + reflectiveOperationException);
            }
        }
    }

    static class DeallocatorThread
    extends Thread {
        DeallocatorThread() {
            super("JavaCPP Deallocator");
            this.setPriority(10);
            this.setDaemon(true);
            this.setContextClassLoader(null);
            this.start();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    DeallocatorReference deallocatorReference = (DeallocatorReference)referenceQueue.remove();
                    deallocatorReference.clear();
                    deallocatorReference.remove();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    static class DeallocatorReference
    extends PhantomReference<Pointer>
    implements Deallocator,
    ReferenceCounter {
        static volatile DeallocatorReference head = null;
        volatile DeallocatorReference prev = this;
        volatile DeallocatorReference next = this;
        Deallocator deallocator;
        static volatile long totalBytes = 0L;
        static volatile long totalCount = 0L;
        long bytes;
        AtomicInteger count;

        DeallocatorReference(Pointer pointer, Deallocator deallocator) {
            super(pointer, referenceQueue);
            this.deallocator = deallocator;
            this.bytes = pointer.capacity != 0L && referenceQueue != null ? pointer.capacity * (long)pointer.sizeof() : 0L;
            this.count = new AtomicInteger(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void add() {
            Class<DeallocatorReference> clazz = DeallocatorReference.class;
            synchronized (DeallocatorReference.class) {
                if (head == null) {
                    head = this;
                    this.next = null;
                    this.prev = null;
                } else {
                    this.prev = null;
                    this.next = head;
                    this.next.prev = head = this;
                }
                totalBytes += this.bytes;
                ++totalCount;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void remove() {
            if (this.prev == this && this.next == this) {
                return;
            }
            Class<DeallocatorReference> clazz = DeallocatorReference.class;
            synchronized (DeallocatorReference.class) {
                if (this.prev == null) {
                    head = this.next;
                } else {
                    this.prev.next = this.next;
                }
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                this.prev = this.next = this;
                totalBytes -= this.bytes;
                --totalCount;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void clear() {
            super.clear();
            if (this.deallocator != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Collecting " + this);
                }
                this.deallocate();
            }
        }

        @Override
        public void deallocate() {
            if (this.deallocator != null) {
                this.deallocator.deallocate();
                this.deallocator = null;
            }
        }

        @Override
        public void retain() {
            if (this.deallocator != null) {
                this.count.incrementAndGet();
            }
        }

        @Override
        public boolean release() {
            if (this.deallocator != null && this.count.decrementAndGet() <= 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Releasing " + this);
                }
                this.deallocate();
                return true;
            }
            return false;
        }

        @Override
        public int count() {
            return this.deallocator != null ? this.count.get() : -1;
        }

        public String toString() {
            return this.getClass().getName() + "[deallocator=" + this.deallocator + ",count=" + this.count + "]";
        }
    }

    static class ProxyDeallocator
    extends DeallocatorReference {
        Buffer buffer;
        Pointer pointer;

        public ProxyDeallocator(Pointer pointer, Buffer buffer) {
            super(pointer, (Deallocator)null);
            this.deallocator = this;
            this.buffer = buffer;
        }

        public ProxyDeallocator(Pointer pointer, Pointer pointer2) {
            super(pointer, (Deallocator)null);
            this.deallocator = this;
            this.pointer = pointer2;
        }

        @Override
        public void deallocate() {
            this.buffer = null;
            if (this.pointer != null) {
                this.pointer.deallocate();
            }
        }

        @Override
        public void retain() {
            if (this.pointer != null) {
                this.pointer.retainReference();
            }
        }

        @Override
        public boolean release() {
            return this.pointer != null ? this.pointer.releaseReference() : false;
        }

        @Override
        public int count() {
            return this.pointer != null ? this.pointer.referenceCount() : -1;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "[buffer=" + this.buffer + ",pointer=" + this.pointer + "]";
        }
    }

    protected static class NativeDeallocator
    extends DeallocatorReference {
        private long ownerAddress;
        private long deallocatorAddress;

        NativeDeallocator(Pointer pointer, long l, long l2) {
            super(pointer, (Deallocator)null);
            this.deallocator = this;
            this.ownerAddress = l;
            this.deallocatorAddress = l2;
        }

        public long ownerAddress() {
            return this.ownerAddress;
        }

        public long deallocatorAddress() {
            return this.deallocatorAddress;
        }

        @Override
        public void deallocate() {
            if (this.ownerAddress != 0L && this.deallocatorAddress != 0L) {
                this.deallocate(this.ownerAddress, this.deallocatorAddress);
                this.deallocatorAddress = 0L;
                this.ownerAddress = 0L;
            }
        }

        private native void deallocate(long var1, long var3);

        @Override
        public String toString() {
            return this.getClass().getName() + "[ownerAddress=0x" + Long.toHexString(this.ownerAddress) + ",deallocatorAddress=0x" + Long.toHexString(this.deallocatorAddress) + "]";
        }
    }

    protected static class CustomDeallocator
    extends DeallocatorReference {
        Pointer pointer = null;
        Method method = null;

        public CustomDeallocator(Pointer pointer) {
            super(pointer, (Deallocator)null);
            this.deallocator = this;
            Class<?> clazz = pointer.getClass();
            for (Method method : clazz.getDeclaredMethods()) {
                Class<?>[] classArray = method.getParameterTypes();
                if (!Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) || !method.getName().equals("deallocate") || classArray.length != 1 || !Pointer.class.isAssignableFrom(classArray[0])) continue;
                method.setAccessible(true);
                this.method = method;
                break;
            }
            if (this.method == null) {
                throw new RuntimeException(new NoSuchMethodException("static void " + clazz.getCanonicalName() + ".deallocate(" + Pointer.class.getCanonicalName() + ")"));
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(Pointer.class);
                constructor.setAccessible(true);
                this.pointer = (Pointer)constructor.newInstance(pointer);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void deallocate() {
            try {
                this.method.invoke(null, this.pointer);
                this.pointer.setNull();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "[pointer=" + this.pointer + ",method=" + this.method + "]";
        }
    }

    protected static interface ReferenceCounter {
        public void retain();

        public boolean release();

        public int count();
    }

    protected static interface Deallocator {
        public void deallocate();
    }
}

