/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.Index;

public class ByteBufferIndexer
extends ByteIndexer {
    protected ByteBuffer buffer;

    public ByteBufferIndexer(ByteBuffer byteBuffer) {
        this(byteBuffer, Index.create((long)byteBuffer.limit()));
    }

    public ByteBufferIndexer(ByteBuffer byteBuffer, long ... lArray) {
        this(byteBuffer, Index.create(lArray));
    }

    public ByteBufferIndexer(ByteBuffer byteBuffer, long[] lArray, long[] lArray2) {
        this(byteBuffer, Index.create(lArray, lArray2));
    }

    public ByteBufferIndexer(ByteBuffer byteBuffer, Index index) {
        super(index);
        this.buffer = byteBuffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    public ByteIndexer reindex(Index index) {
        return new ByteBufferIndexer(this.buffer, index);
    }

    @Override
    public byte get(long l) {
        return this.buffer.get((int)this.index(l));
    }

    @Override
    public ByteIndexer get(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.buffer.get((int)this.index(l) + i);
        }
        return this;
    }

    @Override
    public byte get(long l, long l2) {
        return this.buffer.get((int)this.index(l, l2));
    }

    @Override
    public ByteIndexer get(long l, long l2, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.buffer.get((int)this.index(l, l2) + i);
        }
        return this;
    }

    @Override
    public byte get(long l, long l2, long l3) {
        return this.buffer.get((int)this.index(l, l2, l3));
    }

    @Override
    public byte get(long ... lArray) {
        return this.buffer.get((int)this.index(lArray));
    }

    @Override
    public ByteIndexer get(long[] lArray, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.buffer.get((int)this.index(lArray) + i);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long l, byte by) {
        this.buffer.put((int)this.index(l), by);
        return this;
    }

    @Override
    public ByteIndexer put(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.buffer.put((int)this.index(l) + i, byArray[n + i]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long l, long l2, byte by) {
        this.buffer.put((int)this.index(l, l2), by);
        return this;
    }

    @Override
    public ByteIndexer put(long l, long l2, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.buffer.put((int)this.index(l, l2) + i, byArray[n + i]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long l, long l2, long l3, byte by) {
        this.buffer.put((int)this.index(l, l2, l3), by);
        return this;
    }

    @Override
    public ByteIndexer put(long[] lArray, byte by) {
        this.buffer.put((int)this.index(lArray), by);
        return this;
    }

    @Override
    public ByteIndexer put(long[] lArray, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.buffer.put((int)this.index(lArray) + i, byArray[n + i]);
        }
        return this;
    }

    @Override
    public byte getByte(long l) {
        return this.buffer.get((int)l);
    }

    @Override
    public ByteIndexer putByte(long l, byte by) {
        this.buffer.put((int)l, by);
        return this;
    }

    @Override
    public short getShort(long l) {
        return this.buffer.getShort((int)l);
    }

    @Override
    public ByteIndexer putShort(long l, short s) {
        this.buffer.putShort((int)l, s);
        return this;
    }

    @Override
    public int getInt(long l) {
        return this.buffer.getInt((int)l);
    }

    @Override
    public ByteIndexer putInt(long l, int n) {
        this.buffer.putInt((int)l, n);
        return this;
    }

    @Override
    public long getLong(long l) {
        return this.buffer.getLong((int)l);
    }

    @Override
    public ByteIndexer putLong(long l, long l2) {
        this.buffer.putLong((int)l, l2);
        return this;
    }

    @Override
    public float getFloat(long l) {
        return this.buffer.getFloat((int)l);
    }

    @Override
    public ByteIndexer putFloat(long l, float f) {
        this.buffer.putFloat((int)l, f);
        return this;
    }

    @Override
    public double getDouble(long l) {
        return this.buffer.getDouble((int)l);
    }

    @Override
    public ByteIndexer putDouble(long l, double d) {
        this.buffer.putDouble((int)l, d);
        return this;
    }

    @Override
    public char getChar(long l) {
        return this.buffer.getChar((int)l);
    }

    @Override
    public ByteIndexer putChar(long l, char c) {
        this.buffer.putChar((int)l, c);
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

