/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;

public class ByteRawIndexer
extends ByteIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected BytePointer pointer;
    final long base;
    final long size;

    public ByteRawIndexer(BytePointer bytePointer) {
        this(bytePointer, Index.create(bytePointer.limit() - bytePointer.position()));
    }

    public ByteRawIndexer(BytePointer bytePointer, long ... lArray) {
        this(bytePointer, lArray, ByteRawIndexer.strides(lArray));
    }

    public ByteRawIndexer(BytePointer bytePointer, long[] lArray, long[] lArray2) {
        this(bytePointer, Index.create(lArray, lArray2));
    }

    public ByteRawIndexer(BytePointer bytePointer, Index index) {
        super(index);
        this.pointer = bytePointer;
        this.base = bytePointer.address() + bytePointer.position();
        this.size = bytePointer.limit() - bytePointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public ByteIndexer reindex(Index index) {
        return new ByteRawIndexer(this.pointer, index);
    }

    public byte getRaw(long l) {
        return RAW.getByte(this.base + ByteRawIndexer.checkIndex(l, this.size));
    }

    @Override
    public byte get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public ByteIndexer get(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.getRaw(this.index(l) + (long)i);
        }
        return this;
    }

    @Override
    public byte get(long l, long l2) {
        return this.getRaw(this.index(l, l2));
    }

    @Override
    public ByteIndexer get(long l, long l2, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.getRaw(this.index(l, l2) + (long)i);
        }
        return this;
    }

    @Override
    public byte get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3));
    }

    @Override
    public byte get(long ... lArray) {
        return this.getRaw(this.index(lArray));
    }

    @Override
    public ByteIndexer get(long[] lArray, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.getRaw(this.index(lArray) + (long)i);
        }
        return this;
    }

    public ByteIndexer putRaw(long l, byte by) {
        RAW.putByte(this.base + ByteRawIndexer.checkIndex(l, this.size), by);
        return this;
    }

    @Override
    public ByteIndexer put(long l, byte by) {
        return this.putRaw(this.index(l), by);
    }

    @Override
    public ByteIndexer put(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, byArray[n + i]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long l, long l2, byte by) {
        this.putRaw(this.index(l, l2), by);
        return this;
    }

    @Override
    public ByteIndexer put(long l, long l2, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, byArray[n + i]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long l, long l2, long l3, byte by) {
        this.putRaw(this.index(l, l2, l3), by);
        return this;
    }

    @Override
    public ByteIndexer put(long[] lArray, byte by) {
        this.putRaw(this.index(lArray), by);
        return this;
    }

    @Override
    public ByteIndexer put(long[] lArray, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, byArray[n + i]);
        }
        return this;
    }

    @Override
    public byte getByte(long l) {
        return RAW.getByte(this.base + ByteRawIndexer.checkIndex(l, this.size - 1L));
    }

    @Override
    public ByteIndexer putByte(long l, byte by) {
        RAW.putByte(this.base + ByteRawIndexer.checkIndex(l, this.size - 1L), by);
        return this;
    }

    @Override
    public short getShort(long l) {
        return RAW.getShort(this.base + ByteRawIndexer.checkIndex(l, this.size - 1L));
    }

    @Override
    public ByteIndexer putShort(long l, short s) {
        RAW.putShort(this.base + ByteRawIndexer.checkIndex(l, this.size - 1L), s);
        return this;
    }

    @Override
    public int getInt(long l) {
        return RAW.getInt(this.base + ByteRawIndexer.checkIndex(l, this.size - 3L));
    }

    @Override
    public ByteIndexer putInt(long l, int n) {
        RAW.putInt(this.base + ByteRawIndexer.checkIndex(l, this.size - 3L), n);
        return this;
    }

    @Override
    public long getLong(long l) {
        return RAW.getLong(this.base + ByteRawIndexer.checkIndex(l, this.size - 7L));
    }

    @Override
    public ByteIndexer putLong(long l, long l2) {
        RAW.putLong(this.base + ByteRawIndexer.checkIndex(l, this.size - 7L), l2);
        return this;
    }

    @Override
    public float getFloat(long l) {
        return RAW.getFloat(this.base + ByteRawIndexer.checkIndex(l, this.size - 3L));
    }

    @Override
    public ByteIndexer putFloat(long l, float f) {
        RAW.putFloat(this.base + ByteRawIndexer.checkIndex(l, this.size - 3L), f);
        return this;
    }

    @Override
    public double getDouble(long l) {
        return RAW.getDouble(this.base + ByteRawIndexer.checkIndex(l, this.size - 7L));
    }

    @Override
    public ByteIndexer putDouble(long l, double d) {
        RAW.putDouble(this.base + ByteRawIndexer.checkIndex(l, this.size - 7L), d);
        return this;
    }

    @Override
    public char getChar(long l) {
        return RAW.getChar(this.base + ByteRawIndexer.checkIndex(l, this.size - 1L));
    }

    @Override
    public ByteIndexer putChar(long l, char c) {
        RAW.putChar(this.base + ByteRawIndexer.checkIndex(l, this.size - 1L), c);
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

