/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;

public class DoubleRawIndexer
extends DoubleIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected DoublePointer pointer;
    final long base;
    final long size;

    public DoubleRawIndexer(DoublePointer doublePointer) {
        this(doublePointer, Index.create(doublePointer.limit() - doublePointer.position()));
    }

    public DoubleRawIndexer(DoublePointer doublePointer, long ... lArray) {
        this(doublePointer, Index.create(lArray));
    }

    public DoubleRawIndexer(DoublePointer doublePointer, long[] lArray, long[] lArray2) {
        this(doublePointer, Index.create(lArray, lArray2));
    }

    public DoubleRawIndexer(DoublePointer doublePointer, Index index) {
        super(index);
        this.pointer = doublePointer;
        this.base = doublePointer.address() + doublePointer.position() * 8L;
        this.size = doublePointer.limit() - doublePointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public DoubleIndexer reindex(Index index) {
        return new DoubleRawIndexer(this.pointer, index);
    }

    public double getRaw(long l) {
        return RAW.getDouble(this.base + DoubleRawIndexer.checkIndex(l, this.size) * 8L);
    }

    @Override
    public double get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public DoubleIndexer get(long l, double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.getRaw(this.index(l) + (long)i);
        }
        return this;
    }

    @Override
    public double get(long l, long l2) {
        return this.getRaw(this.index(l, l2));
    }

    @Override
    public DoubleIndexer get(long l, long l2, double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.getRaw(this.index(l, l2) + (long)i);
        }
        return this;
    }

    @Override
    public double get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3));
    }

    @Override
    public double get(long ... lArray) {
        return this.getRaw(this.index(lArray));
    }

    @Override
    public DoubleIndexer get(long[] lArray, double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.getRaw(this.index(lArray) + (long)i);
        }
        return this;
    }

    public DoubleIndexer putRaw(long l, double d) {
        RAW.putDouble(this.base + DoubleRawIndexer.checkIndex(l, this.size) * 8L, d);
        return this;
    }

    @Override
    public DoubleIndexer put(long l, double d) {
        return this.putRaw(this.index(l), d);
    }

    @Override
    public DoubleIndexer put(long l, double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, dArray[n + i]);
        }
        return this;
    }

    @Override
    public DoubleIndexer put(long l, long l2, double d) {
        this.putRaw(this.index(l, l2), d);
        return this;
    }

    @Override
    public DoubleIndexer put(long l, long l2, double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, dArray[n + i]);
        }
        return this;
    }

    @Override
    public DoubleIndexer put(long l, long l2, long l3, double d) {
        this.putRaw(this.index(l, l2, l3), d);
        return this;
    }

    @Override
    public DoubleIndexer put(long[] lArray, double d) {
        this.putRaw(this.index(lArray), d);
        return this;
    }

    @Override
    public DoubleIndexer put(long[] lArray, double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, dArray[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

