/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.FloatBuffer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.indexer.FloatArrayIndexer;
import org.bytedeco.javacpp.indexer.FloatBufferIndexer;
import org.bytedeco.javacpp.indexer.FloatRawIndexer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.Raw;

public abstract class FloatIndexer
extends Indexer {
    public static final int VALUE_BYTES = 4;

    protected FloatIndexer(Index index) {
        super(index);
    }

    protected FloatIndexer(long[] lArray, long[] lArray2) {
        super(lArray, lArray2);
    }

    public static FloatIndexer create(float[] fArray) {
        return new FloatArrayIndexer(fArray);
    }

    public static FloatIndexer create(FloatBuffer floatBuffer) {
        return new FloatBufferIndexer(floatBuffer);
    }

    public static FloatIndexer create(FloatPointer floatPointer) {
        return new FloatRawIndexer(floatPointer);
    }

    public static FloatIndexer create(float[] fArray, Index index) {
        return new FloatArrayIndexer(fArray, index);
    }

    public static FloatIndexer create(FloatBuffer floatBuffer, Index index) {
        return new FloatBufferIndexer(floatBuffer, index);
    }

    public static FloatIndexer create(FloatPointer floatPointer, Index index) {
        return new FloatRawIndexer(floatPointer, index);
    }

    public static FloatIndexer create(float[] fArray, long ... lArray) {
        return new FloatArrayIndexer(fArray, lArray);
    }

    public static FloatIndexer create(FloatBuffer floatBuffer, long ... lArray) {
        return new FloatBufferIndexer(floatBuffer, lArray);
    }

    public static FloatIndexer create(FloatPointer floatPointer, long ... lArray) {
        return new FloatRawIndexer(floatPointer, lArray);
    }

    public static FloatIndexer create(float[] fArray, long[] lArray, long[] lArray2) {
        return new FloatArrayIndexer(fArray, lArray, lArray2);
    }

    public static FloatIndexer create(FloatBuffer floatBuffer, long[] lArray, long[] lArray2) {
        return new FloatBufferIndexer(floatBuffer, lArray, lArray2);
    }

    public static FloatIndexer create(FloatPointer floatPointer, long[] lArray, long[] lArray2) {
        return new FloatRawIndexer(floatPointer, lArray, lArray2);
    }

    public static FloatIndexer create(FloatPointer floatPointer, long[] lArray, long[] lArray2, boolean bl) {
        return FloatIndexer.create(floatPointer, Index.create(lArray, lArray2), bl);
    }

    public static FloatIndexer create(final FloatPointer floatPointer, Index index, boolean bl) {
        if (bl) {
            return Raw.getInstance() != null ? new FloatRawIndexer(floatPointer, index) : new FloatBufferIndexer(floatPointer.asBuffer(), index);
        }
        final long l = floatPointer.position();
        float[] fArray = new float[(int)Math.min(floatPointer.limit() - l, Integer.MAX_VALUE)];
        floatPointer.get(fArray);
        return new FloatArrayIndexer(fArray, index){

            @Override
            public void release() {
                floatPointer.position(l).put(this.array);
                super.release();
            }
        };
    }

    public abstract float get(long var1);

    public FloatIndexer get(long l, float[] fArray) {
        return this.get(l, fArray, 0, fArray.length);
    }

    public abstract FloatIndexer get(long var1, float[] var3, int var4, int var5);

    public abstract float get(long var1, long var3);

    public FloatIndexer get(long l, long l2, float[] fArray) {
        return this.get(l, l2, fArray, 0, fArray.length);
    }

    public abstract FloatIndexer get(long var1, long var3, float[] var5, int var6, int var7);

    public abstract float get(long var1, long var3, long var5);

    public abstract float get(long ... var1);

    public FloatIndexer get(long[] lArray, float[] fArray) {
        return this.get(lArray, fArray, 0, fArray.length);
    }

    public abstract FloatIndexer get(long[] var1, float[] var2, int var3, int var4);

    public abstract FloatIndexer put(long var1, float var3);

    public FloatIndexer put(long l, float ... fArray) {
        return this.put(l, fArray, 0, fArray.length);
    }

    public abstract FloatIndexer put(long var1, float[] var3, int var4, int var5);

    public abstract FloatIndexer put(long var1, long var3, float var5);

    public FloatIndexer put(long l, long l2, float ... fArray) {
        return this.put(l, l2, fArray, 0, fArray.length);
    }

    public abstract FloatIndexer put(long var1, long var3, float[] var5, int var6, int var7);

    public abstract FloatIndexer put(long var1, long var3, long var5, float var7);

    public abstract FloatIndexer put(long[] var1, float var2);

    public FloatIndexer put(long[] lArray, float ... fArray) {
        return this.put(lArray, fArray, 0, fArray.length);
    }

    public abstract FloatIndexer put(long[] var1, float[] var2, int var3, int var4);

    @Override
    public double getDouble(long ... lArray) {
        return this.get(lArray);
    }

    @Override
    public FloatIndexer putDouble(long[] lArray, double d) {
        return this.put(lArray, (float)d);
    }
}

