/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;

public class HalfRawIndexer
extends HalfIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected ShortPointer pointer;
    final long base;
    final long size;

    public HalfRawIndexer(ShortPointer shortPointer) {
        this(shortPointer, Index.create(shortPointer.limit() - shortPointer.position()));
    }

    public HalfRawIndexer(ShortPointer shortPointer, long ... lArray) {
        this(shortPointer, Index.create(lArray));
    }

    public HalfRawIndexer(ShortPointer shortPointer, long[] lArray, long[] lArray2) {
        this(shortPointer, Index.create(lArray, lArray2));
    }

    public HalfRawIndexer(ShortPointer shortPointer, Index index) {
        super(index);
        this.pointer = shortPointer;
        this.base = shortPointer.address() + shortPointer.position() * 2L;
        this.size = shortPointer.limit() - shortPointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public HalfIndexer reindex(Index index) {
        return new HalfRawIndexer(this.pointer, index);
    }

    public float getRaw(long l) {
        return HalfRawIndexer.toFloat(RAW.getShort(this.base + HalfRawIndexer.checkIndex(l, this.size) * 2L));
    }

    @Override
    public float get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public HalfIndexer get(long l, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.getRaw(this.index(l) + (long)i);
        }
        return this;
    }

    @Override
    public float get(long l, long l2) {
        return this.getRaw(this.index(l, l2));
    }

    @Override
    public HalfIndexer get(long l, long l2, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.getRaw(this.index(l, l2) + (long)i);
        }
        return this;
    }

    @Override
    public float get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3));
    }

    @Override
    public float get(long ... lArray) {
        return this.getRaw(this.index(lArray));
    }

    @Override
    public HalfIndexer get(long[] lArray, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.getRaw(this.index(lArray) + (long)i);
        }
        return this;
    }

    public HalfIndexer putRaw(long l, float f) {
        RAW.putShort(this.base + HalfRawIndexer.checkIndex(l, this.size) * 2L, (short)HalfRawIndexer.fromFloat(f));
        return this;
    }

    @Override
    public HalfIndexer put(long l, float f) {
        return this.putRaw(this.index(l), f);
    }

    @Override
    public HalfIndexer put(long l, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, fArray[n + i]);
        }
        return this;
    }

    @Override
    public HalfIndexer put(long l, long l2, float f) {
        this.putRaw(this.index(l, l2), f);
        return this;
    }

    @Override
    public HalfIndexer put(long l, long l2, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, fArray[n + i]);
        }
        return this;
    }

    @Override
    public HalfIndexer put(long l, long l2, long l3, float f) {
        this.putRaw(this.index(l, l2, l3), f);
        return this;
    }

    @Override
    public HalfIndexer put(long[] lArray, float f) {
        this.putRaw(this.index(lArray), f);
        return this;
    }

    @Override
    public HalfIndexer put(long[] lArray, float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, fArray[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

