/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.math.BigInteger;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;
import org.bytedeco.javacpp.indexer.ULongIndexer;

public class ULongRawIndexer
extends ULongIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected LongPointer pointer;
    final long base;
    final long size;

    public ULongRawIndexer(LongPointer longPointer) {
        this(longPointer, Index.create(longPointer.limit() - longPointer.position()));
    }

    public ULongRawIndexer(LongPointer longPointer, long ... lArray) {
        this(longPointer, Index.create(lArray));
    }

    public ULongRawIndexer(LongPointer longPointer, long[] lArray, long[] lArray2) {
        this(longPointer, Index.create(lArray, lArray2));
    }

    public ULongRawIndexer(LongPointer longPointer, Index index) {
        super(index);
        this.pointer = longPointer;
        this.base = longPointer.address() + longPointer.position() * 8L;
        this.size = longPointer.limit() - longPointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public ULongIndexer reindex(Index index) {
        return new ULongRawIndexer(this.pointer, index);
    }

    public BigInteger getRaw(long l) {
        return ULongRawIndexer.toBigInteger(RAW.getLong(this.base + ULongRawIndexer.checkIndex(l, this.size) * 8L));
    }

    @Override
    public BigInteger get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public ULongIndexer get(long l, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            bigIntegerArray[n + i] = this.getRaw(this.index(l) + (long)i);
        }
        return this;
    }

    @Override
    public BigInteger get(long l, long l2) {
        return this.getRaw(this.index(l, l2));
    }

    @Override
    public ULongIndexer get(long l, long l2, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            bigIntegerArray[n + i] = this.getRaw(this.index(l, l2) + (long)i);
        }
        return this;
    }

    @Override
    public BigInteger get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3));
    }

    @Override
    public BigInteger get(long ... lArray) {
        return this.getRaw(this.index(lArray));
    }

    @Override
    public ULongIndexer get(long[] lArray, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            bigIntegerArray[n + i] = this.getRaw(this.index(lArray) + (long)i);
        }
        return this;
    }

    public ULongIndexer putRaw(long l, BigInteger bigInteger) {
        RAW.putLong(this.base + ULongRawIndexer.checkIndex(l, this.size) * 8L, ULongRawIndexer.fromBigInteger(bigInteger));
        return this;
    }

    @Override
    public ULongIndexer put(long l, BigInteger bigInteger) {
        return this.putRaw(this.index(l), bigInteger);
    }

    @Override
    public ULongIndexer put(long l, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, bigIntegerArray[n + i]);
        }
        return this;
    }

    @Override
    public ULongIndexer put(long l, long l2, BigInteger bigInteger) {
        this.putRaw(this.index(l, l2), bigInteger);
        return this;
    }

    @Override
    public ULongIndexer put(long l, long l2, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, bigIntegerArray[n + i]);
        }
        return this;
    }

    @Override
    public ULongIndexer put(long l, long l2, long l3, BigInteger bigInteger) {
        this.putRaw(this.index(l, l2, l3), bigInteger);
        return this;
    }

    @Override
    public ULongIndexer put(long[] lArray, BigInteger bigInteger) {
        this.putRaw(this.index(lArray), bigInteger);
        return this;
    }

    @Override
    public ULongIndexer put(long[] lArray, BigInteger[] bigIntegerArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, bigIntegerArray[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

