/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.Loader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;

public class ConsoleAppender<E>
extends OutputStreamAppender<E> {
    protected ConsoleTarget target = ConsoleTarget.SystemOut;
    protected boolean withJansi = false;
    private static final String AnsiConsole_CLASS_NAME = "org.fusesource.jansi.AnsiConsole";
    private static final String JANSI2_OUT_METHOD_NAME = "out";
    private static final String JANSI2_ERR_METHOD_NAME = "err";
    private static final String wrapSystemOut_METHOD_NAME = "wrapSystemOut";
    private static final String wrapSystemErr_METHOD_NAME = "wrapSystemErr";
    private static final Class<?>[] ARGUMENT_TYPES = new Class[]{PrintStream.class};

    public void setTarget(String string) {
        ConsoleTarget consoleTarget = ConsoleTarget.findByName(string.trim());
        if (consoleTarget == null) {
            this.targetWarn(string);
        } else {
            this.target = consoleTarget;
        }
    }

    public String getTarget() {
        return this.target.getName();
    }

    private void targetWarn(String string) {
        WarnStatus warnStatus = new WarnStatus("[" + string + "] should be one of " + Arrays.toString((Object[])ConsoleTarget.values()), this);
        warnStatus.add(new WarnStatus("Using previously set target, System.out by default.", this));
        this.addStatus(warnStatus);
    }

    @Override
    public void start() {
        OutputStream outputStream = this.target.getStream();
        if (this.withJansi) {
            outputStream = this.wrapWithJansi(outputStream);
        }
        this.setOutputStream(outputStream);
        super.start();
    }

    private OutputStream wrapWithJansi(OutputStream outputStream) {
        try {
            this.addInfo("Enabling JANSI AnsiPrintStream for the console.");
            ClassLoader classLoader = Loader.getClassLoaderOfObject(this.context);
            Class<?> clazz = classLoader.loadClass(AnsiConsole_CLASS_NAME);
            String string = this.target == ConsoleTarget.SystemOut ? JANSI2_OUT_METHOD_NAME : JANSI2_ERR_METHOD_NAME;
            Optional<Method> optional = Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals(string)).filter(method -> method.getParameters().length == 0).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> PrintStream.class.isAssignableFrom(method.getReturnType())).findAny();
            if (optional.isPresent()) {
                Method method2 = optional.orElseThrow(() -> new NoSuchElementException("No value present"));
                return (PrintStream)method2.invoke(null, new Object[0]);
            }
            String string2 = this.target == ConsoleTarget.SystemOut ? wrapSystemOut_METHOD_NAME : wrapSystemErr_METHOD_NAME;
            Method method3 = clazz.getMethod(string2, ARGUMENT_TYPES);
            return (OutputStream)method3.invoke(null, new PrintStream(outputStream));
        }
        catch (Exception exception) {
            this.addWarn("Failed to create AnsiPrintStream. Falling back on the default stream.", exception);
            return outputStream;
        }
    }

    public boolean isWithJansi() {
        return this.withJansi;
    }

    public void setWithJansi(boolean bl) {
        this.withJansi = bl;
    }
}

