/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.SerializeModelModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

public class SerializeModelModelHandler
extends ModelHandlerBase {
    public SerializeModelModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new SerializeModelModelHandler(context);
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        Object object = modelInterpretationContext.getConfiguratorHint();
        if (object != null && object.getClass().getName().equals("ch.qos.logback.classic.joran.SerializedModelConfigurator")) {
            this.addInfo("Skipping model serialization as calling configurator is already model based.");
            return;
        }
        if (!(model instanceof SerializeModelModel)) {
            this.addWarn("Model parameter is not of type SerializeModelModel. Skipping serialization of model structure");
            return;
        }
        SerializeModelModel serializeModelModel = (SerializeModelModel)model;
        Model model2 = modelInterpretationContext.getTopModel();
        if (model2 == null) {
            this.addWarn("Could not find top most model. Skipping serialization of model structure.");
            return;
        }
        Object object2 = serializeModelModel.getFile();
        if (object2 == null) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmm");
            Instant instant = Instant.now();
            String string = dateTimeFormatter.format(instant);
            object2 = "logback-" + string + ".scmo";
            this.addInfo("For model serialization, using default file destination [" + (String)object2 + "]");
        } else {
            object2 = modelInterpretationContext.subst((String)object2);
        }
        this.writeModel((String)object2, model2);
    }

    private void writeModel(String string, Model model) {
        this.addInfo("Serializing model to file [" + string + "]");
        try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(model);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            this.addError("IO failure while serializing Model [" + string + "]");
        }
    }
}

